#include <LEDA/dictionary1.h>

#include <LEDA/skiplist.h>
#include <LEDA/ab_tree.h>
#include <LEDA/bb_tree.h>
#include <LEDA/rb_tree.h>

declare2(dictionary,int,int)
declare3(DICTIONARY,int,int,skiplist)
declare3(DICTIONARY,int,int,ab_tree)
declare3(DICTIONARY,int,int,bb_tree)


void main()

{

  DICTIONARY(int,int,skiplist) SKIP_DIC;
  dictionary(int,int)          RB_DIC;
  DICTIONARY(int,int,ab_tree)  AB_DIC;
  DICTIONARY(int,int,bb_tree)  BB_DIC;


  int     N = read_int("# keys = ");
  int* RAND = new int[N];
  int     i;
  int     n;

  init_random();

  for(i=0; i<N; i++) RAND[i] = random(0,1000000);

  float T = used_time();


  newline;
  cout << "              insert    lookup    delete";
  newline;
  newline;


  cout << "skip_dic:";
  cout.flush();
  for(i=0; i<N; i++)  SKIP_DIC.insert(RAND[i],0);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  SKIP_DIC.lookup(RAND[i]);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  SKIP_DIC.del(RAND[i]);
  cout << string("%10.2f",used_time(T));
  newline;


  cout << "rb_dic:  ";
  cout.flush();
  for(i=0; i<N; i++)  RB_DIC.insert(RAND[i],0);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  RB_DIC.lookup(RAND[i]);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  RB_DIC.del(RAND[i]);
  cout << string("%10.2f",used_time(T));
  newline;



  cout << "ab_dic:  ";
  cout.flush();
  for(i=0; i<N; i++)  AB_DIC.insert(RAND[i],0);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  AB_DIC.lookup(RAND[i]);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  AB_DIC.del(RAND[i]);
  cout << string("%10.2f",used_time(T));
  newline;




  cout << "bb_dic:  ";
  cout.flush();
  for(i=0; i<N; i++)  BB_DIC.insert(RAND[i],0);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  BB_DIC.lookup(RAND[i]);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  BB_DIC.del(RAND[i]);
  cout << string("%10.2f",used_time(T));
  newline;

}


