/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  real.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_REAL_H
#define LEDA_REAL_H

#include <LEDA/basic.h>


struct rrep { 

      double  d;     
      int count;     // reference counter

 rrep(double x=0)  { d = x; count = 1; }


  LEDA_MEMORY(rrep)

};


class real   : public LEDA_SIMPLE 
{

rrep*  ptr() const { return (rrep*)PTR; }

public:

real()               { PTR = new rrep; }
real(const double d) { PTR = new rrep(d); }
real(const int d)    { PTR = new rrep(d); }
real(const real& r)  { PTR = r.ptr();  ptr()->count++; }
void clear()         { if (--ptr()->count == 0) delete ptr(); }

~real()              { clear(); }


double operator~() const { return ptr()->d; }

double* dp()       { return &(ptr()->d); }

int round()        const { return (ptr()->d>0) ? int(ptr()->d+0.5) : int(ptr()->d-0.5); }
int trunc()        const { return int(ptr()->d); }

operator double() const { return ptr()->d; }  

real  operator-() const { return -(ptr()->d); }

real& operator=(const double x);
real& operator=(const real& x);

real& operator+=(const real& r)  { *this = ptr()->d + r.ptr()->d; return *this ; }
real& operator+=(double d)       { *this = ptr()->d + d;      return *this ; }

real& operator-=(const real& r)  { *this = ptr()->d - r.ptr()->d; return *this ; }
real& operator-=(double d)       { *this = ptr()->d - d;      return *this ; }

real& operator*=(const real& r)  { *this = ptr()->d * r.ptr()->d; return *this ; }
real& operator*=(double d)       { *this = ptr()->d * d;      return *this ; }

real& operator/=(const real& r)  { *this = ptr()->d / r.ptr()->d; return *this ; }
real& operator/=(double d)       { *this = ptr()->d / d;      return *this ; }


friend ostream& operator<<(ostream&, const real&);
friend istream& operator>>(istream&, real&); 

friend void Print(const real& x, ostream& out = cout) { out << x.ptr()->d; }
friend void Read(real& x, istream& in = cin)    { in  >> x.ptr()->d; }


friend GenPtr Copy(const real& x)    { x.ptr()->count++;  return x.PTR; }
friend void Clear(real& x)           { x.clear(); }
friend int  compare(const real& x, const real& y) 
                                     { return compare(x.ptr()->d,y.ptr()->d); }
friend real& Access(const real&, GenPtr& p) { return *(real*)&p; }

};

//------------------------------------------------------------------------------
// REAL(cmp): reals with user defined linear order cmp
//------------------------------------------------------------------------------

#define REAL(cmp) name2(real_,cmp)

#define REALdeclare(cmp)\
struct REAL(cmp) : public real \
{  REAL(cmp)(real  r )     : real(r) {}\
   REAL(cmp)(const REAL(cmp)& r) : real(r) {}\
   REAL(cmp)() {}\
  ~REAL(cmp)() {}\
};\
\
int compare(const REAL(cmp)& x, const REAL(cmp)& y) { return cmp(x,y); }


#endif
