/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  pers_tree.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef PERS_TREE_H
#define PERS_TREE_H

#include <LEDA/basic.h>
#include <LEDA/list.h>

typedef void (*DRAW_NODE_FCT)(double,double,void*);
typedef void (*DRAW_EDGE_FCT)(double,double,double,double);

/* implementation of a node of the ephemeral red-black tree of a specific
 * persistent  node, where the colors of that persistent node through the
 * various versions can be found
 */
class NODE;
class C_NODE;
class F_NODE;
class VER_NODE;

typedef list_item version;

 
class C_NODE
{
  friend class pers_rb_tree;

  version vers_stamp;
  C_NODE* c_link[3];
  int c_right;
  int c_color;
  int col_value;

  LEDA_MEMORY(C_NODE)
};

/* implementation of a node of the  ephemeral red-black tree of a specific
 * persistent node, where the children of that persistent node through the
 * various versions can be found
 */
 
class F_NODE
{
  friend class pers_rb_tree;

  version ver_stamp;
  F_NODE* f_link[3];
  int f_right;
  int f_color;
  NODE* poin_value;

  LEDA_MEMORY(F_NODE)
};


/* implementation of a persistent node */

class NODE
{
  friend class pers_rb_tree;

  void *key;
  void *info;
  NODE *parent;
  int right;
  int is_leaf;
  F_NODE *link[2];
  C_NODE *red;
  F_NODE *copy;

  NODE* next;  // linking all used NODES

  LEDA_MEMORY(NODE)
};

/* implementation of a node (or member) of the version list */

class VER_NODE
{ 
  friend class pers_rb_tree;

  NODE*  acc_pointer;
  int    popul;
  double ser_num;

  LEDA_MEMORY(VER_NODE)
};

typedef VER_NODE* ver_node;

declare(list,ver_node);


struct V_LIST {

list(ver_node) vl;
int count;
NODE* used;

};



class pers_rb_tree {

protected:

V_LIST* v_list;

virtual int cmp_keys(GenPtr x, GenPtr y) { return int(x)-int(y); }
virtual void print_key(GenPtr& x)       { Print(x); }
virtual void copy_key(GenPtr& x)        { x=x; }
virtual void copy_inf(GenPtr& x)        { x=x; }
virtual void clear_key(GenPtr& x)       { x=0; }
virtual void clear_inf(GenPtr& x)       { x=0; }

 
NODE* child(int leftright, NODE *p, version i)
{ return(acc_step(p->link[leftright], i)); }

void* get_key(NODE *p, version i)
{ return (acc_step(p->copy, i))->key; }

int isleaf(NODE *p) 
{ //return (p == p->link[0]->poin_value); 
  return p->is_leaf;
 }
  
NODE* sibling(NODE *p, version i)
{ return acc_step(p->parent->link[1 - p->right], i); } 


/* define the order of versions in the version list */
int vless(version x, version y)    
{ return  (v_list->vl[x]->ser_num < v_list->vl[y]->ser_num); }

/* find the next to a given version in the version list */ 
version  iplus(version i)
{ return v_list->vl.succ(i); }


NODE*   acc_step(F_NODE *, version);
version new_version(version);
void    m_b_root(version);

F_NODE* f_nleaf(NODE*, version);
F_NODE* f_nnode(F_NODE*, F_NODE*);
F_NODE* f_rbsearch(F_NODE* p, version);
void    f_rbclear(F_NODE*);
int     f_insert(F_NODE*, NODE*, version);
void    f_single_rot(F_NODE*, int);
void    f_double_rot(F_NODE*, int);

C_NODE* c_nleaf(int, version);
C_NODE* c_nnode(C_NODE*, C_NODE*);
C_NODE* c_rbsearch(C_NODE* p, version);
void    c_rbclear(C_NODE*);
int     c_insert(C_NODE*, int, version);
void    c_single_rot(C_NODE*, int);
void    c_double_rot(C_NODE*, int);

NODE*   single_rot(NODE* top_node, int dir, version i);
NODE*   double_rot(NODE* top_node, int dir, version i);
NODE*   newnode(NODE* c1, NODE* c2, version i);
NODE*   newleaf(void* val, void* inf, NODE*, NODE*, version i);
int     isred(NODE* p, version i);
void    up_col(C_NODE* p, int newvalue, version i);
void    update(F_NODE* p, NODE* newvalue, version i);

NODE*   search(void* val, version i)     { NODE* p; return search(val,p,i);}
NODE*   search(void*, NODE*&, version);


public:

// pers_rb_tree();
//~pers_rb_tree();

void init_tree();

void* key(NODE* p)  { return p->key; }
void* inf(NODE* p)  { return p->info; }

version del(void*, version);
version insert(void*, void*, version);
version change_inf(NODE*,void*,version);

NODE* lookup(void *val,version v);
NODE* locate(void *val,version v);
NODE* locate_pred(void *val,version v);
NODE* min(version v);
NODE* max(version v);
NODE* succ(NODE* p, version v) { return child(1,p,v); }
NODE* pred(NODE* p, version v) { return child(0,p,v); }

int   size(version v) { return v_list->vl[v]->popul; }

double ver_num(version v)  { return v_list->vl[v]->ser_num; }

void print(NODE*,version);

void del_tree();

void print(version v) 
{ //cout << form("%5f : ",v_list->vl[v]->ser_num);
  print(v_list->vl[v]->acc_pointer,v);
  newline;
 }

void draw(DRAW_NODE_FCT,DRAW_EDGE_FCT, version, NODE*, double, double, double, double, double);

void draw(DRAW_NODE_FCT,DRAW_EDGE_FCT, version, double, double, double, double);

};


#endif

