/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  dp_hashing.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/





//------------------------------------------------------------------------------
// Dynamic Perfect Hashing
//
// Michael Wenzel          ( 1989/90 )
//------------------------------------------------------------------------------


#ifndef DPHASHINGH
#define DPHASHINGH

#include <LEDA/basic.h>


// ---------------------------------------------------------------
// declarations
// ---------------------------------------------------------------


class headertable;
class subtable;
class dphash;

typedef headertable* htp;
typedef subtable* stp;

#define EMPTY (GenPtr(2147483648))
#define maxuni 2147483647
                                // #define maxprim 2147483659
				// aber kleiner wegen random-Funktion
#define maxprim 2147483647
#define wursechs 2.44948974278

// --------------------------------------------------------------
// class declarations
// --------------------------------------------------------------

// --------------------------------------------------------------
// class headertable
//
// Items werden auf Headertables gehasht,
// die sie dann injektiv auf Subtables verteilen

class headertable {

  unsigned kj;                     // Multiplikator
  int wj;                          // Anzahl Elemente in Tafel
  int mj;                          // max. Anzahl Elemente
  stp tj;                          // Startpunkt der Subtables

  friend class b_dict;
  friend class dphash;
  friend class subtable;

  stp lookup(GenPtr );

  bool insert(GenPtr ,GenPtr ,stp& ,int& ,bool& ,stp ,stp );
  int dinsert(GenPtr ,GenPtr ,stp ,stp& ,stp& );

  bool del(GenPtr ,stp ,stp ); 
  int give_elements(stp& ,stp ,stp );  


  headertable()
    { 
      kj = wj = mj=0; 
      tj=0;   
     }

  LEDA_MEMORY(headertable)

};

// --------------------------------------------------------------
// class subtable
//
// Jedes Subtableelement ist leer,
// oder von der Headertable wird genau ein Element    
// auf eine Position gehasht

class subtable {

  GenPtr ke;
  GenPtr inf;

  friend class b_dict;
  friend class dphash;
  friend class headertable;

  void set_s(GenPtr a,GenPtr b)
    {
       ke=a; inf=b; }

  void clear()
    { 
       ke=EMPTY; inf=0; }

  subtable()
    {  
       ke=EMPTY; inf=0; }

  subtable(GenPtr a ,GenPtr b )
    {  
       ke=a; inf=b; }

  subtable(subtable& s)
    {  
       ke=s.ke;
       inf=s.inf; }

   subtable& operator=(subtable& s)
    {
       ke=s.ke;
       inf=s.inf;
       return *this; }

  LEDA_MEMORY(subtable)

  public:

  GenPtr key() { return ke; }

  GenPtr info() { return inf; }

};

// ------------------------------------------------------------------
// class dphash
//
// alle Informationen fuer das Dictionary
// Elemente werden auf Headertables gehasht, 
// die dann die Elemente weitergeben
// Der Platzverbrauch der Headertables wird kontrolliert


class dphash {

  htp* htablep;      // Feld von Zeigern auf Headertables
		     // leere Headertables werden nicht angelegt

  unsigned k;        // Verteilungsfunktion (k*x)%p%sM

  int n;             // Anzahl Elemente im Dictionary

  int M;             // Anzahl Elemente, die momentan bzgl.
		     // Platzverbrauch mit Wahrscheinlichkeit >= 0.5
		     // abgespeichert werden koennen ( ohne Rehash )

  int sM;            // Anzahl Headertables

  int bed;           // Kontrolle des Platzverbrauchs

  stp anf,wo,ende;   // zur Speicherverwaltung beim Rehash



  stp  rehash_all(GenPtr ,GenPtr );


  virtual void clear_key(GenPtr&)const {}
  virtual void clear_inf(GenPtr&)const {}

  virtual void copy_key(GenPtr&) const {}
  virtual void copy_inf(GenPtr&) const {}

public:

  GenPtr  key(stp it)
    { return ( it ) ? it->key() : 0 ; }

  GenPtr& info(stp it)
    { if (!it) error_handler(1,"dp_item gleich nil");
      return it->inf; }

  stp  insert(GenPtr ,GenPtr );
  void del(GenPtr );

  int  member(GenPtr );
  stp  lookup(GenPtr );

  stp  change_inf(GenPtr ,GenPtr );

  int  size()
    { return n; }

  void clear();


  dphash();
  dphash(int ,GenPtr* ,GenPtr* );
  ~dphash();


  friend class b_dict;

};

#endif DPHASHINGH
