/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  circle.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef CIRCLEH
#define CIRCLEH

#include <LEDA/point.h>
#include <LEDA/segment.h>
#include <LEDA/line.h>

//------------------------------------------------------------------------------
// circles
//------------------------------------------------------------------------------


struct circle_rep {

  double  radius;
  point   center; 
  int     count;
  
  circle_rep(point p, double r);
  circle_rep();
  
  
  LEDA_MEMORY(circle_rep)
  
};


class circle   : public LEDA_SIMPLE 
{

circle_rep* ptr() const { return (circle_rep*)PTR; }

public:

circle();
circle(const circle& l);
circle(point c, double r);
circle(double x, double y, double r);
void clear();

~circle()                { clear(); }


circle& operator=(const circle& C) { PTR = C.ptr(); ptr()->count++; return *this; }

circle operator+(const vector& v) { return translate(v); }


int operator==(const circle&) ;

int operator!=(const circle& c) { return !operator==(c); };

point center()    const  { return ptr()->center; } 
double  radius()  const  { return ptr()->radius; }


double    distance(point);
double    distance(line);
double    distance(circle);
bool    inside(point);
segment left_tangent(point);
segment right_tangent(point);

bool    outside(point p) { return !inside(p); };

circle  translate(double,double) ;
circle  translate(const vector&) ; 

circle  rotate(point, double);
circle  rotate(double);


list(point) intersection(circle);
list(point) intersection(line);
list(point) intersection(segment);

friend ostream& operator<<(ostream& out, const circle& c);
friend istream& operator>>(istream& in, circle& c);  


friend void Print(const circle& c, ostream& out = cout) { out << c; } 
friend void Read(circle& c,  istream& in = cin)   { in >> c; }

friend void   Clear(circle& c)       { c.clear(); }
friend GenPtr Copy(circle& c)  { c.ptr()->count++; return c.PTR; }
friend circle& Access(const circle&, const GenPtr& p) { return *(circle*)&p; }

};

declare(list,circle)


//------------------------------------------------------------------------------
// CIRCLE(cmp): circles with user defined linear order cmp
//------------------------------------------------------------------------------

#define CIRCLE(cmp) name2(circle_,cmp)

#define CIRCLEdeclare(cmp)\
struct CIRCLE(cmp) : public circle \
{  CIRCLE(cmp)(circle  p )          : circle(p)   {}\
   CIRCLE(cmp)(CIRCLE(cmp)& p)      : circle(p)   {}\
   CIRCLE(cmp)() {}\
 ~ CIRCLE(cmp)() {}\
};\
\
int compare(CIRCLE(cmp)& x, CIRCLE(cmp)& y) { return cmp(x,y); }


#endif
