(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Jan 28 12:09:53 PST 1992 by kalsow     *)
(*      modified on Thu Jul 11 20:58:41 1991 by muller         *)

MODULE TextRd;

IMPORT Rd, RdClass, Text;
FROM Thread IMPORT Alerted;
FROM Rd IMPORT Failure;

REVEAL
  T = Rd.T BRANDED "TextRd.T version 1.0" OBJECT
        len: CARDINAL; END;

PROCEDURE New (t: TEXT): T =
  VAR len: CARDINAL; buf: REF ARRAY OF CHAR;
  BEGIN
    len := Text.Length (t);
    buf := NEW (REF ARRAY OF CHAR, len);
    Text.SetChars (buf^, t);
    RETURN (NEW (T, st := 0, lo := 0, cur := 0, hi := len,
         buff := buf,
         closed := FALSE, seekable := TRUE, intermittent := FALSE,
         seek := Seek, length := Length,
         len := len));
  END New;

PROCEDURE Seek (rd: T; <*UNUSED*> dontBlock: BOOLEAN): RdClass.SeekResult 
     RAISES {Failure, Alerted} =
  BEGIN
    IF rd.len <= rd.cur THEN
      RETURN RdClass.SeekResult.Eof;
    ELSE
      RETURN RdClass.SeekResult.Ready; END;
  END Seek;

PROCEDURE Length (rd: T): CARDINAL RAISES {Failure, Alerted} =
  BEGIN
    RETURN rd.len;
  END Length;

BEGIN
END TextRd.

