(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Sat Aug  3 01:35:17 1991 by kalsow         *)
(*      modified on Fri Aug 17 01:50:08 1990 by muller         *)

MODULE IOFailure;

PROCEDURE Init (kind: Kind): T =
  VAR f := NEW (T);
  BEGIN
    f^ := kind;
    RETURN f;
  END Init;

BEGIN
  open  := Init (Kind.open);
  close := Init (Kind.close);
  fcntl := Init (Kind.fcntl);
  read  := Init (Kind.read);
  write := Init (Kind.write);
  lseek := Init (Kind.lseek);
  fstat := Init (Kind.fstat);
END IOFailure.
