(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Fri Mar 20 14:02:59 PST 1992 by muller                   *)

UNSAFE INTERFACE RTHeapEvent;

IMPORT RTHeapRep;

TYPE
  Kind = { (* program -> tool *)
           CollectionStart, PromotedRoots, Flip, CollectionStop,
           Grow, ChangePages, Bye, CollectionProhibited,
 
           (* tool -> program *)
           CollectNow, EnableCollection, DisableCollection};

  T = RECORD
        kind : Kind;
        first: RTHeapRep.Page := RTHeapRep.InvalidPage;
        nb   : CARDINAL       := 1;
        desc := RTHeapRep.Desc {space := RTHeapRep.Space.Unallocated,
                                type := RTHeapRep.Type.Header,
                                promoted := RTHeapRep.Promotion.Allocated,
                                link := RTHeapRep.InvalidPage}; END;

END RTHeapEvent.
