(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Nov 28 09:31:04 1989 by muller         *)
(*      modified on Fri Sep 29 11:06:31 1989 by kalsow         *)
(*      modified on Mon Sep  5 18:13:04 1988 by stolfi         *)
(*      modified on Fri Jun 10 14:22:40 PDT 1988 by glassman   *)

INTERFACE ParseShell;

(* Parse a Unix shell command, including quotes and backwhacks

   ParseShellCommand exports routines for breaking a Unix shell command
   into separate arguments, with quotes and backwhacks taken into
   account. Ivy's "fast filter" function would be a typical client
   of this interface.

   Index: shell, command parsing; Unix, command parsing;
          parsing, Unix commands; command line parsing *)

IMPORT Text, List, Scan;

TYPE
  Args = REF ARRAY OF Text.T; (* element [0] is command name *)

PROCEDURE ToList (command: Text.T): List.T RAISES {Scan.BadFormat};
(* Breaks the given command text into a list of words
  (command name and arguments), honoring quotes and backwhacks
  according to the Unix sh/csh syntax.
  SYNTAX: A character is quoted if it is enclosed in unquoted '' or "",
  or preceded by an unquoted backwhack.  A blank character is an
  unquoted space, TAB, or newline.  A raw word is a maximal sequence of
  consecutive non-blank characters.  A word is a raw word minus all
  unquoted '"\ characters.
  Raises Rd.Scanfailed if the command has an odd number of
  unquoted ' or ", or ends with an unquoted backwhack. *)

PROCEDURE ArgsToList (args: Args): List.T;
(* Converts the given word array into a word list *)

PROCEDURE ListToArgs (list: List.T;  old: Args := NIL): Args;
(* Converts the given word list to a word array.
  If the "old" array is given, the procedure appends its
  elements (except element [0]) to the resulting array.
  If "list" is NIL, the result is the array "old" itself. *)

END ParseShell.

