extern char *malloc(), *realloc();

# line 2 "parser.y"
/* ******************************************************************* *\
*									*
*   File: scorpion/src/xref/frontend/parser.y
*									*
*   Copyright (C) 1991 Dean Throop
*									*
*   The Scorpion System is free software in the public domain; you can  *
*   redistribute it and/or modify it as you wish. We ask that you 	*
*   retain credits referencing the University of Arizona and that you	*
*   identify any changes you make.					*
*									*
*   Report problems to scorpion-project@cs.arizona.edu			*
*   Direct all inquiries to:	The Scorpion Project			*
*				Department of Computer Science		*
*				Gould-Simpson Building			*
*				University of Arizona			*
*				Tucson, AZ 85721			*
*				U.S.A.					*
*									*
*   Function: This defines the xref parser that builds an xref          *
*           parse tree from information from the lexer.                 *
*									*
\* ******************************************************************* */

#ifndef lint
   static char rcsid[] = "$Header: /r/zep/usr/rts/p/personal/hkaram/tech/src/xref/frontend/RCS/parser.y,v 4.2 90/08/20 16:37:10 hkaram Release42 Locker: hkaram $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	parser.y,v $
 * Revision 4.2  90/08/20  16:37:10  hkaram
 * @
 * 
 * Revision 4.0  89/04/12  08:17:21  cheung
 * parser.y  Ver 4.0
 * 
 * Revision 3.9  89/03/26  01:01:04  cheung
 * parser.y  Ver 3.9
 * 
 * Revision 3.9  89/03/02  13:58:03  cheung
 * parser.y  Ver 3.9
 * 
 * Revision 3.8  89/03/02  13:41:52  cheung
 * parser.y  Ver 3.9
 * 
*									*
*   Edit Log:								*
*     Dec 18 1987 (rts) Updated to be consistent with changes made to   *
*                       the IDL specification.                          *
*     May 2 1986 (ddt) Created revision history.                        *
*									*
\* ******************************************************************* */


#include "frontend.h"
#include "stdio.h"

/*
	Functions defined later in this module.
*/
expression make_relational_expression();
expression make_boolean_expression();

extern int debug_print_flag;	/* Indicates if we want debug print */
extern FILE *debug_print_file;  /* File to write debug print to. */
extern body thisbody;      /* Parse tree of XRef specification */

#ifdef NeXT
#define TYPEOFMEMPARAM void
#endif
#ifndef NeXT
#define TYPEOFMEMPARAM char
#endif

# line 80 "parser.y"
typedef union  {
  string_constant	Vstring_constant;
  body	 		Vbody;
  sequence	 		Vsequence;
  declaration	 	Vdeclaration;
  predicate_declaration	Vpredicate_declaration;
  user_name	 		Vuser_name;
  function_declaration	Vfunction_declaration;
  local	 		Vlocal;
  sequence_element	 	Vsequence_element;
  user_nameOrVoid	Vuser_nameOrVoid;
  for_statement	Vfor_statement;
  case_statement	 	Vcase_statement;
  reference	 		Vreference;
  atom				Vatom;
  SEQatom	 		VSEQatom;
  branch	 	Vbranch;
  SEQbranch	 	VSEQbranch;
  SEQlocal		VSEQlocal;
  expression	 	Vexpression;
  SEQlet_variable		VSEQlet_variable;
} YYSTYPE;
# define and_token 257
# define as_token 258
# define case_token 259
# define default_token 260
# define difference_token 261
# define do_token 262
# define empty_token 263
# define end_token 264
# define extra_token 265
# define filter_token 266
# define for_token 267
# define function_token 268
# define head_token 269
# define in_token 270
# define intersection_token 271
# define let_token 272
# define not_token 273
# define of_token 274
# define or_token 275
# define predicate_token 276
# define reorder_token 277
# define root_token 278
# define same_token 279
# define tail_token 280
# define type_token 281
# define unique_token 282
# define colon_token 283
# define comma_token 284
# define equal_token 285
# define greater_than_or_equal_token 286
# define greater_than_token 287
# define right_paren_token 288
# define less_than_or_equal_token 289
# define less_than_token 290
# define not_equal_token 291
# define period_token 292
# define left_paren_token 293
# define semicolon_token 294
# define string_token 295
# define name_token 296
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 716 "parser.y"


expression make_relational_expression(left,op,right)
atom left;
relational_op_code op;
atom right;
{

	expression thisexpression;

	thisexpression.Vrelational_expression = Nrelational_expression;
	thisexpression.Vrelational_expression->syn_op_code = op;
	thisexpression.Vrelational_expression->syn_right_operand = right;
	thisexpression.Vrelational_expression->syn_left_operand = left;

	return thisexpression;
}

expression make_boolean_expression(left,op,right)
expression left;
binary_op_code  op;
expression right;
{
	expression thisexpression;

	thisexpression.Vbinary_op = Nbinary_op;
	thisexpression.Vbinary_op->syn_op_code = op;
	thisexpression.Vbinary_op->syn_left_operand = left;
	thisexpression.Vbinary_op->syn_right_operand = right;

	return thisexpression;
}
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 63
# define YYLAST 703
int yyact[]={

    22,   131,    17,   130,   129,   133,    18,    14,    23,    28,
    26,   126,    16,    11,   116,    95,    94,    27,    13,    29,
    26,     9,     7,    15,    93,    89,    87,    83,    75,    29,
    66,    50,    22,    49,    17,    46,    25,     8,    18,    14,
    23,   116,    26,    37,    16,    11,    25,    45,   171,   125,
    13,    29,   140,     9,     7,    15,   139,    69,    68,    48,
    43,   173,    42,    41,    22,    40,    17,    39,    25,     8,
    18,    14,    23,    38,    26,    35,    16,    11,    34,    33,
    47,   170,    13,    29,    72,     9,     7,    15,   172,   155,
   102,   102,   154,   112,   103,   101,    22,   128,    17,   109,
    25,     8,    18,    14,    23,   108,    26,    72,    16,    11,
   107,    71,    92,    57,    13,    29,   105,     9,     7,    15,
    99,   111,   136,    55,   141,    65,   153,   138,    22,   137,
    17,    64,    25,     8,    18,    14,    23,    56,    26,   132,
    16,    11,   142,    91,    52,   118,    13,    29,   135,     9,
     7,    15,   115,   110,     6,    86,     1,    36,   119,    32,
    22,   122,    17,   100,    25,     8,    18,    14,    23,   114,
    26,   113,    16,    11,    24,    10,    12,   104,    13,    29,
    21,     9,     7,    15,    20,     4,     0,     0,     0,     0,
     0,     0,    22,     0,    17,     0,    25,     8,    18,    14,
    23,     0,    26,     0,    16,    11,     0,     0,     0,     0,
    13,    29,     0,     9,     7,    15,     0,     0,     0,     0,
     0,    85,     0,     0,    22,    88,    17,     0,    25,     8,
    18,    14,    23,     0,    26,     0,    16,    11,     0,     0,
     0,     0,    13,    29,     0,     9,     7,    15,     0,    82,
     0,     0,     0,     0,     0,     0,    22,     0,    17,     0,
    25,     8,    18,    14,    23,     0,    26,   134,    16,    11,
     0,   152,     0,     0,    13,    29,     0,     9,     7,    15,
     0,    81,   156,     0,   158,   143,     0,     0,    22,     0,
    17,     0,    25,     8,    18,    14,    23,     0,    26,     0,
    16,    11,     0,   160,   161,     0,    13,    29,     0,     9,
     7,    15,     0,    80,     0,     0,     0,     0,     0,     0,
    22,     0,    17,     0,    25,     8,    18,    14,    23,     0,
    26,     0,    16,    11,     0,     0,     0,     0,    13,    29,
     0,     9,     7,    15,     0,    79,     0,     0,     0,     0,
     0,     0,    22,     0,    17,     0,    25,     8,    18,    14,
    23,     0,    26,     0,    16,    11,     0,     0,     0,     0,
    13,    29,     0,     9,     7,    15,     0,    78,     0,     0,
     0,     0,     0,     0,    22,     0,    17,     0,    25,     8,
    18,    14,    23,     0,    26,     0,    16,    11,     0,     0,
     0,     0,    13,    29,     0,     9,     7,    15,     0,    77,
     0,     0,     0,     0,     0,     0,    22,     0,    17,     0,
    25,     8,    18,    14,    23,     0,    26,     0,    16,    11,
     0,     0,     0,     0,    13,    29,     0,     9,     7,    15,
     2,     0,     0,     0,     0,    73,     0,     0,    22,     0,
    17,     0,    25,     8,    18,    14,    23,     0,    26,     0,
    16,    11,     0,     0,     0,     0,    13,    29,     0,     9,
     7,    15,     0,    70,     0,     0,     0,     0,     0,     0,
    22,     0,    17,    19,    25,     8,    18,    14,    23,     0,
    26,     5,    16,    11,   121,    30,    74,     0,    13,    29,
    26,     9,     7,    15,   123,     0,    44,     0,     0,    29,
     0,     0,     0,   151,     0,     0,    25,     8,    53,     0,
     0,     0,   150,    30,   125,     0,    25,   120,   144,   147,
   149,     0,   146,   148,   145,     0,     0,     0,     0,     0,
     0,   117,     0,    30,   127,     0,    30,     0,     0,     0,
    30,    30,    30,    30,    30,    30,    90,     0,     0,    30,
     0,     3,     0,     0,     0,     0,    31,     0,    30,     0,
     0,     0,     0,     0,     0,     0,    30,   157,     0,     0,
     0,     0,     0,     0,     0,   124,     0,     0,    30,    30,
    30,     0,     0,     0,     0,    51,     0,    54,    30,     0,
    58,    59,    60,    61,    62,    63,     0,     0,     0,   124,
    67,     0,     0,     0,     0,     0,     0,     0,     0,    76,
     0,     0,     0,    53,     0,     0,     0,    84,   162,   163,
   164,   165,   166,   167,   168,   169,     0,     0,     0,     0,
     0,     0,    96,    97,    98,     0,     0,     0,     0,     0,
     0,    30,     0,     0,   106,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   159 };
int yypact[]={

  -259, -1000, -1000,   221,  -259, -1000, -1000,  -214,  -215,  -218,
 -1000,  -253, -1000,  -220,  -226,  -228,  -230,  -231,  -233, -1000,
 -1000, -1000,  -249,  -261,  -212, -1000,  -234,  -263,  -265, -1000,
 -1000,   221, -1000,   221,  -249,   221,  -147,  -172,   221,   221,
   221,   221,   221,   221,  -127, -1000,  -145,  -266,   221,  -235,
  -236,   189,  -177, -1000,   157,  -259,  -268,   221,   125,    93,
    61,    29,    -3,   -35,  -269,   221, -1000,   -67,  -270,  -270,
  -271, -1000,  -249, -1000,  -121,  -173,   221,  -272,  -280,  -281,
   221,   221,   221,  -154,   -99, -1000,  -193, -1000,  -194,  -168,
 -1000, -1000,   221,  -178,  -183,  -189,  -131,  -163,  -195,  -282,
  -259,   231,  -285,  -259,  -191,  -292,   221, -1000, -1000, -1000,
  -293,  -295, -1000,  -125,  -255, -1000,  -161,  -135,  -137, -1000,
  -237,  -241,  -133,  -244,   243,   231, -1000,  -138, -1000, -1000,
  -196,  -199, -1000,  -161, -1000, -1000,  -259, -1000, -1000,  -249,
   221,  -244,  -244, -1000,  -249,  -249,  -249,  -249,  -249,  -249,
  -249,  -249,  -207, -1000, -1000, -1000, -1000,  -246,  -200,  -227,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000 };
int yypgo[]={

     0,   440,   561,   185,   154,   184,   180,   155,   491,   177,
   483,   144,   176,   175,   174,   171,   169,   148,   152,   158,
   161,   145,   157,   156 };
int yyr1[]={

     0,    23,     1,     1,     3,     3,     4,     4,     5,     6,
     7,     7,     2,     2,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,    22,    22,     9,
     9,    12,    13,    15,    15,    16,    16,    18,    17,    21,
    21,    21,    21,    21,    21,    21,    19,    19,    19,    19,
    19,    19,    19,    19,    20,    10,    10,    10,    11,    11,
    14,    14,    14 };
int yyr2[]={

     0,     3,     3,     5,     3,     5,     3,     3,    15,    15,
     3,     7,     3,     5,    15,     9,     9,     3,    11,     3,
    13,    13,    13,    17,    17,    13,     3,     7,    11,     1,
     5,    15,    15,     3,     7,     3,     5,     5,     7,     3,
     9,     9,     3,     7,     7,     5,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     3,     3,     9,     3,     7,
     3,     3,     7 };
int yychk[]={

 -1000,   -23,    -1,    -2,    -3,    -8,    -4,   281,   296,   280,
   -13,   272,   -12,   277,   266,   282,   271,   261,   265,   -10,
    -5,    -6,   259,   267,   -14,   295,   269,   276,   268,   278,
    -8,    -2,    -4,   293,   293,   293,   -22,   296,   293,   293,
   293,   293,   293,   293,   -10,   296,   296,   292,   293,   296,
   296,    -2,   -11,   -10,    -2,   270,   284,   285,    -2,    -2,
    -2,    -2,    -2,    -2,   258,   270,   296,    -2,   293,   293,
   284,   288,   284,   288,    -1,   296,    -2,   284,   284,   284,
   284,   284,   284,   296,    -2,   288,    -7,   296,    -7,   296,
   -10,   264,   285,   296,   296,   296,    -2,    -2,    -2,   274,
   262,   288,   284,   288,    -9,   284,    -2,   288,   288,   288,
   284,   284,   288,   -15,   -16,   -18,   296,    -1,   -21,   -19,
   296,   263,   -20,   273,   -10,   293,   296,    -1,   288,   296,
   296,   296,   264,   260,   -18,   -17,   283,   264,   264,   293,
   293,   257,   275,   -20,   285,   291,   289,   286,   290,   287,
   279,   270,   -21,   264,   288,   288,   -17,    -1,   -11,    -2,
   -20,   -20,   -10,   -10,   -10,   -10,   -10,   -10,   -10,   -10,
   288,   294,   288,   288 };
int yydef[]={

     0,    -2,     1,     2,     0,    12,     4,     0,    60,     0,
    17,     0,    19,     0,     0,     0,     0,     0,     0,    26,
     6,     7,     0,     0,    55,    56,     0,     0,     0,    61,
    13,     3,     5,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    60,     0,     0,     0,     0,
     0,     0,     0,    58,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    62,     0,     0,     0,
     0,    15,     0,    16,     0,     0,    27,     0,     0,     0,
     0,     0,     0,     0,     0,    57,     0,    10,     0,    29,
    59,    18,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    28,    20,    21,    22,
     0,     0,    25,     0,    33,    35,     0,     0,     0,    39,
    60,     0,    42,     0,     0,     0,    11,     0,    14,    30,
     0,     0,    32,     0,    36,    37,     0,    31,     8,     0,
     0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     9,    23,    24,    34,     0,     0,     0,
    43,    44,    46,    47,    48,    49,    50,    51,    52,    53,
    54,    38,    40,    41 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"and_token",	257,
	"as_token",	258,
	"case_token",	259,
	"default_token",	260,
	"difference_token",	261,
	"do_token",	262,
	"empty_token",	263,
	"end_token",	264,
	"extra_token",	265,
	"filter_token",	266,
	"for_token",	267,
	"function_token",	268,
	"head_token",	269,
	"in_token",	270,
	"intersection_token",	271,
	"let_token",	272,
	"not_token",	273,
	"of_token",	274,
	"or_token",	275,
	"predicate_token",	276,
	"reorder_token",	277,
	"root_token",	278,
	"same_token",	279,
	"tail_token",	280,
	"type_token",	281,
	"unique_token",	282,
	"colon_token",	283,
	"comma_token",	284,
	"equal_token",	285,
	"greater_than_or_equal_token",	286,
	"greater_than_token",	287,
	"right_paren_token",	288,
	"less_than_or_equal_token",	289,
	"less_than_token",	290,
	"not_equal_token",	291,
	"period_token",	292,
	"left_paren_token",	293,
	"semicolon_token",	294,
	"string_token",	295,
	"name_token",	296,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"input_declarations : body",
	"body : sequence",
	"body : declarations sequence",
	"declarations : declaration",
	"declarations : declarations declaration",
	"declaration : predicate_declaration",
	"declaration : function_declaration",
	"predicate_declaration : predicate_token name_token left_paren_token formals right_paren_token expression end_token",
	"function_declaration : function_token name_token left_paren_token formals right_paren_token body end_token",
	"formals : name_token",
	"formals : formals comma_token name_token",
	"sequence : sequence_element",
	"sequence : sequence sequence_element",
	"sequence_element : type_token left_paren_token sequence comma_token name_token type_tail right_paren_token",
	"sequence_element : name_token left_paren_token atoms right_paren_token",
	"sequence_element : tail_token left_paren_token sequence right_paren_token",
	"sequence_element : case_statement",
	"sequence_element : let_token assignments in_token body end_token",
	"sequence_element : for_statement",
	"sequence_element : reorder_token left_paren_token sequence comma_token name_token right_paren_token",
	"sequence_element : filter_token left_paren_token sequence comma_token name_token right_paren_token",
	"sequence_element : unique_token left_paren_token sequence comma_token name_token right_paren_token",
	"sequence_element : intersection_token left_paren_token sequence comma_token sequence comma_token name_token right_paren_token",
	"sequence_element : difference_token left_paren_token sequence comma_token sequence comma_token name_token right_paren_token",
	"sequence_element : extra_token left_paren_token sequence comma_token sequence right_paren_token",
	"sequence_element : atom",
	"assignments : name_token equal_token sequence",
	"assignments : assignments comma_token name_token equal_token sequence",
	"type_tail : /* empty */",
	"type_tail : comma_token name_token",
	"for_statement : for_token name_token in_token sequence do_token body end_token",
	"case_statement : case_token atom as_token name_token of_token case_branches end_token",
	"case_branches : normal_branches",
	"case_branches : normal_branches default_token case_branch_body",
	"normal_branches : case_branch",
	"normal_branches : normal_branches case_branch",
	"case_branch : name_token case_branch_body",
	"case_branch_body : colon_token body semicolon_token",
	"expression : relational_expression",
	"expression : name_token left_paren_token atoms right_paren_token",
	"expression : empty_token left_paren_token sequence right_paren_token",
	"expression : paren_expression",
	"expression : paren_expression and_token paren_expression",
	"expression : paren_expression or_token paren_expression",
	"expression : not_token paren_expression",
	"relational_expression : atom equal_token atom",
	"relational_expression : atom not_equal_token atom",
	"relational_expression : atom less_than_or_equal_token atom",
	"relational_expression : atom greater_than_or_equal_token atom",
	"relational_expression : atom less_than_token atom",
	"relational_expression : atom greater_than_token atom",
	"relational_expression : atom same_token atom",
	"relational_expression : atom in_token atom",
	"paren_expression : left_paren_token expression right_paren_token",
	"atom : reference",
	"atom : string_token",
	"atom : head_token left_paren_token sequence right_paren_token",
	"atoms : atom",
	"atoms : atoms comma_token atom",
	"reference : name_token",
	"reference : root_token",
	"reference : reference period_token name_token",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free((TYPEOFMEMPARAM *)yys); free((TYPEOFMEMPARAM *)yyv); return(0); }
#define YYABORT		{ free((TYPEOFMEMPARAM *)yys); free((TYPEOFMEMPARAM *)yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 175 "parser.y"
{
	  thisbody = yypvt[-0].Vbody;
	} break;
case 2:
# line 181 "parser.y"
{
	  body thisbody;

	  thisbody = Nbody;
	  thisbody->syn_sequence = yypvt[-0].Vsequence;
	  yyval.Vbody = thisbody;
	} break;
case 3:
# line 189 "parser.y"
{
	  yypvt[-1].Vbody->syn_sequence = yypvt[-0].Vsequence;
	  yyval.Vbody=yypvt[-1].Vbody;
	} break;
case 4:
# line 197 "parser.y"
{
	  body thisbody;

	  thisbody = Nbody;
	  appendrearSEQdeclaration(thisbody->syn_declarations, yypvt[-0].Vdeclaration);
	  yyval.Vbody = thisbody;
	} break;
case 5:
# line 205 "parser.y"
{
	  appendrearSEQdeclaration(yypvt[-1].Vbody->syn_declarations, yypvt[-0].Vdeclaration);
	  yyval.Vbody = yypvt[-1].Vbody;
	} break;
case 6:
# line 213 "parser.y"
{
	  yyval.Vdeclaration.Vpredicate_declaration = yypvt[-0].Vpredicate_declaration;
	} break;
case 7:
# line 217 "parser.y"
{
	  yyval.Vdeclaration.Vfunction_declaration = yypvt[-0].Vfunction_declaration;
	} break;
case 8:
# line 225 "parser.y"
{
	  predicate_declaration thispredicate_declaration;

	  thispredicate_declaration = Npredicate_declaration;
	  thispredicate_declaration->syn_name = yypvt[-5].Vuser_name;
	  thispredicate_declaration->syn_formals = yypvt[-3].VSEQlocal;
	  thispredicate_declaration->syn_value = yypvt[-1].Vexpression;
	  yyval.Vpredicate_declaration = thispredicate_declaration;
	} break;
case 9:
# line 240 "parser.y"
{
	  function_declaration thisfunction_declaration;

	  thisfunction_declaration = Nfunction_declaration;
	  thisfunction_declaration->syn_name = yypvt[-5].Vuser_name;
	  thisfunction_declaration->syn_formals = yypvt[-3].VSEQlocal;
	  thisfunction_declaration->syn_value = yypvt[-1].Vbody;
	  yyval.Vfunction_declaration = thisfunction_declaration;
	} break;
case 10:
# line 253 "parser.y"
{
	  SEQlocal formals;
	  local thislocal;
	  
	  initializeSEQlocal(formals);
	  thislocal = Nlocal;
	  thislocal->syn_name = yypvt[-0].Vuser_name;
	  appendrearSEQlocal(formals, thislocal);
	  yyval.VSEQlocal = formals;
	} break;
case 11:
# line 264 "parser.y"
{
	  local thislocal;

	  thislocal = Nlocal;
	  thislocal->syn_name = yypvt[-0].Vuser_name;
	  appendrearSEQlocal(yypvt[-2].VSEQlocal, thislocal);
	  yyval.VSEQlocal = yypvt[-2].VSEQlocal;
	} break;
case 12:
# line 276 "parser.y"
{
	  sequence thissequence;
	  
	  thissequence = Nsequence;
	  appendrearSEQsequence_element(thissequence->syn_values, yypvt[-0].Vsequence_element);
	  yyval.Vsequence= thissequence;
	} break;
case 13:
# line 284 "parser.y"
{
	  /* Sequences concatenate to form a single sequence. */
	  appendrearSEQsequence_element(yypvt[-1].Vsequence->syn_values,yypvt[-0].Vsequence_element);
	  yyval.Vsequence = yypvt[-1].Vsequence;
	} break;
case 14:
# line 294 "parser.y"
{
	  type_construct thistype_construct;

	  thistype_construct = Ntype_construct;
	  thistype_construct->syn_sequence = yypvt[-4].Vsequence;
	  thistype_construct->syn_name = yypvt[-2].Vuser_name;
	  thistype_construct->syn_attribute = yypvt[-1].Vuser_nameOrVoid;
	  yyval.Vsequence_element.Vtype_construct = thistype_construct;
	} break;
case 15:
# line 304 "parser.y"
{
	  function_call thisfunction_call;

	  thisfunction_call = Nfunction_call;
	  thisfunction_call->syn_function = NfunctionRef;
	  thisfunction_call->syn_function->syn_name = yypvt[-3].Vuser_name;
	  thisfunction_call->syn_actuals = yypvt[-1].VSEQatom;
	  yyval.Vsequence_element.Vfunction_call = thisfunction_call;
	} break;
case 16:
# line 314 "parser.y"
{
	  tail thistail;

	  thistail = Ntail;
	  thistail->syn_sequence = yypvt[-1].Vsequence;
	  yyval.Vsequence_element.Vtail = thistail;
	} break;
case 17:
# line 322 "parser.y"
{
	  yyval.Vsequence_element.Vcase_statement = yypvt[-0].Vcase_statement;
	} break;
case 18:
# line 326 "parser.y"
{
	  let_construct thislet;

	  thislet = Nlet_construct;
	  thislet->syn_assignments = yypvt[-3].VSEQlet_variable;
	  thislet->syn_body = yypvt[-1].Vbody;
	  yyval.Vsequence_element.Vlet_construct = thislet;
	} break;
case 19:
# line 335 "parser.y"
{
	  yyval.Vsequence_element.Vfor_statement = yypvt[-0].Vfor_statement;  
	} break;
case 20:
# line 340 "parser.y"
{
	  reorder thisreorder;

	  thisreorder = Nreorder;
	  thisreorder->syn_sequence = yypvt[-3].Vsequence;
	  thisreorder->syn_predicate = NpredicateRef;
	  thisreorder->syn_predicate->syn_name = yypvt[-1].Vuser_name;
	  yyval.Vsequence_element.Vreorder = thisreorder;
	} break;
case 21:
# line 351 "parser.y"
{
	  filter thisfilter;

	  thisfilter = Nfilter;
	  thisfilter->syn_sequence = yypvt[-3].Vsequence;
	  thisfilter->syn_predicate = NpredicateRef;
	  thisfilter->syn_predicate->syn_name = yypvt[-1].Vuser_name;
	  yyval.Vsequence_element.Vfilter = thisfilter;
	} break;
case 22:
# line 362 "parser.y"
{
	  unique thisunique;

	  thisunique = Nunique;
	  thisunique->syn_sequence = yypvt[-3].Vsequence;
	  thisunique->syn_predicate = NpredicateRef;
	  thisunique->syn_predicate->syn_name = yypvt[-1].Vuser_name;
	  yyval.Vsequence_element.Vunique = thisunique;
	} break;
case 23:
# line 374 "parser.y"
{
	  intersection thisintersection;

	  thisintersection = Nintersection;
	  thisintersection->syn_left_sequence = yypvt[-5].Vsequence;
	  thisintersection->syn_right_sequence = yypvt[-3].Vsequence;
	  thisintersection->syn_predicate = NpredicateRef;
	  thisintersection->syn_predicate->syn_name = yypvt[-1].Vuser_name;
	  yyval.Vsequence_element.Vintersection = thisintersection;
	} break;
case 24:
# line 387 "parser.y"
{
	  difference thisdifference;

	  thisdifference = Ndifference;
	  thisdifference->syn_left_sequence = yypvt[-5].Vsequence;
	  thisdifference->syn_right_sequence = yypvt[-3].Vsequence;
	  thisdifference->syn_predicate = NpredicateRef;
	  thisdifference->syn_predicate->syn_name = yypvt[-1].Vuser_name;
	  yyval.Vsequence_element.Vdifference = thisdifference;
	} break;
case 25:
# line 399 "parser.y"
{
	  extra thisextra;

	  thisextra = Nextra;
	  thisextra->syn_left_sequence = yypvt[-3].Vsequence;
	  thisextra->syn_right_sequence = yypvt[-1].Vsequence;
	  yyval.Vsequence_element.Vextra = thisextra;
	} break;
case 26:
# line 408 "parser.y"
{
	  yyval.Vsequence_element.Vatom = yypvt[-0].Vatom;
	} break;
case 27:
# line 415 "parser.y"
{
	  SEQlet_variable let_variables;
	  let_variable thislet_variable;

	  initializeSEQlet_variable(let_variables);
  	  thislet_variable = Nlet_variable;
	  thislet_variable->syn_name = yypvt[-2].Vuser_name;
	  thislet_variable->syn_sequence = yypvt[-0].Vsequence;
	  appendrearSEQlet_variable(let_variables, thislet_variable);
	  yyval.VSEQlet_variable = let_variables;
	} break;
case 28:
# line 427 "parser.y"
{
	  let_variable thislet_variable;

  	  thislet_variable = Nlet_variable;
	  thislet_variable->syn_name = yypvt[-2].Vuser_name;
	  thislet_variable->syn_sequence = yypvt[-0].Vsequence;
	  appendrearSEQlet_variable(yypvt[-4].VSEQlet_variable, thislet_variable);
	  yyval.VSEQlet_variable = yypvt[-4].VSEQlet_variable;
	} break;
case 29:
# line 440 "parser.y"
{
	  yyval.Vuser_nameOrVoid.VVoid = NVoid;
	} break;
case 30:
# line 444 "parser.y"
{
	  yyval.Vuser_nameOrVoid.Vuser_name = yypvt[-0].Vuser_name;
	} break;
case 31:
# line 451 "parser.y"
{
	  for_statement thisfor_statement;

	  thisfor_statement = Nfor_statement;
	  thisfor_statement ->syn_local = Nlocal;
	  thisfor_statement->syn_local->syn_name = yypvt[-5].Vuser_name;
	  thisfor_statement ->syn_sequence = yypvt[-3].Vsequence;
	  thisfor_statement ->syn_body = yypvt[-1].Vbody;
	  yyval.Vfor_statement = thisfor_statement;
	} break;
case 32:
# line 467 "parser.y"
{
	  case_statement thiscase_statement;

	  thiscase_statement = Ncase_statement;
	  thiscase_statement->syn_atom = yypvt[-5].Vatom;
	  thiscase_statement->syn_local = Nlocal;
	  thiscase_statement->syn_local->syn_name = yypvt[-3].Vuser_name;
	  thiscase_statement->syn_branches = yypvt[-1].VSEQbranch;
	  yyval.Vcase_statement= thiscase_statement;
	} break;
case 33:
# line 481 "parser.y"
{
	  yyval.VSEQbranch = yypvt[-0].VSEQbranch;
	} break;
case 34:
# line 485 "parser.y"
{
	  branch thisbranch;

	  thisbranch = Nbranch;
	  thisbranch->syn_key.Vdefault_construct = Ndefault_construct;
	  thisbranch->syn_value = yypvt[-0].Vbody;
	  appendrearSEQbranch(yypvt[-2].VSEQbranch, thisbranch);
	  yyval.VSEQbranch = yypvt[-2].VSEQbranch;
	} break;
case 35:
# line 497 "parser.y"
{
	  SEQbranch case_branches;

	  initializeSEQbranch(case_branches);
	  appendrearSEQbranch(case_branches, yypvt[-0].Vbranch);
	  yyval.VSEQbranch = case_branches;
	} break;
case 36:
# line 505 "parser.y"
{
	  appendrearSEQbranch(yypvt[-1].VSEQbranch, yypvt[-0].Vbranch);
	  yyval.VSEQbranch = yypvt[-1].VSEQbranch;
	} break;
case 37:
# line 513 "parser.y"
{
	  branch thisbranch;

	  thisbranch = Nbranch;
	  thisbranch->syn_key.Vuser_name = yypvt[-1].Vuser_name;
	  thisbranch->syn_value = yypvt[-0].Vbody;
	  yyval.Vbranch = thisbranch;
	} break;
case 38:
# line 525 "parser.y"
{
	  yyval.Vbody = yypvt[-1].Vbody;
	} break;
case 39:
# line 532 "parser.y"
{
	  yyval.Vexpression = yypvt[-0].Vexpression;
	} break;
case 40:
# line 536 "parser.y"
{
	  predicate_call thispredicate_call;

	  thispredicate_call = Npredicate_call;
	  thispredicate_call->syn_predicate = NpredicateRef;
	  thispredicate_call->syn_predicate->syn_name = yypvt[-3].Vuser_name;
	  thispredicate_call->syn_actuals = yypvt[-1].VSEQatom;
	  yyval.Vexpression.Vpredicate_call = thispredicate_call;
	} break;
case 41:
# line 546 "parser.y"
{
	  empty_call thisempty_call;

	  thisempty_call = Nempty_call;
	  thisempty_call->syn_sequence = yypvt[-1].Vsequence;
	  yyval.Vexpression.Vempty_call = thisempty_call;
	} break;
case 42:
# line 554 "parser.y"
{
	  yyval.Vexpression = yypvt[-0].Vexpression;
	} break;
case 43:
# line 558 "parser.y"
{
	  binary_op_code thisbinary_op_code;

	  thisbinary_op_code.Vand_op = Nand_op;
	  yyval.Vexpression = make_boolean_expression(yypvt[-2].Vexpression,thisbinary_op_code,yypvt[-0].Vexpression);
	} break;
case 44:
# line 565 "parser.y"
{
	  binary_op_code thisbinary_op_code;

	  thisbinary_op_code.Vor_op = Nor_op;
	  yyval.Vexpression = make_boolean_expression(yypvt[-2].Vexpression,thisbinary_op_code,yypvt[-0].Vexpression);
	} break;
case 45:
# line 572 "parser.y"
{
	  expression thisexpression;

	  thisexpression.Vunary_op = Nunary_op;
	  thisexpression.Vunary_op->syn_op_code.Vnot_op = Nnot_op;
	  thisexpression.Vunary_op ->syn_operand = yypvt[-0].Vexpression;
	  yyval.Vexpression = thisexpression;
	} break;
case 46:
# line 584 "parser.y"
{
	  relational_op_code op;

	  op.Vequal_op = Nequal_op;
	  yyval.Vexpression = make_relational_expression(yypvt[-2].Vatom,op,yypvt[-0].Vatom);
	} break;
case 47:
# line 591 "parser.y"
{
	  relational_op_code op;

	  op.Vnot_equal_op = Nnot_equal_op;
	  yyval.Vexpression = make_relational_expression(yypvt[-2].Vatom,op,yypvt[-0].Vatom);
	} break;
case 48:
# line 598 "parser.y"
{
	  relational_op_code op;

	  op.Vless_than_or_equal_op =  Nless_than_or_equal_op;
	  yyval.Vexpression = make_relational_expression(yypvt[-2].Vatom,op,yypvt[-0].Vatom);
	} break;
case 49:
# line 605 "parser.y"
{
	  relational_op_code op;

	  op.Vgtr_than_or_equal_op = Ngtr_than_or_equal_op;
	  yyval.Vexpression = make_relational_expression(yypvt[-2].Vatom,op,yypvt[-0].Vatom);
	} break;
case 50:
# line 612 "parser.y"
{
	  relational_op_code op;

	  op.Vless_than_op = Nless_than_op;
	  yyval.Vexpression = make_relational_expression(yypvt[-2].Vatom,op,yypvt[-0].Vatom);
	} break;
case 51:
# line 619 "parser.y"
{
	  relational_op_code op;

	  op.Vgtr_than_op = Ngtr_than_op;
	  yyval.Vexpression = make_relational_expression(yypvt[-2].Vatom,op,yypvt[-0].Vatom);
	} break;
case 52:
# line 626 "parser.y"
{
	  relational_op_code op;

	  op.Vsame_op = Nsame_op;
	  yyval.Vexpression = make_relational_expression(yypvt[-2].Vatom,op,yypvt[-0].Vatom);
	} break;
case 53:
# line 633 "parser.y"
{
	  relational_op_code op;

	  op.Vin_op = Nin_op;
	  yyval.Vexpression = make_relational_expression(yypvt[-2].Vatom,op,yypvt[-0].Vatom);
	} break;
case 54:
# line 643 "parser.y"
{
	  yyval.Vexpression = yypvt[-1].Vexpression;
	} break;
case 55:
# line 651 "parser.y"
{
	  atom thisatom;

	  thisatom.Vreference = yypvt[-0].Vreference;
	  yyval.Vatom = thisatom;
	} break;
case 56:
# line 658 "parser.y"
{
	  atom thisatom;

	  thisatom.Vstring_constant = yypvt[-0].Vstring_constant;
	  yyval.Vatom = thisatom;
	} break;
case 57:
# line 665 "parser.y"
{
	  head thishead;

	  thishead = Nhead;
	  thishead->syn_sequence = yypvt[-1].Vsequence;
	  yyval.Vatom.Vhead = thishead;
	} break;
case 58:
# line 676 "parser.y"
{
	  SEQatom actuals;

	  initializeSEQatom(actuals);
	  appendrearSEQatom(actuals, yypvt[-0].Vatom);
	  yyval.VSEQatom = actuals;
	} break;
case 59:
# line 684 "parser.y"
{
	  appendrearSEQatom(yypvt[-2].VSEQatom, yypvt[-0].Vatom);
	  yyval.VSEQatom = yypvt[-2].VSEQatom;
	} break;
case 60:
# line 692 "parser.y"
{
	  reference thisreference;

	  thisreference = Nreference;
	  thisreference->syn_local.VlocalOrletRef = NlocalOrletRef;
	  thisreference->syn_local.VlocalOrletRef->syn_name = yypvt[-0].Vuser_name;
	  initializeSEQuser_name(thisreference->syn_attributes);
	  yyval.Vreference = thisreference;
	} break;
case 61:
# line 702 "parser.y"
{
	  reference thisreference;

	  thisreference = Nreference;
	  thisreference->syn_local.VRoot_construct = NRoot_construct;
	  initializeSEQuser_name(thisreference->syn_attributes);
	  yyval.Vreference = thisreference;
	} break;
case 62:
# line 711 "parser.y"
{
	  appendrearSEQuser_name(yypvt[-2].Vreference->syn_attributes, yypvt[-0].Vuser_name);
	  yyval.Vreference = yypvt[-2].Vreference;
	} break;
	}
	goto yystack;		/* reset registers in driver code */
}
