%{
/* ******************************************************************* *\
*									*
*   File: scorpion/src/xref/frontend/parser.y
*									*
*   Copyright (C) 1991 Dean Throop
*									*
*   The Scorpion System is free software in the public domain; you can  *
*   redistribute it and/or modify it as you wish. We ask that you 	*
*   retain credits referencing the University of Arizona and that you	*
*   identify any changes you make.					*
*									*
*   Report problems to scorpion-project@cs.arizona.edu			*
*   Direct all inquiries to:	The Scorpion Project			*
*				Department of Computer Science		*
*				Gould-Simpson Building			*
*				University of Arizona			*
*				Tucson, AZ 85721			*
*				U.S.A.					*
*									*
*   Function: This defines the xref parser that builds an xref          *
*           parse tree from information from the lexer.                 *
*									*
\* ******************************************************************* */

#ifndef lint
   static char rcsid[] = "$Header: /r/zep/usr/rts/p/personal/hkaram/tech/src/xref/frontend/RCS/parser.y,v 4.2 90/08/20 16:37:10 hkaram Release42 Locker: hkaram $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	parser.y,v $
 * Revision 4.2  90/08/20  16:37:10  hkaram
 * @
 * 
 * Revision 4.0  89/04/12  08:17:21  cheung
 * parser.y  Ver 4.0
 * 
 * Revision 3.9  89/03/26  01:01:04  cheung
 * parser.y  Ver 3.9
 * 
 * Revision 3.9  89/03/02  13:58:03  cheung
 * parser.y  Ver 3.9
 * 
 * Revision 3.8  89/03/02  13:41:52  cheung
 * parser.y  Ver 3.9
 * 
*									*
*   Edit Log:								*
*     Dec 18 1987 (rts) Updated to be consistent with changes made to   *
*                       the IDL specification.                          *
*     May 2 1986 (ddt) Created revision history.                        *
*									*
\* ******************************************************************* */


#include "frontend.h"
#include "stdio.h"

/*
	Functions defined later in this module.
*/
expression make_relational_expression();
expression make_boolean_expression();

extern int debug_print_flag;	/* Indicates if we want debug print */
extern FILE *debug_print_file;  /* File to write debug print to. */
extern body thisbody;      /* Parse tree of XRef specification */

#ifdef NeXT
#define TYPEOFMEMPARAM void
#endif
#ifndef NeXT
#define TYPEOFMEMPARAM char
#endif
%}

%union {
  string_constant	Vstring_constant;
  body	 		Vbody;
  sequence	 		Vsequence;
  declaration	 	Vdeclaration;
  predicate_declaration	Vpredicate_declaration;
  user_name	 		Vuser_name;
  function_declaration	Vfunction_declaration;
  local	 		Vlocal;
  sequence_element	 	Vsequence_element;
  user_nameOrVoid	Vuser_nameOrVoid;
  for_statement	Vfor_statement;
  case_statement	 	Vcase_statement;
  reference	 		Vreference;
  atom				Vatom;
  SEQatom	 		VSEQatom;
  branch	 	Vbranch;
  SEQbranch	 	VSEQbranch;
  SEQlocal		VSEQlocal;
  expression	 	Vexpression;
  SEQlet_variable		VSEQlet_variable;
}


%token and_token
%token as_token
%token case_token
%token default_token
%token difference_token
%token do_token
%token empty_token
%token end_token
%token extra_token
%token filter_token
%token for_token
%token function_token
%token head_token
%token in_token
%token intersection_token
%token let_token
%token not_token
%token of_token
%token or_token
%token predicate_token
%token reorder_token
%token root_token
%token same_token
%token tail_token
%token type_token
%token unique_token

%token colon_token
%token comma_token
%token equal_token
%token greater_than_or_equal_token
%token greater_than_token
%token right_paren_token
%token less_than_or_equal_token
%token less_than_token
%token not_equal_token
%token period_token
%token left_paren_token
%token semicolon_token

%token <Vstring_constant> string_token
%token <Vuser_name> name_token

%type <Vbody> body
%type <Vsequence> sequence
%type <Vbody> declarations
%type <Vdeclaration> declaration
%type <Vpredicate_declaration> predicate_declaration
%type <Vfunction_declaration> function_declaration
%type <VSEQlocal> formals
%type <Vsequence_element> sequence_element
%type <Vuser_nameOrVoid> type_tail
%type <Vatom> atom
%type <VSEQatom> atoms
%type <Vfor_statement> for_statement
%type <Vcase_statement> case_statement
%type <Vreference> reference
%type <VSEQbranch> case_branches
%type <VSEQbranch> normal_branches
%type <Vbody> case_branch_body
%type <Vbranch> case_branch
%type <Vexpression> relational_expression
%type <Vexpression> paren_expression
%type <Vexpression> expression
%type <VSEQlet_variable> assignments

%start input_declarations
%%

input_declarations 
	: body 
	{
	  thisbody = $1;
	}

body 
	: sequence
	{
	  body thisbody;

	  thisbody = Nbody;
	  thisbody->syn_sequence = $1;
	  $$ = thisbody;
	}
	| declarations sequence
	{
	  $1->syn_sequence = $2;
	  $$=$1;
	}
	;

declarations 
	: declaration 
	{
	  body thisbody;

	  thisbody = Nbody;
	  appendrearSEQdeclaration(thisbody->syn_declarations, $1);
	  $$ = thisbody;
	}
	| declarations declaration 
	{
	  appendrearSEQdeclaration($1->syn_declarations, $2);
	  $$ = $1;
	}
	;

declaration 
	: predicate_declaration
	{
	  $$.Vpredicate_declaration = $1;
	}
	| function_declaration 
	{
	  $$.Vfunction_declaration = $1;
	}
	;

predicate_declaration
	: predicate_token name_token left_paren_token formals right_paren_token 
			expression end_token 
	{
	  predicate_declaration thispredicate_declaration;

	  thispredicate_declaration = Npredicate_declaration;
	  thispredicate_declaration->syn_name = $2;
	  thispredicate_declaration->syn_formals = $4;
	  thispredicate_declaration->syn_value = $6;
	  $$ = thispredicate_declaration;
	}
	;

function_declaration 
	: function_token name_token
			left_paren_token formals right_paren_token
			body end_token 
	{
	  function_declaration thisfunction_declaration;

	  thisfunction_declaration = Nfunction_declaration;
	  thisfunction_declaration->syn_name = $2;
	  thisfunction_declaration->syn_formals = $4;
	  thisfunction_declaration->syn_value = $6;
	  $$ = thisfunction_declaration;
	}
	;

formals
	: name_token
	{
	  SEQlocal formals;
	  local thislocal;
	  
	  initializeSEQlocal(formals);
	  thislocal = Nlocal;
	  thislocal->syn_name = $1;
	  appendrearSEQlocal(formals, thislocal);
	  $$ = formals;
	}
	| formals comma_token name_token
	{
	  local thislocal;

	  thislocal = Nlocal;
	  thislocal->syn_name = $3;
	  appendrearSEQlocal($1, thislocal);
	  $$ = $1;
	}
	;

sequence 
	: sequence_element
	{
	  sequence thissequence;
	  
	  thissequence = Nsequence;
	  appendrearSEQsequence_element(thissequence->syn_values, $1);
	  $$= thissequence;
	}
	| sequence sequence_element
	{
	  /* Sequences concatenate to form a single sequence. */
	  appendrearSEQsequence_element($1->syn_values,$2);
	  $$ = $1;
	}
	;

sequence_element
	: type_token left_paren_token sequence 
			comma_token name_token type_tail right_paren_token
	{
	  type_construct thistype_construct;

	  thistype_construct = Ntype_construct;
	  thistype_construct->syn_sequence = $3;
	  thistype_construct->syn_name = $5;
	  thistype_construct->syn_attribute = $6;
	  $$.Vtype_construct = thistype_construct;
	}
	| name_token left_paren_token atoms right_paren_token
	{
	  function_call thisfunction_call;

	  thisfunction_call = Nfunction_call;
	  thisfunction_call->syn_function = NfunctionRef;
	  thisfunction_call->syn_function->syn_name = $1;
	  thisfunction_call->syn_actuals = $3;
	  $$.Vfunction_call = thisfunction_call;
	}
	| tail_token left_paren_token sequence right_paren_token
	{
	  tail thistail;

	  thistail = Ntail;
	  thistail->syn_sequence = $3;
	  $$.Vtail = thistail;
	}
	| case_statement 
	{
	  $$.Vcase_statement = $1;
	}
	| let_token assignments in_token body end_token
	{
	  let_construct thislet;

	  thislet = Nlet_construct;
	  thislet->syn_assignments = $2;
	  thislet->syn_body = $4;
	  $$.Vlet_construct = thislet;
	}
	| for_statement 
	{
	  $$.Vfor_statement = $1;  
	}
	| reorder_token left_paren_token sequence 
			comma_token name_token right_paren_token
	{
	  reorder thisreorder;

	  thisreorder = Nreorder;
	  thisreorder->syn_sequence = $3;
	  thisreorder->syn_predicate = NpredicateRef;
	  thisreorder->syn_predicate->syn_name = $5;
	  $$.Vreorder = thisreorder;
	}
	| filter_token left_paren_token  sequence 
			comma_token name_token right_paren_token
	{
	  filter thisfilter;

	  thisfilter = Nfilter;
	  thisfilter->syn_sequence = $3;
	  thisfilter->syn_predicate = NpredicateRef;
	  thisfilter->syn_predicate->syn_name = $5;
	  $$.Vfilter = thisfilter;
	}
	| unique_token left_paren_token sequence 
			comma_token name_token right_paren_token
	{
	  unique thisunique;

	  thisunique = Nunique;
	  thisunique->syn_sequence = $3;
	  thisunique->syn_predicate = NpredicateRef;
	  thisunique->syn_predicate->syn_name = $5;
	  $$.Vunique = thisunique;
	}
	| intersection_token left_paren_token sequence 
			comma_token sequence 
			comma_token name_token right_paren_token 
	{
	  intersection thisintersection;

	  thisintersection = Nintersection;
	  thisintersection->syn_left_sequence = $3;
	  thisintersection->syn_right_sequence = $5;
	  thisintersection->syn_predicate = NpredicateRef;
	  thisintersection->syn_predicate->syn_name = $7;
	  $$.Vintersection = thisintersection;
	}
	| difference_token left_paren_token sequence 
			comma_token sequence 
			comma_token name_token right_paren_token 
	{
	  difference thisdifference;

	  thisdifference = Ndifference;
	  thisdifference->syn_left_sequence = $3;
	  thisdifference->syn_right_sequence = $5;
	  thisdifference->syn_predicate = NpredicateRef;
	  thisdifference->syn_predicate->syn_name = $7;
	  $$.Vdifference = thisdifference;
	}
	| extra_token left_paren_token sequence 
			comma_token sequence right_paren_token 
	{
	  extra thisextra;

	  thisextra = Nextra;
	  thisextra->syn_left_sequence = $3;
	  thisextra->syn_right_sequence = $5;
	  $$.Vextra = thisextra;
	}
	| atom
	{
	  $$.Vatom = $1;
	}
	;

assignments
	: name_token equal_token sequence
	{
	  SEQlet_variable let_variables;
	  let_variable thislet_variable;

	  initializeSEQlet_variable(let_variables);
  	  thislet_variable = Nlet_variable;
	  thislet_variable->syn_name = $1;
	  thislet_variable->syn_sequence = $3;
	  appendrearSEQlet_variable(let_variables, thislet_variable);
	  $$ = let_variables;
	}
	| assignments comma_token name_token equal_token sequence
	{
	  let_variable thislet_variable;

  	  thislet_variable = Nlet_variable;
	  thislet_variable->syn_name = $3;
	  thislet_variable->syn_sequence = $5;
	  appendrearSEQlet_variable($1, thislet_variable);
	  $$ = $1;
	}
	;

type_tail
	: /* empty */
	{
	  $$.VVoid = NVoid;
	}
	| comma_token name_token
	{
	  $$.Vuser_name = $2;
	}
	;

for_statement 
	: for_token name_token in_token sequence do_token body end_token 
	{
	  for_statement thisfor_statement;

	  thisfor_statement = Nfor_statement;
	  thisfor_statement ->syn_local = Nlocal;
	  thisfor_statement->syn_local->syn_name = $2;
	  thisfor_statement ->syn_sequence = $4;
	  thisfor_statement ->syn_body = $6;
	  $$ = thisfor_statement;
	} 
	;


case_statement 
	: case_token atom as_token name_token of_token 
			case_branches end_token 
	{
	  case_statement thiscase_statement;

	  thiscase_statement = Ncase_statement;
	  thiscase_statement->syn_atom = $2;
	  thiscase_statement->syn_local = Nlocal;
	  thiscase_statement->syn_local->syn_name = $4;
	  thiscase_statement->syn_branches = $6;
	  $$= thiscase_statement;
	}
	;

case_branches 
	: normal_branches
	{
	  $$ = $1;
	}
	| normal_branches default_token case_branch_body
	{
	  branch thisbranch;

	  thisbranch = Nbranch;
	  thisbranch->syn_key.Vdefault_construct = Ndefault_construct;
	  thisbranch->syn_value = $3;
	  appendrearSEQbranch($1, thisbranch);
	  $$ = $1;
	}

normal_branches
	: case_branch
	{
	  SEQbranch case_branches;

	  initializeSEQbranch(case_branches);
	  appendrearSEQbranch(case_branches, $1);
	  $$ = case_branches;
	}
	| normal_branches case_branch 
	{
	  appendrearSEQbranch($1, $2);
	  $$ = $1;
	}
	;

case_branch 
	: name_token case_branch_body
	{
	  branch thisbranch;

	  thisbranch = Nbranch;
	  thisbranch->syn_key.Vuser_name = $1;
	  thisbranch->syn_value = $2;
	  $$ = thisbranch;
	}
	;

case_branch_body
	: colon_token body semicolon_token 
	{
	  $$ = $2;
	}
	;

expression 
	: relational_expression 
	{
	  $$ = $1;
	}
	| name_token left_paren_token atoms right_paren_token
	{
	  predicate_call thispredicate_call;

	  thispredicate_call = Npredicate_call;
	  thispredicate_call->syn_predicate = NpredicateRef;
	  thispredicate_call->syn_predicate->syn_name = $1;
	  thispredicate_call->syn_actuals = $3;
	  $$.Vpredicate_call = thispredicate_call;
	}
	| empty_token left_paren_token sequence right_paren_token
	{
	  empty_call thisempty_call;

	  thisempty_call = Nempty_call;
	  thisempty_call->syn_sequence = $3;
	  $$.Vempty_call = thisempty_call;
	}
	| paren_expression 
	{
	  $$ = $1;
	}
	| paren_expression and_token paren_expression
	{
	  binary_op_code thisbinary_op_code;

	  thisbinary_op_code.Vand_op = Nand_op;
	  $$ = make_boolean_expression($1,thisbinary_op_code,$3);
	}
	| paren_expression or_token paren_expression
	{
	  binary_op_code thisbinary_op_code;

	  thisbinary_op_code.Vor_op = Nor_op;
	  $$ = make_boolean_expression($1,thisbinary_op_code,$3);
	} 
	| not_token paren_expression 
	{
	  expression thisexpression;

	  thisexpression.Vunary_op = Nunary_op;
	  thisexpression.Vunary_op->syn_op_code.Vnot_op = Nnot_op;
	  thisexpression.Vunary_op ->syn_operand = $2;
	  $$ = thisexpression;
	}
	;

relational_expression
	: atom equal_token atom 
	{
	  relational_op_code op;

	  op.Vequal_op = Nequal_op;
	  $$ = make_relational_expression($1,op,$3);
	}
	| atom not_equal_token atom 
	{
	  relational_op_code op;

	  op.Vnot_equal_op = Nnot_equal_op;
	  $$ = make_relational_expression($1,op,$3);
	}
	| atom less_than_or_equal_token atom
	{
	  relational_op_code op;

	  op.Vless_than_or_equal_op =  Nless_than_or_equal_op;
	  $$ = make_relational_expression($1,op,$3);
	}
	| atom greater_than_or_equal_token atom
	{
	  relational_op_code op;

	  op.Vgtr_than_or_equal_op = Ngtr_than_or_equal_op;
	  $$ = make_relational_expression($1,op,$3);
	}
	| atom less_than_token atom
	{
	  relational_op_code op;

	  op.Vless_than_op = Nless_than_op;
	  $$ = make_relational_expression($1,op,$3);
	}
	| atom greater_than_token atom
	{
	  relational_op_code op;

	  op.Vgtr_than_op = Ngtr_than_op;
	  $$ = make_relational_expression($1,op,$3);
	}
	| atom same_token atom 
	{
	  relational_op_code op;

	  op.Vsame_op = Nsame_op;
	  $$ = make_relational_expression($1,op,$3);
	}
	| atom in_token atom
	{
	  relational_op_code op;

	  op.Vin_op = Nin_op;
	  $$ = make_relational_expression($1,op,$3);
	}
	;

paren_expression
	: left_paren_token expression right_paren_token
	{
	  $$ = $2;
	}
	;


atom
	: reference
	{
	  atom thisatom;

	  thisatom.Vreference = $1;
	  $$ = thisatom;
	}
	| string_token
	{
	  atom thisatom;

	  thisatom.Vstring_constant = $1;
	  $$ = thisatom;
	}
	| head_token left_paren_token sequence right_paren_token
	{
	  head thishead;

	  thishead = Nhead;
	  thishead->syn_sequence = $3;
	  $$.Vhead = thishead;
	}
	;

atoms
	: atom
	{
	  SEQatom actuals;

	  initializeSEQatom(actuals);
	  appendrearSEQatom(actuals, $1);
	  $$ = actuals;
	}
	| atoms comma_token atom
	{
	  appendrearSEQatom($1, $3);
	  $$ = $1;
	}
	;

reference
 	: name_token
	{
	  reference thisreference;

	  thisreference = Nreference;
	  thisreference->syn_local.VlocalOrletRef = NlocalOrletRef;
	  thisreference->syn_local.VlocalOrletRef->syn_name = $1;
	  initializeSEQuser_name(thisreference->syn_attributes);
	  $$ = thisreference;
	}
	| root_token
	{
	  reference thisreference;

	  thisreference = Nreference;
	  thisreference->syn_local.VRoot_construct = NRoot_construct;
	  initializeSEQuser_name(thisreference->syn_attributes);
	  $$ = thisreference;
	}
	| reference period_token name_token 
	{
	  appendrearSEQuser_name($1->syn_attributes, $3);
	  $$ = $1;
	}
	;
%%

expression make_relational_expression(left,op,right)
atom left;
relational_op_code op;
atom right;
{

	expression thisexpression;

	thisexpression.Vrelational_expression = Nrelational_expression;
	thisexpression.Vrelational_expression->syn_op_code = op;
	thisexpression.Vrelational_expression->syn_right_operand = right;
	thisexpression.Vrelational_expression->syn_left_operand = left;

	return thisexpression;
}

expression make_boolean_expression(left,op,right)
expression left;
binary_op_code  op;
expression right;
{
	expression thisexpression;

	thisexpression.Vbinary_op = Nbinary_op;
	thisexpression.Vbinary_op->syn_op_code = op;
	thisexpression.Vbinary_op->syn_left_operand = left;
	thisexpression.Vbinary_op->syn_right_operand = right;

	return thisexpression;
}
