/***********************************************************************\ 
*									* 
*   File: scorpion/src/xref/frontend/main.c 
*				 					* 
*   Copyright (C) 1991 Dean Throop
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: this provides the main program for the XREF frontend.     *
*		The frontend does the lexing and parsing of the         *
*		xref directives to build an xref parse tree.            *
*									*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/xref/frontend/RCS/main.c,v 4.0 89/04/12 08:16:45 cheung Exp Locker: cheung $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	main.c,v $
 * Revision 4.0  89/04/12  08:16:45  cheung
 * main.c  Ver 4.0
 * 
 * Revision 3.9  89/03/26  01:00:55  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.9  89/03/02  13:57:06  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.8  89/03/02  13:40:34  cheung
 * main.c  Ver 3.9
 * 
*									*
*   Edit Log:								*
*     May 2 1986 (ddt) Create revision history.	                        *
*									*

\* ******************************************************************* */

#include "stdio.h"
#include "frontend.h"

/*
	The following are static variables that control debug
	print from the parser.  The flag will be non-zero if
	debug print is wanted; zero for no debug print.
	If debug print is wanted, it will be written to the file.
*/
int debug_print_flag = 0;
FILE *debug_print_file;

body thisbody;      /* Parse tree of XRef specification */

main(argc,argv)
int argc;
char *argv[];
{
/*
	Process arguments and call the parser.
	Input (result of /lib/cpp on user source) comes from stdin,
	a parse tree will be written stdout.
		
	The following arguments are recognized:

	-d pathname 
		write debugging information to the specified file

*/ 

    {/* Block for processing arguments */
	int arg_index;		/* index for searching argv */
	int argument_errors;    /* flag for error in arguments */
        void exit();

	argument_errors = 0;    /* no errors found so far */
	arg_index = 1;		/* Start with 1st argument */

	while(arg_index < argc){
	    switch (argv[arg_index][0]){
		case '-':{
		    switch (argv[arg_index][1]){
			case 'd':{
			    if ((arg_index +1) < argc){
				arg_index ++;
				debug_print_file = fopen(
				    argv[arg_index],
				    "w");
				if (NULL == debug_print_file){
				    (void) fprintf(stderr,
					"Can NOT append to file: %s\n",
					argv[arg_index]);
				    argument_errors = 1;
				}
				debug_print_flag = 1;
			    } else {
				(void) fprintf(stderr,
				    "No debug file name given \n");
				argument_errors = 1;
			    }
			    break;
			}
			default: {
			    (void) fprintf(stderr,"Unrecognized switch %s\n",
				&argv[arg_index][1]);
			    argument_errors = 1;
			}
		    }
		    break;
		}
		default: {
		    (void) fprintf(stderr,"Unrecognized argument %s\n",
			    argv[arg_index]);
		    argument_errors = 1;
		}
	    }
	    arg_index ++;
	}
	if (0 != argument_errors){
	    (void) fprintf(stderr, 
		"Argument errors prevents processing of %s\n",
		argv[0]);
	    exit(1);
	}
	
    }

    if (yyparse()==0) {
      write_syntax_tree(stdout, thisbody, TWOPASS);
      return 0;
    }
    else {
          (void) fprintf(stdout, "#\n");
	  return 1;
	}
   
}

/* The following variables are defined in the lexer */
extern char * cpp_file_name;	/* The file name of the current source file */
				/* Zero if no file defined. */
extern int cpp_line_number;	/* Line number relative to the file_name
				   file where token was found. */
extern char * cpp_first_file_name;	/* The first cpp file name found
				   i.e. the name of the input file */

extern int yylineno	; 	/* Absolute line number in input string */
extern char yytext[];

yyerror(msg)
char *msg;
{
	(void) fprintf(stderr,"xrefc: %s in file %s, line %d around \"%s\"\n",
		msg,cpp_file_name,cpp_line_number,yytext);
	(void) fflush(stderr);
	exit(1);
}
