/***********************************************************************\ 
*									* 
*   File: scorpion/src/xref/frontend/lexer_test.c 
*				 					* 
*   Copyright (C) 1991 Dean Throop
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#define YIELD(TOKEN_TYPE) return (int)"TOKEN_TYPE";

#include "xref_lexer.c"

main()
{
	char * value;

	value = (char *)yylex();
	while(value != 0){
		/* Print out token information. */
		printf( 
				"Token type=%30s, text=%20s, line=%3d\n"
				,value,yytext,yylineno);

		/* Print out source file information if available. */
		if(cpp_file_name != 0){
			printf("          (line %d in file %s)\n",
				cpp_line_number,cpp_file_name);
		}

		value = (char *)yylex();
	}
}
