%{
/***********************************************************************\ 
*									* 
*   File: scorpion/src/xref/frontend/lex_lexer.c 
*				 					* 
*   Copyright (C) 1991 Dean Throop
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									*
*   Function: Lex code for recognizing cross reference declarations.    *
*									*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/xref/frontend/RCS/lexer.l,v 4.0 89/04/12 08:16:20 cheung Exp Locker: cheung $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*                                                                       *
*       87/12/18 rts                                                    *
*               Updated to handle extensive naming modifications in the *
*               IDL specification. Removed special string handling.     *
*	85/10/18 D. Throop                                              *
*		Created.                                                *
*									*
\* ******************************************************************* */

#include <stdio.h>
#include <string.h>
# include "frontend.h"
# include "yacc_parser.h"	/* Get token ids generated by the parser. */


char *IDLstrchr(), *IDLstrrchr();

/*
	Functions used from library.
*/
int atoi();

/* 
 *     The following variables are updated by 
 *     preprocessor line location information. 
 */
char * cpp_file_name = 0;	/* The file name of the current source file */
				/* Zero if no file defined. */
int cpp_line_number = 1;	/* Line number relative to the file_name
				   file where token was found. */
char * cpp_first_file_name = 0;	/* The first cpp file name found
				   i.e. the name of the input file */

/*
 *	This following is a static variable that should
 *	only be referenced by routines within this module.
*/
int cpp_first_time = 0;	/* Flag to save cpp_first_file_name; */
			/* Set non-zero after first cpp directive. */
%}

%s quote normal
%%
				BEGIN normal;
<normal>And			{return and_token;}
<normal>As			{return as_token;}
<normal>Case			{return case_token;}
<normal>Default			{return default_token;}
<normal>Difference		{return difference_token;}
<normal>Do			{return do_token;}
<normal>Empty			{return empty_token;}
<normal>End			{return end_token;}
<normal>Extra			{return extra_token;}
<normal>Filter			{return filter_token;}
<normal>For			{return for_token;}
<normal>Function		{return function_token;}
<normal>Head			{return head_token;}
<normal>In			{return in_token;}
<normal>Intersection		{return intersection_token;}
<normal>Let			{return let_token;}
<normal>Not			{return not_token;}
<normal>Of			{return of_token;}
<normal>Or			{return or_token;}
<normal>Predicate		{return predicate_token;}
<normal>Reorder			{return reorder_token;}
<normal>Root			{return root_token;}
<normal>Same			{return same_token;}
<normal>Tail			{return tail_token;}
<normal>Type			{return type_token;}
<normal>Unique			{return unique_token;}

<normal>":"			{return colon_token;}
<normal>","			{return comma_token;}
<normal>"="			{return equal_token;}
<normal>">="			{return greater_than_or_equal_token;}
<normal>">"			{return greater_than_token;}
<normal>")"			{return right_paren_token;}
<normal>"<="			{return less_than_or_equal_token;}
<normal>"<"			{return less_than_token;}
<normal>"~="			{return not_equal_token;}
<normal>"!="			{return not_equal_token;}
<normal>"."			{return period_token;}
<normal>"("			{return left_paren_token;}
<normal>";"			{return semicolon_token;}

<normal>[a-zA-Z][a-zA-Z0-9_]*	{user_name thisuser_name;
				 position new_position;

				 thisuser_name = Nuser_name;
				 yytext[yyleng] = 0;
				 thisuser_name->lex_value = NewString(yytext);
				 new_position = Nposition;
				 new_position->lex_location = yylineno;
				 new_position->lex_cpp_file = cpp_file_name;
				 new_position->lex_cpp_location = cpp_line_number;
				 thisuser_name->lex_position = new_position;
				 yylval.Vuser_name = thisuser_name;
				 return name_token;}

<normal>"--".*\n		cpp_line_number++ /* comment */ ;
<normal>^"#".*\n		{handle_pre_processor_line();}
<normal>[ \t]			/* white space */ ;
<normal>\n			cpp_line_number++ /* more white space */;

<normal>\"			BEGIN quote;

<normal>.		{(void) fprintf(stderr,
                                 "Error: Invalid Character \"%c\"\n",
				 yytext[yyleng]);}
<quote>[^"\\]*\"	{position new_position;

                        BEGIN normal;
			yyleng--;
                        yytext[yyleng] = 0;
			yylval.Vstring_constant = Nstring_constant;
                        yylval.Vstring_constant->lex_text = NewString(yytext);
			new_position = Nposition;
			new_position->lex_location = yylineno;
			new_position->lex_cpp_file = cpp_file_name;
			new_position->lex_cpp_location = cpp_line_number;
                        yylval.Vstring_constant->lex_position = new_position;
			return string_token;}

<quote>[^"\\]*\\b	{yyleng--; yytext[yyleng-1] = '\b'; yymore();}
<quote>[^"\\]*\\n	{yyleng--; yytext[yyleng-1] = '\n'; yymore();}
<quote>[^"\\]*\\r	{yyleng--; yytext[yyleng-1] = '\r'; yymore();}
<quote>[^"\\]*\\t	{yyleng--; yytext[yyleng-1] = '\t'; yymore();}
<quote>[^"\\]*\\f	{yyleng--; yytext[yyleng-1] = '\f'; yymore();}

<quote>[^"\\]*\\([0-7]{1,3})	{int index = 0;
			int result = 0;
			while(yytext[yyleng-1] != '\\') { yyleng--;}
			while(yytext[yyleng+index] != 0) {
				result = (result << 3) | 
					((int)yytext[yyleng+index] - (int)'0');
				index ++;
			};
			yytext[yyleng-1] = (char)result;
				yytext[yyleng]=0;yymore();}
<quote>[^"\\]*\\(\n|.)	{yyleng--; yytext[yyleng-1] = yytext[yyleng]; 
					yytext[yyleng]=0;yymore();}
%%

/*
	yywrap: a function to keep the lexer happy.
*/
yywrap() { return 1; }

/*
	handle_pre_processor()

	This function is called when yytext contains a preprocessor line
	(i.e. a line which begins with "#").
	If the line is a /lib/cpp line location line, then
	this function will update the global variables
		cpp_line_number, and cpp_file_name
	with the information from the current line.

	If the line isn't a /lib/cpp line, this function just
	increments cpp_line_number. 

	A /lib/cpp location line has at least two " characters
	enclosing 0 or more file name characters, and a
	number starting at character position 3 of the line.
*/
handle_pre_processor_line()
{/* preprocessor directive */ 
	extern char yytext[];
	int new_line_number;
	char *start_file_name;
	char *end_file_name;

	/* Check that there are two quote characters in the line */
	end_file_name = IDLstrrchr((char *)yytext,'"');
	start_file_name = IDLstrchr((char *)yytext,'"');
	if( (end_file_name == 0)
	    || (start_file_name == 0)
/*	    || ((start_file_name-yytext) < 3) */
	    || ((start_file_name-3) < yytext)
	    || (start_file_name == end_file_name) ) {
		cpp_line_number++ ;
		return;
	}

	/* Check that there is a number in the line. */
	*start_file_name = 0;	/* change first quote to zero to terminate  */
				/* string for call to atoi for line number */
	start_file_name ++;	/* Move past " to start of file name. */
	new_line_number = atoi(&yytext[2]);
	if (new_line_number == 0){
		cpp_line_number ++;
		return;
	} 

	*end_file_name = 0;	/* make file name zero terminated */

	/* Assign a file name (provided the name isn't zero length) */
	if ( (*start_file_name) == 0){
		cpp_file_name = "";
	} else {
		cpp_file_name = NewString(start_file_name);
	}
	cpp_line_number = new_line_number;

	/* If this is the first name found, save a copy of it. */
	if (cpp_first_time == 0){
		cpp_first_time = 1;
		cpp_first_file_name = cpp_file_name;
	}
}
