# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) (void)putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO (void)fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* ******************************************************************* *\
*									*
*   Title: 	Lexical analysis phase of Cross reference declarations. *
*   Filename:	/usr/softlab/src/xref/xref_lexer.l                      *
*   Last Edit:	Friday November 29, 1985                                *
*   Author:	Dean Throop (ddt@unc)                                   *
*		Department of Computer Science				*
*		University of North Carolina				*
*		Chapel Hill, NC  27514					*
*									*
*   Copyright (C) The University of North Carolina, 1985		*
*									*
*   All rights reserved. No part of this software may be sold or	*
*   distributed in any form or by any means without the prior written	*
*   permission of the SoftLab Software Distribution Coordinator.	*
*									*
*   Report problems to	softlab@unc (csnet) or				*
*			softlab!unc@CSNET-RELAY (ARPAnet)		*
*   Direct all inquiries to the SoftLab Software Distribution		*
*	Coordinator, at the above addresses.				*
*									*
*   Function: Lex code for recognizing cross reference declarations.    *
*									*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/xref/frontend/RCS/lexer.l,v 4.0 89/04/12 08:16:20 cheung Exp Locker: cheung $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*                                                                       *
*       87/12/18 rts                                                    *
*               Updated to handle extensive naming modifications in the *
*               IDL specification. Removed special string handling.     *
*	85/10/18 D. Throop                                              *
*		Created.                                                *
*									*
\* ******************************************************************* */

#include <stdio.h>
#include <string.h>
# include "frontend.h"
# include "yacc_parser.h"	/* Get token ids generated by the parser. */


char *IDLstrchr(), *IDLstrrchr();

/*
	Functions used from library.
*/
int atoi();

/* 
 *     The following variables are updated by 
 *     preprocessor line location information. 
 */
char * cpp_file_name = 0;	/* The file name of the current source file */
				/* Zero if no file defined. */
int cpp_line_number = 1;	/* Line number relative to the file_name
				   file where token was found. */
char * cpp_first_file_name = 0;	/* The first cpp file name found
				   i.e. the name of the input file */

/*
 *	This following is a static variable that should
 *	only be referenced by routines within this module.
*/
int cpp_first_time = 0;	/* Flag to save cpp_first_file_name; */
			/* Set non-zero after first cpp directive. */
# define quote 2
# define normal 4
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
			BEGIN normal;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
		{return and_token;}
break;
case 2:
		{return as_token;}
break;
case 3:
		{return case_token;}
break;
case 4:
		{return default_token;}
break;
case 5:
	{return difference_token;}
break;
case 6:
		{return do_token;}
break;
case 7:
		{return empty_token;}
break;
case 8:
		{return end_token;}
break;
case 9:
		{return extra_token;}
break;
case 10:
		{return filter_token;}
break;
case 11:
		{return for_token;}
break;
case 12:
	{return function_token;}
break;
case 13:
		{return head_token;}
break;
case 14:
		{return in_token;}
break;
case 15:
	{return intersection_token;}
break;
case 16:
		{return let_token;}
break;
case 17:
		{return not_token;}
break;
case 18:
		{return of_token;}
break;
case 19:
		{return or_token;}
break;
case 20:
	{return predicate_token;}
break;
case 21:
		{return reorder_token;}
break;
case 22:
		{return root_token;}
break;
case 23:
		{return same_token;}
break;
case 24:
		{return tail_token;}
break;
case 25:
		{return type_token;}
break;
case 26:
		{return unique_token;}
break;
case 27:
		{return colon_token;}
break;
case 28:
		{return comma_token;}
break;
case 29:
		{return equal_token;}
break;
case 30:
		{return greater_than_or_equal_token;}
break;
case 31:
		{return greater_than_token;}
break;
case 32:
		{return right_paren_token;}
break;
case 33:
		{return less_than_or_equal_token;}
break;
case 34:
		{return less_than_token;}
break;
case 35:
		{return not_equal_token;}
break;
case 36:
		{return not_equal_token;}
break;
case 37:
		{return period_token;}
break;
case 38:
		{return left_paren_token;}
break;
case 39:
		{return semicolon_token;}
break;
case 40:
{user_name thisuser_name;
				 position new_position;

				 thisuser_name = Nuser_name;
				 yytext[yyleng] = 0;
				 thisuser_name->lex_value = NewString(yytext);
				 new_position = Nposition;
				 new_position->lex_location = yylineno;
				 new_position->lex_cpp_file = cpp_file_name;
				 new_position->lex_cpp_location = cpp_line_number;
				 thisuser_name->lex_position = new_position;
				 yylval.Vuser_name = thisuser_name;
				 return name_token;}
break;
case 41:
	cpp_line_number++ /* comment */ ;
break;
case 42:
	{handle_pre_processor_line();}
break;
case 43:
		/* white space */ ;
break;
case 44:
		cpp_line_number++ /* more white space */;
break;
case 45:
		BEGIN quote;
break;
case 46:
	{(void) (void)fprintf(stderr,
                                 "Error: Invalid Character \"%c\"\n",
				 yytext[yyleng]);}
break;
case 47:
{position new_position;

                        BEGIN normal;
			yyleng--;
                        yytext[yyleng] = 0;
			yylval.Vstring_constant = Nstring_constant;
                        yylval.Vstring_constant->lex_text = NewString(yytext);
			new_position = Nposition;
			new_position->lex_location = yylineno;
			new_position->lex_cpp_file = cpp_file_name;
			new_position->lex_cpp_location = cpp_line_number;
                        yylval.Vstring_constant->lex_position = new_position;
			return string_token;}
break;
case 48:
{yyleng--; yytext[yyleng-1] = '\b'; yymore();}
break;
case 49:
{yyleng--; yytext[yyleng-1] = '\n'; yymore();}
break;
case 50:
{yyleng--; yytext[yyleng-1] = '\r'; yymore();}
break;
case 51:
{yyleng--; yytext[yyleng-1] = '\t'; yymore();}
break;
case 52:
{yyleng--; yytext[yyleng-1] = '\f'; yymore();}
break;
case 53:
{int index = 0;
			int result = 0;
			while(yytext[yyleng-1] != '\\') { yyleng--;}
			while(yytext[yyleng+index] != 0) {
				result = (result << 3) | 
					((int)yytext[yyleng+index] - (int)'0');
				index ++;
			};
			yytext[yyleng-1] = (char)result;
				yytext[yyleng]=0;yymore();}
break;
case 54:
{yyleng--; yytext[yyleng-1] = yytext[yyleng]; 
					yytext[yyleng]=0;yymore();}
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/*
	yywrap: a function to keep the lexer happy.
*/
yywrap() { return 1; }

/*
	handle_pre_processor()

	This function is called when yytext contains a preprocessor line
	(i.e. a line which begins with "#").
	If the line is a /lib/cpp line location line, then
	this function will update the global variables
		cpp_line_number, and cpp_file_name
	with the information from the current line.

	If the line isn't a /lib/cpp line, this function just
	increments cpp_line_number. 

	A /lib/cpp location line has at least two " characters
	enclosing 0 or more file name characters, and a
	number starting at character position 3 of the line.
*/
handle_pre_processor_line()
{/* preprocessor directive */ 
	extern char yytext[];
	int new_line_number;
	char *start_file_name;
	char *end_file_name;

	/* Check that there are two quote characters in the line */
	end_file_name = IDLstrrchr((char *)yytext,'"');
	start_file_name = IDLstrchr((char *)yytext,'"');
	if( (end_file_name == 0)
	    || (start_file_name == 0)
/*	    || ((start_file_name-yytext) < 3) */
	    || ((start_file_name-3) < yytext)
	    || (start_file_name == end_file_name) ) {
		cpp_line_number++ ;
		return;
	}

	/* Check that there is a number in the line. */
	*start_file_name = 0;	/* change first quote to zero to terminate  */
				/* string for call to atoi for line number */
	start_file_name ++;	/* Move past " to start of file name. */
	new_line_number = atoi(&yytext[2]);
	if (new_line_number == 0){
		cpp_line_number ++;
		return;
	} 

	*end_file_name = 0;	/* make file name zero terminated */

	/* Assign a file name (provided the name isn't zero length) */
	if ( (*start_file_name) == 0){
		cpp_file_name = "";
	} else {
		cpp_file_name = NewString(start_file_name);
	}
	cpp_line_number = new_line_number;

	/* If this is the first name found, save a copy of it. */
	if (cpp_first_time == 0){
		cpp_first_time = 1;
		cpp_first_file_name = cpp_file_name;
	}
}
int yyvstop[] = {
0,

47,
0,

46,
0,

43,
46,
0,

44,
0,

46,
0,

45,
46,
0,

38,
46,
0,

32,
46,
0,

28,
46,
0,

46,
0,

37,
46,
0,

27,
46,
0,

39,
46,
0,

34,
46,
0,

29,
46,
0,

31,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

40,
46,
0,

46,
0,

46,
0,

54,
0,

53,
54,
0,

48,
54,
0,

52,
54,
0,

49,
54,
0,

50,
54,
0,

51,
54,
0,

36,
0,

33,
0,

30,
0,

40,
0,

40,
0,

2,
40,
0,

40,
0,

40,
0,

40,
0,

6,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

14,
40,
0,

40,
0,

40,
0,

18,
40,
0,

19,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

35,
0,

42,
0,

53,
0,

41,
0,

1,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

8,
40,
0,

40,
0,

40,
0,

11,
40,
0,

40,
0,

40,
0,

40,
0,

16,
40,
0,

17,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

53,
0,

3,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

13,
40,
0,

40,
0,

40,
0,

40,
0,

22,
40,
0,

23,
40,
0,

24,
40,
0,

25,
40,
0,

40,
0,

40,
0,

40,
0,

7,
40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

10,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

26,
40,
0,

4,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

21,
40,
0,

40,
0,

12,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
40,
0,

5,
40,
0,

40,
0,

40,
0,

15,
40,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	3,4,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	3,4,	3,4,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	5,9,	
0,0,	0,0,	0,0,	3,7,	
0,0,	0,0,	0,0,	5,10,	
5,11,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	3,4,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	3,4,	0,0,	0,0,	
0,0,	0,0,	0,0,	5,12,	
5,13,	0,0,	3,4,	0,0,	
0,0,	0,0,	5,14,	5,15,	
17,50,	0,0,	5,16,	5,17,	
5,18,	0,0,	5,9,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	5,9,	0,0,	
5,19,	5,20,	5,21,	5,22,	
5,23,	3,8,	4,8,	5,24,	
5,25,	5,26,	5,27,	5,28,	
5,29,	5,25,	5,30,	5,31,	
5,25,	5,25,	5,32,	5,25,	
5,33,	5,34,	5,35,	5,25,	
5,36,	5,37,	5,38,	5,39,	
5,25,	5,25,	5,25,	5,25,	
5,25,	12,49,	5,9,	21,51,	
23,52,	40,79,	0,0,	5,25,	
5,25,	5,25,	5,25,	5,25,	
5,25,	5,25,	5,25,	5,25,	
5,25,	5,25,	5,25,	5,25,	
5,25,	5,25,	5,25,	5,25,	
5,25,	5,25,	5,25,	5,25,	
5,25,	5,25,	5,25,	5,25,	
5,25,	6,12,	25,53,	6,41,	
5,40,	26,56,	27,57,	25,53,	
6,14,	6,15,	27,58,	0,0,	
6,16,	6,17,	6,18,	27,53,	
27,59,	31,67,	26,53,	39,78,	
27,53,	0,0,	31,53,	26,53,	
39,53,	0,0,	6,19,	6,20,	
6,21,	6,22,	6,23,	0,0,	
0,0,	0,0,	6,25,	6,26,	
6,27,	6,28,	6,29,	6,25,	
6,30,	6,31,	6,25,	6,25,	
6,32,	6,25,	6,33,	6,34,	
6,35,	6,25,	6,36,	6,37,	
6,38,	6,39,	6,25,	6,25,	
6,25,	6,25,	6,25,	35,53,	
6,9,	0,0,	0,0,	35,72,	
35,53,	6,25,	6,25,	6,25,	
6,25,	6,25,	6,25,	6,25,	
6,25,	6,25,	6,25,	6,25,	
6,25,	6,25,	6,25,	6,25,	
6,25,	6,25,	6,25,	6,25,	
6,25,	6,25,	6,25,	6,25,	
6,25,	6,25,	6,25,	8,42,	
28,60,	28,61,	6,40,	30,66,	
29,63,	0,0,	28,53,	8,42,	
8,42,	29,53,	29,64,	28,62,	
30,53,	32,68,	29,53,	53,53,	
29,65,	30,53,	33,53,	33,69,	
53,53,	34,70,	32,53,	33,53,	
37,75,	38,76,	36,73,	32,53,	
0,0,	34,53,	0,0,	0,0,	
8,42,	34,71,	34,53,	36,53,	
36,74,	37,53,	38,53,	41,80,	
36,53,	0,0,	37,53,	38,53,	
0,0,	55,53,	8,43,	41,80,	
41,81,	38,77,	55,53,	0,0,	
0,0,	0,0,	8,42,	43,82,	
43,82,	43,82,	43,82,	43,82,	
43,82,	43,82,	43,82,	8,42,	
54,84,	56,53,	59,53,	57,86,	
58,87,	0,0,	56,85,	59,53,	
41,80,	61,89,	54,53,	57,53,	
58,53,	0,0,	0,0,	54,53,	
57,53,	58,53,	60,53,	61,53,	
60,88,	62,53,	41,80,	60,53,	
61,53,	0,0,	62,53,	62,90,	
0,0,	65,93,	41,80,	63,91,	
8,44,	63,53,	65,53,	0,0,	
8,45,	64,53,	63,53,	41,80,	
67,53,	64,92,	64,53,	0,0,	
8,46,	67,53,	67,95,	0,0,	
8,47,	66,94,	8,48,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	70,53,	66,53,	0,0,	
0,0,	0,0,	70,53,	66,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	71,53,	0,0,	
0,0,	0,0,	24,53,	71,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,54,	24,53,	24,53,	
24,53,	24,53,	24,55,	24,53,	
24,53,	24,53,	24,53,	24,53,	
24,53,	24,53,	50,50,	68,53,	
0,0,	72,98,	0,0,	69,53,	
68,53,	68,96,	50,50,	50,83,	
69,53,	69,97,	72,53,	73,53,	
73,99,	74,53,	74,100,	72,53,	
73,53,	76,102,	74,53,	75,101,	
75,53,	77,53,	76,53,	77,103,	
78,104,	75,53,	77,53,	76,53,	
84,53,	78,53,	0,0,	50,50,	
0,0,	84,53,	78,53,	82,105,	
82,105,	82,105,	82,105,	82,105,	
82,105,	82,105,	82,105,	85,106,	
88,53,	50,50,	86,107,	87,108,	
0,0,	88,53,	88,109,	89,53,	
85,53,	50,50,	0,0,	87,53,	
89,53,	85,53,	0,0,	86,53,	
87,53,	90,53,	50,50,	91,53,	
86,53,	90,110,	90,53,	92,53,	
91,53,	91,111,	93,112,	95,114,	
92,53,	94,113,	96,53,	0,0,	
0,0,	97,53,	0,0,	96,53,	
95,53,	93,53,	97,53,	94,53,	
98,115,	95,53,	93,53,	99,53,	
94,53,	101,118,	100,53,	99,116,	
99,53,	0,0,	98,53,	100,53,	
100,117,	103,120,	101,53,	98,53,	
102,119,	0,0,	102,53,	101,53,	
106,53,	104,53,	103,53,	102,53,	
104,121,	106,53,	104,53,	103,53,	
107,53,	108,123,	111,126,	109,53,	
110,125,	107,53,	0,0,	107,122,	
109,53,	0,0,	108,53,	111,53,	
0,0,	112,53,	109,124,	108,53,	
111,53,	110,53,	112,53,	112,127,	
113,53,	115,129,	110,53,	114,53,	
116,130,	113,53,	115,53,	114,128,	
114,53,	0,0,	117,53,	115,53,	
118,53,	119,53,	116,53,	117,53,	
120,53,	118,53,	119,53,	116,53,	
121,53,	120,53,	122,132,	124,53,	
122,53,	121,53,	123,53,	121,131,	
124,53,	122,53,	123,133,	123,53,	
125,53,	129,137,	126,53,	127,135,	
128,53,	125,53,	126,134,	126,53,	
127,53,	128,136,	130,138,	131,139,	
129,53,	127,53,	133,141,	0,0,	
132,53,	129,53,	136,143,	130,53,	
131,53,	132,53,	132,140,	133,53,	
130,53,	131,53,	134,53,	136,53,	
133,53,	135,53,	135,142,	134,53,	
136,53,	137,144,	135,53,	138,53,	
139,53,	140,53,	141,146,	138,145,	
138,53,	139,53,	140,53,	141,53,	
142,147,	143,148,	137,53,	144,53,	
146,150,	142,53,	145,53,	137,53,	
144,53,	144,149,	149,152,	145,53,	
143,53,	147,53,	150,153,	146,53,	
148,53,	143,53,	147,53,	149,53,	
146,53,	148,53,	148,151,	150,53,	
149,53,	151,154,	152,53,	153,53,	
150,53,	0,0,	151,53,	152,53,	
153,53,	154,53,	154,155,	151,53,	
155,156,	156,53,	154,53,	0,0,	
0,0,	155,53,	156,53,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+0,	0,		0,	
yycrank+0,	0,		0,	
yycrank+-1,	0,		0,	
yycrank+-2,	yysvec+3,	0,	
yycrank+-30,	0,		0,	
yycrank+-120,	yysvec+5,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+-242,	0,		0,	
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+0,	0,		yyvstop+8,
yycrank+60,	0,		yyvstop+10,
yycrank+0,	0,		yyvstop+12,
yycrank+0,	0,		yyvstop+15,
yycrank+0,	0,		yyvstop+18,
yycrank+0,	0,		yyvstop+21,
yycrank+27,	0,		yyvstop+24,
yycrank+0,	0,		yyvstop+26,
yycrank+0,	0,		yyvstop+29,
yycrank+0,	0,		yyvstop+32,
yycrank+62,	0,		yyvstop+35,
yycrank+0,	0,		yyvstop+38,
yycrank+63,	0,		yyvstop+41,
yycrank+311,	0,		yyvstop+44,
yycrank+44,	yysvec+24,	yyvstop+47,
yycrank+60,	yysvec+24,	yyvstop+50,
yycrank+57,	yysvec+24,	yyvstop+53,
yycrank+135,	yysvec+24,	yyvstop+56,
yycrank+143,	yysvec+24,	yyvstop+59,
yycrank+146,	yysvec+24,	yyvstop+62,
yycrank+59,	yysvec+24,	yyvstop+65,
yycrank+156,	yysvec+24,	yyvstop+68,
yycrank+152,	yysvec+24,	yyvstop+71,
yycrank+163,	yysvec+24,	yyvstop+74,
yycrank+101,	yysvec+24,	yyvstop+77,
yycrank+169,	yysvec+24,	yyvstop+80,
yycrank+171,	yysvec+24,	yyvstop+83,
yycrank+172,	yysvec+24,	yyvstop+86,
yycrank+61,	yysvec+24,	yyvstop+89,
yycrank+64,	0,		yyvstop+92,
yycrank+-282,	0,		yyvstop+94,
yycrank+0,	0,		yyvstop+96,
yycrank+251,	0,		yyvstop+98,
yycrank+0,	0,		yyvstop+101,
yycrank+0,	0,		yyvstop+104,
yycrank+0,	0,		yyvstop+107,
yycrank+0,	0,		yyvstop+110,
yycrank+0,	0,		yyvstop+113,
yycrank+0,	0,		yyvstop+116,
yycrank+-433,	0,		0,	
yycrank+0,	0,		yyvstop+118,
yycrank+0,	0,		yyvstop+120,
yycrank+149,	yysvec+24,	yyvstop+122,
yycrank+208,	yysvec+24,	yyvstop+124,
yycrank+179,	yysvec+24,	yyvstop+126,
yycrank+199,	yysvec+24,	yyvstop+129,
yycrank+209,	yysvec+24,	yyvstop+131,
yycrank+210,	yysvec+24,	yyvstop+133,
yycrank+200,	yysvec+24,	yyvstop+135,
yycrank+216,	yysvec+24,	yyvstop+138,
yycrank+217,	yysvec+24,	yyvstop+140,
yycrank+219,	yysvec+24,	yyvstop+142,
yycrank+231,	yysvec+24,	yyvstop+144,
yycrank+235,	yysvec+24,	yyvstop+146,
yycrank+227,	yysvec+24,	yyvstop+148,
yycrank+260,	yysvec+24,	yyvstop+150,
yycrank+238,	yysvec+24,	yyvstop+152,
yycrank+325,	yysvec+24,	yyvstop+155,
yycrank+329,	yysvec+24,	yyvstop+157,
yycrank+259,	yysvec+24,	yyvstop+159,
yycrank+292,	yysvec+24,	yyvstop+162,
yycrank+336,	yysvec+24,	yyvstop+165,
yycrank+337,	yysvec+24,	yyvstop+167,
yycrank+339,	yysvec+24,	yyvstop+169,
yycrank+346,	yysvec+24,	yyvstop+171,
yycrank+348,	yysvec+24,	yyvstop+173,
yycrank+347,	yysvec+24,	yyvstop+175,
yycrank+355,	yysvec+24,	yyvstop+177,
yycrank+0,	0,		yyvstop+179,
yycrank+0,	yysvec+41,	0,	
yycrank+0,	0,		yyvstop+181,
yycrank+423,	0,		yyvstop+183,
yycrank+0,	0,		yyvstop+185,
yycrank+354,	yysvec+24,	yyvstop+187,
yycrank+378,	yysvec+24,	yyvstop+190,
yycrank+385,	yysvec+24,	yyvstop+192,
yycrank+381,	yysvec+24,	yyvstop+194,
yycrank+370,	yysvec+24,	yyvstop+196,
yycrank+377,	yysvec+24,	yyvstop+198,
yycrank+387,	yysvec+24,	yyvstop+201,
yycrank+389,	yysvec+24,	yyvstop+203,
yycrank+393,	yysvec+24,	yyvstop+205,
yycrank+407,	yysvec+24,	yyvstop+208,
yycrank+409,	yysvec+24,	yyvstop+210,
yycrank+406,	yysvec+24,	yyvstop+212,
yycrank+400,	yysvec+24,	yyvstop+214,
yycrank+403,	yysvec+24,	yyvstop+217,
yycrank+420,	yysvec+24,	yyvstop+220,
yycrank+413,	yysvec+24,	yyvstop+222,
yycrank+416,	yysvec+24,	yyvstop+224,
yycrank+424,	yysvec+24,	yyvstop+226,
yycrank+428,	yysvec+24,	yyvstop+228,
yycrank+432,	yysvec+24,	yyvstop+230,
yycrank+431,	yysvec+24,	yyvstop+232,
yycrank+0,	0,		yyvstop+234,
yycrank+430,	yysvec+24,	yyvstop+236,
yycrank+438,	yysvec+24,	yyvstop+239,
yycrank+448,	yysvec+24,	yyvstop+241,
yycrank+441,	yysvec+24,	yyvstop+243,
yycrank+455,	yysvec+24,	yyvstop+245,
yycrank+449,	yysvec+24,	yyvstop+247,
yycrank+451,	yysvec+24,	yyvstop+249,
yycrank+458,	yysvec+24,	yyvstop+251,
yycrank+461,	yysvec+24,	yyvstop+254,
yycrank+464,	yysvec+24,	yyvstop+256,
yycrank+472,	yysvec+24,	yyvstop+258,
yycrank+468,	yysvec+24,	yyvstop+260,
yycrank+470,	yysvec+24,	yyvstop+263,
yycrank+471,	yysvec+24,	yyvstop+266,
yycrank+474,	yysvec+24,	yyvstop+269,
yycrank+478,	yysvec+24,	yyvstop+272,
yycrank+482,	yysvec+24,	yyvstop+274,
yycrank+484,	yysvec+24,	yyvstop+276,
yycrank+481,	yysvec+24,	yyvstop+278,
yycrank+490,	yysvec+24,	yyvstop+281,
yycrank+492,	yysvec+24,	yyvstop+284,
yycrank+498,	yysvec+24,	yyvstop+286,
yycrank+494,	yysvec+24,	yyvstop+288,
yycrank+502,	yysvec+24,	yyvstop+290,
yycrank+509,	yysvec+24,	yyvstop+292,
yycrank+510,	yysvec+24,	yyvstop+294,
yycrank+506,	yysvec+24,	yyvstop+296,
yycrank+513,	yysvec+24,	yyvstop+298,
yycrank+516,	yysvec+24,	yyvstop+300,
yycrank+519,	yysvec+24,	yyvstop+303,
yycrank+517,	yysvec+24,	yyvstop+305,
yycrank+536,	yysvec+24,	yyvstop+307,
yycrank+525,	yysvec+24,	yyvstop+309,
yycrank+526,	yysvec+24,	yyvstop+311,
yycrank+527,	yysvec+24,	yyvstop+314,
yycrank+528,	yysvec+24,	yyvstop+317,
yycrank+534,	yysvec+24,	yyvstop+319,
yycrank+546,	yysvec+24,	yyvstop+321,
yycrank+537,	yysvec+24,	yyvstop+323,
yycrank+540,	yysvec+24,	yyvstop+325,
yycrank+549,	yysvec+24,	yyvstop+328,
yycrank+547,	yysvec+24,	yyvstop+330,
yycrank+550,	yysvec+24,	yyvstop+333,
yycrank+553,	yysvec+24,	yyvstop+335,
yycrank+557,	yysvec+24,	yyvstop+337,
yycrank+564,	yysvec+24,	yyvstop+339,
yycrank+560,	yysvec+24,	yyvstop+341,
yycrank+561,	yysvec+24,	yyvstop+344,
yycrank+567,	yysvec+24,	yyvstop+347,
yycrank+570,	yysvec+24,	yyvstop+349,
yycrank+571,	yysvec+24,	yyvstop+351,
0,	0,	0};
struct yywork *yytop = yycrank+686;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'8' ,'8' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,'"' ,01  ,01  ,'8' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)(void)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				(void)fprintf(yyout,"char ");
				allprint(yych);
				(void)putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)(void)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					(void)fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					(void)putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)(void)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				(void)fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				(void)putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			(void)fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			(void)putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					(void)fprintf(yyout,"\nmatch ");
					sprint(yytext);
					(void)fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)(void)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
