/***********************************************************************\ 
*									* 
*   File: scorpion/src/xref/analyser/main.c 
*				 					* 
*   Copyright (C) 1991 Dean Throop
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: This function links up references to definitions       	*
*           in XREF directives of an xref syntax tree.                   *
*									*
*           The result of a linked syntax tree is a decorated syntax tree.*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/xref/analyser/RCS/main.c,v 4.0 89/04/12 08:04:55 cheung Exp Locker: cheung $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	main.c,v $
 * Revision 4.0  89/04/12  08:04:55  cheung
 * main.c  Ver 4.0
 * 
 * Revision 3.9  89/03/26  00:17:45  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.9  89/03/02  13:46:46  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.8  89/03/02  12:46:50  cheung
 * main.c  Ver 3.9
 * 
*									*
*   Edit Log:								*
*     Dec 20 1987 (rts) Modified to reflect changes in IDL specification*
*     May 2 1986 (ddt) Created revision history.			*
*									*
\* ******************************************************************* */


#include "stdio.h"
#include "analyser.h"

main()
{
/*
 *	This is the main procedure of the xref semantics analyser.
 */

	body thisbody;
	scope thisscope;
	
	thisbody = read_syntax_tree(stdin);

	thisscope = Nscope;
	thisscope->sem_previous_scope.VVoid = NVoid;
	initializeSEQEntity(thisscope->sem_entities);

	analyse_body(thisbody,thisscope);

	write_attributed_tree(stdout,thisbody,TWOPASS);
        return 0;
}

/*
 *   Create new scope linked to previous scope.
*/
#define push_scope(the_old_scope,the_new_scope)\
    {\
	the_new_scope = Nscope;\
	initializeSEQEntity(the_new_scope->sem_entities);\
	the_new_scope->sem_previous_scope.Vscope = the_old_scope;\
    }

/*
 *  Change the 'current_scope' variable to the previous
 *  scope of that scope.  If no scope exists, set it to null.
 */
#define find_previous_scope(current_scope)\
	if( typeof(current_scope->sem_previous_scope) == Kscope){\
	    current_scope = current_scope->sem_previous_scope.Vscope;\
	} else {\
	    current_scope = NULL;\
	}

analyse_body(thisbody,thisscope)
body thisbody;
scope thisscope;
{
  local alocal;
  SEQlocal locals;
  scope new_scope;
  declaration decl;		/* Current decl in iteration */
  SEQdeclaration state;		/* Current state for iteration */
  Entity Aen;

  thisbody->sem_scope = thisscope;
  /* Add declaration to scope */
  foreachinSEQdeclaration(thisbody->syn_declarations,state,decl){
    switch (typeof(decl)){
    case Kpredicate_declaration:{
      push_scope(thisscope,new_scope);
      foreachinSEQlocal(decl.Vpredicate_declaration->syn_formals, locals, alocal)
	{
	  Aen.Vlocal = alocal;
	  appendrearSEQEntity(new_scope->sem_entities, Aen);
	}

      analyse_expression(decl.Vpredicate_declaration->syn_value, new_scope);
      Aen.Vdeclaration = decl;
      appendrearSEQEntity(thisscope->sem_entities, Aen);
      break;
    }
    case Kfunction_declaration:{
      push_scope(thisscope, new_scope);
			
      foreachinSEQlocal(decl.Vfunction_declaration->syn_formals, locals, alocal)
	{
	  Aen.Vlocal = alocal;
	  appendrearSEQEntity(new_scope->sem_entities, Aen);
	}

      analyse_body(decl.Vfunction_declaration->syn_value, new_scope);
      Aen.Vdeclaration = decl;
      appendrearSEQEntity(thisscope->sem_entities, Aen);
      break;
    }
    default:{
      (void) fprintf(stderr,"Bad declaration in analyse_body\n");
    }

    }
  }
  analyse_sequence(thisbody->syn_sequence,thisscope);
}

analyse_expression(thisexpression,thisscope)
expression thisexpression;
scope thisscope;
{
  switch (typeof(thisexpression)){
  case Kunary_op:{
    analyse_expression(thisexpression.Vunary_op->syn_operand,
		       thisscope);
    break;
  }
  case Kbinary_op:{
    analyse_expression(thisexpression.Vbinary_op->syn_right_operand,
		       thisscope);
    analyse_expression(thisexpression.Vbinary_op->syn_left_operand,
		       thisscope);
    break;
  }
  case Krelational_expression: {
    analyse_atom(thisexpression.Vrelational_expression->syn_right_operand,
		      thisscope);
    analyse_atom(thisexpression.Vrelational_expression->syn_left_operand,
		      thisscope);
    break;
  }
  case Kpredicate_call: {
    analyse_predicate_call(thisexpression.Vpredicate_call, thisscope);
    break;
  }
  case Kempty_call: {
    analyse_sequence(thisexpression.Vempty_call->syn_sequence, thisscope);
    break;
  }
  default:{
    (void) fprintf(stderr,"Error in analyse_expression\n");
  }
    
  }
}

analyse_atom(thisatom,thisscope)
atom thisatom;
scope thisscope;
{
  switch (typeof(thisatom)) {
  case Kreference: analyse_reference(thisatom.Vreference,thisscope);
    break;
  case Kstring_constant: break;	/* nothing to do */
  case Khead:{
    analyse_sequence(thisatom.Vhead->syn_sequence, thisscope);
    break;
  }
  default: break;
  }
}

analyse_reference(thisreference,thisscope)
reference thisreference;
scope thisscope;
{
  /*
   *   Search scope for name and fill in reference info.
   */
  scope current_scope = thisscope;
  user_name desired_name;
  int found = 0;
  Entity current_entity;
  SEQEntity state;

  if (typeof(thisreference->syn_local)==KlocalOrletRef) {
    desired_name = thisreference->syn_local.VlocalOrletRef->syn_name;
    for (;;){
      /* Search current scope for desired name. */
      foreachinSEQEntity(current_scope->sem_entities,state,current_entity){
	if(current_entity.IDLclassCommon->syn_name->lex_value == desired_name->lex_value) {
	  if (typeof(current_entity) == Klocal){
	    found++;
	    thisreference->syn_local.VlocalOrletRef->sem_entity.Vlocal
	      = current_entity.Vlocal;
	  }
	  else if (typeof(current_entity) == Klet_variable) {
	    found++;
	    thisreference->syn_local.VlocalOrletRef->sem_entity.Vlet_variable
	      = current_entity.Vlet_variable;
	    if (lengthSEQuser_name(thisreference->syn_attributes)>0) {
	      (void) fprintf(stderr,
		      "Error: attributes specified for let variable \"%s\".\n",
		      desired_name->lex_value);
	      return;
	    }
	  }
	}
      }

      /* Check if found in the current scope */
      if(found > 0){
	if(found > 1){
	  (void) fprintf(stderr,
		  "Warning in analyse_reference, multiple definitions of %s\n",
		  desired_name->lex_value);
	}
	return;
      }

      /* Try next scope */
      find_previous_scope(current_scope);
      if(current_scope == NULL){
	(void) fprintf(stderr,
		"Error in analyse_reference, can't find \"%s\"\n",
		desired_name->lex_value);
	return;
      }
    }
  }
}

analyse_sequence(thissequence,thisscope)
sequence thissequence;
scope thisscope;
{
  sequence_element element;
  SEQsequence_element state;

  foreachinSEQsequence_element(thissequence->syn_values,state,element){
    switch (typeof(element)){
    case Ktype_construct:{analyse_type_construct(element.Vtype_construct, thisscope);
		break;
	      }
    case Kfunction_call:{
      analyse_function_call(element.Vfunction_call, thisscope);
      break;
    }
    case Ktail:{
      analyse_sequence(element.Vtail->syn_sequence, thisscope);
      break;
    }
    case Kcase_statement:{
      analyse_case_statement(element.Vcase_statement, thisscope);
      break;
    }
    case Klet_construct:{
      analyse_let_construct(element.Vlet_construct, thisscope);
      break;
    }
    case Kfor_statement:{
      analyse_for_statement(element.Vfor_statement, thisscope);
      break;
    }
    case Kreorder:{
      analyse_reorder(element.Vreorder, thisscope);
      break;
    }
    case Kfilter:{
      analyse_filter(element.Vfilter, thisscope);
      break;
    }
    case Kunique:{
      analyse_unique(element.Vunique, thisscope);
      break;
    }
    case Kintersection:{
      analyse_intersection(element.Vintersection, thisscope);
      break;
    }
    case Kdifference:{
      analyse_difference(element.Vdifference, thisscope);
      break;
    }
    case Kextra:{
      analyse_extra(element.Vextra, thisscope);
      break;
    }
    case Kreference:
    case Kstring_constant:
    case Khead:{
      analyse_atom(element.Vatom, thisscope);
      break;
    }
    default:{
      (void) fprintf(stderr, "Error in analyse_sequence, unknown sequence element\n");
    }
    }
  }
}

analyse_type_construct(thistype_construct,thisscope)
type_construct thistype_construct;
scope thisscope;
{
  analyse_sequence(thistype_construct->syn_sequence,thisscope);
}

analyse_function_call(thisfunction_call,thisscope)
function_call thisfunction_call;
scope thisscope;
{
  /*
   *	find function declaration and link reference to decl 
   *	push scope
   *	resolve actuals (relative to old scope)
   */
  scope current_scope = thisscope;
  int found = 0;
  atom thisatom;
  SEQatom atom_state;
  Entity anentity;
  SEQEntity state;

  for(;;){			/* Search for function declaration. */
    foreachinSEQEntity(current_scope->sem_entities, state, anentity)
      {
	if(typeof(anentity) == Kfunction_declaration){
	  if(thisfunction_call->syn_function->syn_name->lex_value ==
	     anentity.Vfunction_declaration->syn_name->lex_value) {
	     found ++;
	     thisfunction_call->syn_function->sem_entity
	     = anentity.Vfunction_declaration;
	   }
	}
      }
    if(found > 0){
      if(found > 1){
	(void) fprintf(stderr,
		"Warning, duplicate declarations of function \"%s\" found\n",
		thisfunction_call->syn_function->syn_name->lex_value);
      }
      break;
    }
      
    find_previous_scope(current_scope);
    if(current_scope == NULL){
      (void) fprintf(stderr,
	      "ERROR in analyse_function_call, can't find \"%s\"\n",
	      thisfunction_call->syn_function->syn_name->lex_value);
      return;
    }
  }

  /* Resolve function actuals. */
  foreachinSEQatom(thisfunction_call->syn_actuals, atom_state, thisatom)
    {
      analyse_atom(thisatom,thisscope);
    }
}

analyse_predicate_call(thispredicate_call,thisscope)
predicate_call thispredicate_call;
scope thisscope;
{
  /*
   *	find predicate declaration and link atom to decl 
   *	push scope
   *	resolve actuals (relative to old scope)
   */
  atom thisatom;
  SEQatom atom_state;

  analyse_predicateRef(thispredicate_call->syn_predicate, thisscope);

    /* Resolve predicate actuals. */
    foreachinSEQatom(thispredicate_call->syn_actuals, atom_state, thisatom)
      {
	analyse_atom(thisatom,thisscope);
      }
}

analyse_case_statement(thiscase_statement,thisscope)
case_statement thiscase_statement;
scope thisscope;
{
  branch thisbranch;
  SEQbranch state;
  scope new_scope;
  Entity Aen;

  analyse_atom(thiscase_statement->syn_atom,thisscope);

  /* Check all the branches of the case statement */
  foreachinSEQbranch(thiscase_statement->syn_branches, state,thisbranch)
    {
      push_scope(thisscope,new_scope);
      Aen.Vlocal = thiscase_statement->syn_local;
      appendrearSEQEntity(new_scope->sem_entities, Aen);
      analyse_body(thisbranch->syn_value,new_scope);
    }
}

analyse_let_construct(thislet_construct,thisscope)
let_construct thislet_construct;
scope thisscope;
{
  scope new_scope;
  SEQlet_variable Slet_variable;
  let_variable Alet_variable;
  Entity Aen;

  push_scope(thisscope,new_scope);
  foreachinSEQlet_variable(thislet_construct->syn_assignments,
			   Slet_variable,
			   Alet_variable) {
    analyse_sequence(Alet_variable->syn_sequence,new_scope);
    Aen.Vlet_variable = Alet_variable;
    appendrearSEQEntity(new_scope->sem_entities, Aen);
  }
  analyse_body(thislet_construct->syn_body, new_scope);
}

analyse_for_statement(thisfor_statement,thisscope)
for_statement thisfor_statement;
scope thisscope;
{
  scope new_scope;
  Entity Aen;

  analyse_sequence(thisfor_statement->syn_sequence,thisscope);
  push_scope(thisscope,new_scope);
  Aen.Vlocal = thisfor_statement->syn_local;
  appendrearSEQEntity(new_scope->sem_entities, Aen);
  analyse_body(thisfor_statement->syn_body,new_scope);
}

analyse_reorder(thisreorder,thisscope)
reorder thisreorder;
scope thisscope;
{
  analyse_predicateRef(thisreorder->syn_predicate,thisscope);
  analyse_sequence(thisreorder->syn_sequence,thisscope);
}

analyse_filter(thisfilter,thisscope)
filter thisfilter;
scope thisscope;
{
/*
 *      Same as reorder (but use unary_predicate)
*/
  analyse_predicateRef(thisfilter->syn_predicate,thisscope);
  analyse_sequence(thisfilter->syn_sequence,thisscope);
}

analyse_unique(thisunique,thisscope)
unique thisunique;
scope thisscope;
{
/*
 *      Same as reorder (but use binary_predicate)
*/
  analyse_predicateRef(thisunique->syn_predicate,thisscope);
  analyse_sequence(thisunique->syn_sequence,thisscope);
}

analyse_intersection(thisintersection,thisscope)
intersection thisintersection;
scope thisscope;
{
  analyse_predicateRef(thisintersection->syn_predicate,thisscope);
  analyse_sequence(thisintersection->syn_right_sequence,thisscope);
  analyse_sequence(thisintersection->syn_left_sequence,thisscope);
}


analyse_difference(thisdifference,thisscope)
difference thisdifference;
scope thisscope;
{
  analyse_predicateRef(thisdifference->syn_predicate,thisscope);
  analyse_sequence(thisdifference->syn_right_sequence,thisscope);
  analyse_sequence(thisdifference->syn_left_sequence,thisscope);
}

analyse_extra(thisextra,thisscope)
extra thisextra;
scope thisscope;
{
  analyse_sequence(thisextra->syn_right_sequence,thisscope);
  analyse_sequence(thisextra->syn_left_sequence,thisscope);
}

analyse_predicateRef(thispredicateRef, thisscope)
predicateRef thispredicateRef;
scope thisscope;
{
  /*
   *	find predicate and link to declaration
   */
  scope current_scope = thisscope;
  int found = 0;
  Entity thisentity;
  SEQEntity state;

  if (thispredicateRef->syn_name->lex_value == NewString("Is"))
    thispredicateRef->sem_entity.VIsPredicate = NIsPredicate;
  else {			/* call to a user-defined function */
    for(;;){			/* Search for predicate declaration. */
      foreachinSEQEntity(current_scope->sem_entities, state, thisentity)
	{
	  if(typeof(thisentity) == Kpredicate_declaration){
	    if(thispredicateRef->syn_name->lex_value ==
	       thisentity.Vpredicate_declaration->syn_name->lex_value){
	      found ++;
	      thispredicateRef->sem_entity.Vpredicate_declaration
		= thisentity.Vpredicate_declaration;
	    }
	  }
	}
      
      if(found > 0){
	if(found > 1){
	  (void) fprintf(stderr,
		  "Warning, duplicate declarations of predicate \"%s\" found\n",
		  thispredicateRef->syn_name->lex_value);
	}
	break;
      }
      
      find_previous_scope(current_scope);
      if(current_scope == NULL){
	(void) fprintf(stderr,
		"ERROR in analyse_predicateRef, can't find \"%s\"\n",
		thispredicateRef->syn_name->lex_value);
	return;
      }
    }
  }
}
