/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/where.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	Show where one is at in the IDL instance.
 *
 *	Functions :	where()
 */


/**** INCLUDE FILES ****/

#include <stdio.h>
#include "global.h"
#include "history.h"


/**** CODE ****/

/*
 *	Routine :	where()
 *
 *	Description :	This command will print the history of the traversals
 *			leading up to the current item.  No modification of
 *			the history of traversals is required.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
void where()
{

	history		*histptr;

	(void)printf("Root");

	for ( histptr = Historylist->prev; histptr != Historylist;
	        histptr = histptr->prev )
	{
			
		(void)printf(".");
		if ( histptr->gotoname )
		{
			(void)printf("GOTO (%s)", histptr->gotoname);
			continue;
		}

		(void)printf("%s", histptr->attrname);

		if ( histptr->searchkey )
		{
			(void)printf("(%s=%s)", histptr->searchkey,
				histptr->searchvalue);
		}

		if ( histptr->elementnum > 0 )
		{
			(void)printf("[%d of %d]", histptr->elementnum,
				histptr->listsize);
		}
	}
	(void)printf("\n");

}  /* end of where() */
