/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/up.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	The command up is coded in this file.
 *
 *	Functions :	up()
 */


/**** INCLUDE FILES ****/

#include <stdio.h>
#include "global.h"
#include "history.h"
#include "up.h"
#include "list.h"
#include "utilities.h"



/**** CODE ****/

/*
 *	Routine :	up()
 *
 *	Description :	Make the current item, the last item that was visited.
 *			If the current item is at the root of the instance, 
 *			then this command should print an error message and
 *			ignore the directive.  Otherwise, remove the last
 *			element from the history of traversals, and make
 *			that item the current element.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
void up()
{

	history 	*temp;
	setseqhist	*temp2;
	qnode		*remlist();
	void		list();
	

	if ( isempty((qnode *)Historylist) )
	{
		exception(AT_ROOT_NODE);
		return;
	}

	temp = (history *)remlist((qnode *)Historylist);
	Currentitem = temp->lastitem;
	
	if ( temp->elementnum > 0 )
	{
		temp2 = (setseqhist *)remlist((qnode *)Liststack);
		free((char *)temp2);
	}

	Destroy_history_node(temp);

	list(1, NULL);

	return;

}  /* end of up() */
