/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/modify.h 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 *	Description :	This is the header file for the modify submodule.
 */


/**** DECLARATIONS ****/

/*
 *	Routine :	search()
 *
 *	Description :	This command feature will search the entire IDL
 *			instance starting from the root node for occurrences
 *			of a specific value from a given attribute name.  The
 *			set of matches, if any, should be placed on the list
 *			stack so that they may be reviewed by the user at thier
 *			convienence.
 *
 *	Arguments :	attribute_name	     (IN) -- The name of the attribute
 *					     to search under each node.
 *			value		     (IN) -- The value to look for
 *					     if an attribute name is matched.
 *			interactive_mode     (IN) -- If the search is from
 *					     the input line, then YES.  If
 *					     the search in internal, then NO.
 *
 *	Return Value :	1 if a match is found, 0 otherwise.
 *
 *	Side Effects :	If any matches are found, they will be added to the
 *			list stack for further inspection by the user.
 */
extern int search();
