/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/main.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	Here is the uppermost level of treewalk.  The
 *			three routines listed here are the main modules
 *			for the program.
 */


/**** INCLUDE FILES ****/

#include <stdio.h>
#include "global.h"

char	*Program_name;


/**** CODE ****/

main(argc, argv)
int	 argc;
char	*argv[];
{
	void	Read_Input_File(), version();
	void	Process_User_Commands();
	void	Instantiate_Data_Structures();

	Program_name = StringToChar(argv[0]);
	if ( argc == 2 && ! strcmp(argv[1], "-V") )
	{
		version();
		exception(BAD_COMMAND_LINE, Program_name);
	}

	Read_Input_File(argc, argv);

	Instantiate_Data_Structures();

	Process_User_Commands();

	return (0);

}  /* end of main() */
