/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/history.h 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 *	Description :	The structures and instances of the data types
 *			used to maintain previous traversals of an IDL
 *			instance are declared here.
 */


/**** DEFINITIONS ****/

typedef struct history
{
	struct history	*next;		/* This is the structure which */
	struct history  *prev;		/* keeps track of the path to */
	IDLVALUE	 lastitem;	/* the current node. */
	int		 elementnum;
	int		 listsize;
	char		*gotoname;	/* Name that was goto'ed */
	char		*attrname;	/* Attribute that was down'ed */
	char		*searchkey;	/* Attribute that was searched */
	char		*searchvalue;	/* Value that was searched for */
} history;


typedef struct sl
{
	struct sl	*next;		/* This will be the structure to */
	struct sl	*prev;		/* maintain what is the current */
	IDLVALUE	 setorseq;	/* set or seq. */
	struct history  *begin;
} setseqhist;


/**** DECLARATIONS ****/

extern history	*Historylist;		/* This is the record of the */
					/* current path.  It is */
					/* declared in Instantiate */
					/* Data Strucures */
	
extern setseqhist  *Liststack;		/* The Liststack keeps track of */
					/* the path of SET and SEQ traversed */
					/* to attain the current item. */

extern char	*Defaultfile;		/* the filename that will be the */
					/* default in output. */

extern history	*Create_history_node();
extern void	 Destroy_history_node();
