/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/help.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	The user needs help remembering the commands,
 *			and this function will provide it.
 */

/**** INCLUDE FILES ****/

#include <stdio.h>
#include "global.h"
#include "help.h"


/**** DECLARATIONS ****/

char	*Helptext[] =
{
  "Available commands (optional arguments appear in [ ])",
  "",
  "?              - Print list of commands for %s.",
  "b              - Move Back one item in the current Set or Sequence.",
  "c [n] [m]      - Change information in the m-th element (default=1) of",
  "                 the n-th attribute (default=1) of the current node.",
  "d [n] [m]      - Move Down to the m-th element (default=1) of",
  "                 the n-th attribute (default=1) of the current node.",
  "f              - Traverse Forward along the current Set or Sequence.",
  "g name         - Goto the item with the identifier \"name\".",
  "h              - Jump to the Head of the current Set or Sequence.",
  "i file         - Input a new IDL instance from specified file.",
  "l [n] [m]      - List the attributes of the current node. Start at",
  "                 the n-th attribute (default=last attribute displayed)",
  "                 and end at the m-th attribute (default=largest numbered",
  "                 attribute such that the display will fit on one screen).",
  "m n            - Move n places in the current Set or Sequence.",
  "n [name]       - Identify the current item with \"name\".  Use with goto.",
  "                 If \"name\" is not given, display list of existing names.",
  "o [file]       - Output the current IDL instance to specified file",
  "                 (default=the filename of the current IDL instance).",
  "q              - Quit %s.  Will not save current IDL instance.",
  "r label        - Relabel the current node to be \"label\".",
  "s attr value   - Search for nodes with attribute name \"attr\" and",
  "                 value \"value\". If \"attr\" is the word 'type' then",
  "                 the search is for nodes with a node type of \"value\". If",
  "                 \"attr\" is the word 'for' then the search is for nodes",
  "                 with the label \"value\".",
  "t              - Jump to the Tail of the current Set or Sequence.",
  "u              - Move Up to the last item displayed.",
  "v              - Display current Version number of %s",
  "w              - (Where) Show path from the Root to the current item.",
  "x              - Exit %s.  Same as Quit.",
  NULL
};


/**** CODE ****/

/*
 *	Routine :	help()
 *
 *	Description :	This function is called when the user is confused.
 *			The help feature will print a brief one-line sum-
 *			mary of each command available to treewalk.  The
 *			output should be printed in pages that fit onto
 *			the screen, and after each page is printed, prompt
 *			the user to continue.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
void help()
{
	void	pause();

	int lncount = 0;
	int	i;

	for ( i = 0; Helptext[i] != NULL; i++ )
	{
		if ( ++lncount % LINES == 0 )
			pause();

		(void)printf(Helptext[i], Program_name);
		(void)printf("\n");
	}

	pause();
	list(1, NULL);

}  /* end of help() */


void pause()
{
	(void)printf("Press <Return> to continue");
	if ( getchar() )
		return;
} 
