/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/global.h 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 *	Header file containing declarations to all the global types
 *	used in treewalk.
 */

/**** INCLUDE FILES ****/

#include "treewalk.h"


/**** DEFINITIONS ****/

#define BAD_COMMAND_LINE	1	/* These are error conditions for */
#define AT_ROOT_NODE		2	/* the exception() routine */
#define	BAD_COMMAND		3
#define NUM_OF_ARGS		4
#define OUT_OF_BOUNDS		5
#define BAD_OPTION		6
#define ILLEGAL_CHARACTER	7
#define FILE_NONEXISTENT	8
#define BAD_LABEL		9
#define UNABLE_TO_ACCESS	10
#define BAD_INSTANCE_SAVE	11
#define EOF_FOUND		12
#define NONNUM_ARG		13
#define NOT_HERE		14
#define TYPE_MISMATCH		15
#define BAD_WRITE		16
#define OUT_OF_MEMORY		17
#define FILE_OPEN_ERROR		18
#define BAD_READ		19
#define LIST_STACK_EMPTY	20
#define BAD_RELABEL		21
#define DUPLICATE_LABEL		22
#define EMPTY_SYM_TABLE		23
#define CRITICAL_ERROR		99

#define	NUMOFCOMMANDS		20	/* Total number of directives that */
					/* the program accepts */

#define	YES	1
#define NO	0

/**** MACROS ****/

#define Currenttype	( typeof(Currentitem) )  
#define Currentnode	( Currentitem.VnodeDesc )

/**** DECLARATIONS ****/

extern void	exception();    /* this function in utilities.c has all  */
				/*  the error messages in it */

extern char	*malloc_();
extern char	*calloc_();

extern nodeDesc	Root;
extern char	*Program_name;

extern void	Set_changed_flag(), Clear_changed_flag();
extern int	Test_changed_flag(), Query_upon_change();

extern int	Get_default_arg();
extern int	Validate_label();
