/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/down.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	Implement the down feature.
 * 
 *	Functions :	down()
 *			check_for_basic_type()
 *			changeCurrentitem()
 *			insertListstack()
 */

/**** INCLUDE FILES ****/

#include <stdio.h>
#include "global.h"
#include "history.h"
#include "list.h"
#include "utilities.h"



/**** DECLARATIONS ****/

char	*typearray[] =
{
	"integer",
	"rational",
	"boolean",
	"string",
	"unknown"
};



/**** CODE ****/

/*
 *	Routine :	down()
 *
 *	Description :	This function provides the mechanism to move the
 *			current item through a node or a sequence.  Down()
 *			requires three arguments.  When the arguments are
 *		 	NULL or 0, then the default steps to down are
 *			taken.  All valid arguments are assumed to be 
 *			positive.  Down will check to see if the item
 *			that it is to traverse to exists, and if not
 *			no traversal is made.  Also the record of the
 *			traversal must be saved in order to determine
 *			the history of the commands.
 *
 *	Arguments :	attribute	- (IN) if positive, the number
 *					  of the attribute to visit if
 *					  the current item is a node.  If
 *					  0, then traverse to the first
 *					  attribute displayed.
 *			nth_element	- (IN) if positive, the number of
 *					  the element in the set or seq
 *					  indicated by attribute.  If 0, then
 *					  the default is the first element.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
void down(attribute, nth_element)
int	attribute;
int	nth_element;
{
	char	*check_for_basic_type();
	void	 changeCurrentitem(), insertListstack(),list();
	attrDesc 	current_attr;
	IDLVALUE	set_seq_ele;
	SEQIDLVALUE	rmember;
	int		set_ln, count_element;
	char		*basictype;

	/*
	 *	If the current item is a basic type, then no down traversal
	 *	can be made.
	 */

	if ( ( basictype = check_for_basic_type() ) != NULL )
	{
		exception(BAD_OPTION, "go down to", basictype);
		return;
	}

	/*
	 *	If the arguments to the function are NULL then set them to the
 	 *	default values.
	 */

	if ( attribute == 0 )
		attribute = Current_line;

	/*
	 *	See if the attribute number is in the scope of the node.
	 */

	ithinSEQattrDesc(Currentnode->attributes, attribute, current_attr);
	if ( current_attr == NULL )
	{
		exception(OUT_OF_BOUNDS, "attribute", "node");
		return;
	}
	
	/*
	 *	If the item to be traversed to is a SET or SEQ then
	 *	the element number of the particular structure must
	 *	be found and made the current node.  Otherwise just
	 *	make whatever item at the indicated attribute the
	 *	current item.
	 */

	switch ( typeof(current_attr->value) )
	{

	  case KsequenceDesc:
		if ( nth_element == 0 )
			nth_element = 1;
		ithinSEQIDLVALUE(current_attr->value.VsequenceDesc->value,
				 nth_element, set_seq_ele);
		if ( set_seq_ele.IDLclassCommon == NULL )
		{
			exception(OUT_OF_BOUNDS, "element", "sequence");
			return;
		}

		changeCurrentitem(set_seq_ele, current_attr, nth_element,
				 lengthSEQIDLVALUE(current_attr->value.
					           VsequenceDesc->value));
		insertListstack(current_attr->value);
		break;

	  case KsetDesc:
		if ( nth_element == 0 )
			nth_element = 1;
		set_ln = lengthSEQIDLVALUE(current_attr->value.VsetDesc->value);
		if ( nth_element > set_ln )
		{
			exception(OUT_OF_BOUNDS, "element", "set");
			return;
		}
		count_element = nth_element;
		foreachinSEQIDLVALUE(current_attr->value.VsetDesc->value,
				     rmember, set_seq_ele)
			if ( --count_element == 0 )
				break;

		changeCurrentitem(set_seq_ele, current_attr,nth_element,set_ln);
		insertListstack(current_attr->value);
		break;

	  default :
		if ( nth_element != 0 )
		{
			exception(OUT_OF_BOUNDS, "element",
				  "non-set or non-sequence type");
			return;
		}

		changeCurrentitem(current_attr->value, current_attr, 0, 0);
		break;

	}

	/*
	 *	Display the current item after the traversal
	 */

	list(1, NULL);

}  /* end of down() */


/*
 *	Routine :	check_for_basic_type();
 *
 *	Description :	This function examines the current attribute to
 *			see if it is of a type Integer, Rational, String,
 *			or Boolean.
 *
 *	Return Value :	string if it is one of the basic types, 0 if not.
 *
 *	Side Effects :	None.
 */
char *check_for_basic_type()
{
	if ( Currenttype == KnodeDesc || 
	     Currenttype == KsetDesc ||
	     Currenttype == KsequenceDesc )
		return NULL;

	if ( Currenttype == KintegerDesc )
		return typearray[0];

	if ( Currenttype == KrationalDesc )
		return typearray[1];

	if ( Currenttype == KbooleanDesc )
		return typearray[2];

	if ( Currenttype == KstringDesc )
		return typearray[3];

	return typearray[4];
}


/*
 *	Routine :	changeCurrentitem()
 *
 *	Description :	Saves current item on stack, gives Currentitem the
 *			value of the argument.
 */
void changeCurrentitem(newitem, attribute, nth_element, listsize) 
IDLVALUE	newitem;
attrDesc	attribute;
int		nth_element;
int		listsize;
{
	(void)Create_history_node(Currentitem, nth_element, listsize, 
			(char *)NULL, attribute->name, (char *)NULL,
			(char *)NULL);
	Currentitem = newitem;
}


/*
 *	Routine :	insertListstack()
 *	
 *	Description :	If the type which was traversed is a SET or SEQ then
 *			it must be pushed onto the list stack.
 */
void insertListstack(element)
IDLVALUE element;
{

	setseqhist	*listptr;
	void		inslist();

	listptr = (setseqhist *)malloc_(sizeof(setseqhist));
	listptr->setorseq = element;
	listptr->begin = Historylist->next;
	inslist((qnode *)Liststack, (qnode *)listptr);
	return;

}   /* end of insertListstack() */
