/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/ReadInputFile.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	This is a module of treewalk whose function is to read
 *			an arbitrary IDL instance using IDLRead.  The file to
 *			read from is contained in the arguments passed to the
 *			module.
 */

/**** INCLUDE FILES ****/
#include <stdio.h>
#include <sys/file.h>
#include "global.h"
#include "C/IDLIO.h"

void exit();

/**** DECLARATIONS ****/

nodeDesc 	Root;
char		*Defaultfile;


/**** CODE ****/

void Read_Input_File(argc, argv)
int	 argc;
char	*argv[];
{
	FILE	*IDL_in;
	char    *strcpy();

/*
 *	Perform diganostics upon the command line.  If there are too few
 *	or too many arguments, then abort treewalk.
 */

	if ( argc != 2 )
		exception(BAD_COMMAND_LINE, Program_name);
 
/*
 *	Check for file existence before opening.  If not existent then
 *	abort treewalk.
 */

	if ( access(argv[1], R_OK) == -1 )
		exception(FILE_NONEXISTENT, argv[1]);

	(void)printf("Reading IDL instance in %s...\n", argv[1]);

	if ( ( IDL_in = fopen(argv[1], "r") ) == NULL )
	{
		exception(FILE_OPEN_ERROR, "input");
		exit(1);
	}

	/*
	 *	Read the IDL instance into memory.
	 */

	if ( ! ( Root = IDLread(fileno(IDL_in) ) ) )
	{
		exception(BAD_READ);
		(void)fprintf(stderr,"%s\n", IDLreaderror);
   		exit(1);
	} 

	/*
	 *	Now that the instance was read in successfully, save
	 *	the input filename, to be the default filename in future
	 *	file operations.
	 */

	Defaultfile = (char *)malloc_(strlen(argv[1]) + 1);
	(void)strcpy(Defaultfile, argv[1]);

}  /* end of Read_Input_File() */
