/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/ProcessUserCommands.h 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 *	Description :	The header file for the C file ProcessUserCommands.c.
 *			This module is comprised of three submodules.
 *				1) ReceiveUserCommands
 *			     	2) ParseUserCommands
 *				3) Execute
 */


/**** DECLARATIONS ****/

/*
 *	Routine :	Receive_User_Commands()
 *
 *	Description :	This function provides the interface between treewalk
 *			and the user input.  Receive_User_Commands() reads
 *			in characters from stdin and will then proceed to
 *			do the following:
 *				1.  Check for nonalphanumeric characters.
 *				2.  Remove whitespaces and tabs.
 *				3.  Take the input and place it in a buffer
 *				    where each word in the buffer is sep-
 *				    arated by exactly one space.
 *				4.  The first word in the buffer is con-
 *				     verted to lower case.
 *
 *	Arguments :	inputline   - (OUT) the buffer which to store
 *				      the input stream.
 *
 *	Return Value :  A value of 0 is returned for any of the errors
 *			mentioned above are encountered.  1 for sucess.
 *
 *	Side Effects :  None.
 */
extern int	 Receive_User_Commands();

/*
 *	Routine :	Parse_User_Command()
 *
 *	Description :	The input to this function is assumed to have
 *			been generated through Receive_User_Command.
 *			The first word in the input buffer is assumed
 *			to be a command in lower case letters.  This
 *			command is compared to the known commands for
 *			validity.  After the command has been established
 *			as legal, the rest of the line is inserted into a
 *			data structure similar to argv in C.
 *
 *	Arguments :	inputline   - (IN) the buffer where the already
 *				      read in input is stored.
 *
 *	Return Value :  Return of 0 if the command is invalid, else return
 *			1 for sucess.
 *
 *	Side Effects :  None.
 */
extern int	 Parse_User_Commands();

/*
 *	Routine :	Execute()
 *
 *	Description :	This is the command interpreter for treewalk.
 *			Execute() assumes that any command given to it is
 *			valid, although the validity of the arguments
 *			is checked within Execute().  From the command
 *			structure as constructed by Parse_User_Commands(),
 *			Execute() will then direct the arguments to the
 *			appropriate function.
 *
 *	Arguments :	None.
 *
 *	Return Value :  Only if the user gives a directive to abort
 *			treewalk, will Execute return a 0.  Otherwise
 *			a 1 is the return value.
 *
 *	Side Effects :  None.
 */
extern int	 Execute();
