/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/ProcessUserCommands.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	The interactive environment is provided by this high
 *			level module.
 */

/**** INCLUDE FILES ****/

#include "global.h"
#include "ProcessUserCommands.h"
#include "ReceiveUserCommands.h"


/**** CODE ****/

void Process_User_Commands()
{
	char	input_line[MAXLINE + 1];

	/*
	 *  The while loop is infinite.  The only way to break out of it is
	 *  for the user to give a quit directive, in which case treewalk
  	 *  will begin termination.
	 */

	while ( 1 )
	{
		if ( ! Receive_User_Commands(input_line) )
			continue;

		if ( ! Parse_User_Commands(input_line) )
		{
			continue;
		}

		if ( ! Execute() )
			break;
	}

}  /* end of Process_User_Commands() */
