/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/ParseUserCommands.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	The module will given an input line, separate it into
 *			meaningful parts to give to the interpreter.
 *
 *	Functions :	Parse_User_Commands()
 *			determine_command()
 *			wordcpy()
 *
 */

/**** INCLUDE FILES ****/

#include <stdio.h>
#include <string.h>
#include "global.h"
#include "command.h"


/**** DECLARATIONS ****/

char	*myargv[35];	/* these are the objects used to transfer the */
int	 myargc;	/* command information to other modules. */


/**** CODE ****/

/*
 *	Routine :	Parse_User_Command()
 *
 *	Description :	The input to this function is assumed to have
 *			been generated through Receive_User_Command.
 *			The first word in the input buffer is assumed
 *			to be a command in lower case letters.  This
 *			command is compared to the known commands for
 *			validity.  After the command has been established
 *			as legal, the rest of the line is inserted into a
 *			data structure similar to argv in C.
 *
 *	Arguments :	inputline   - (IN) the buffer where the already
 *				      read in input is stored.
 *
 *	Return Value :  Return of 0 if the command is invalid, else return
 *			1 for sucess.
 *
 *	Side Effects :  None.
 */
int Parse_User_Commands(cmd_line)
char	*cmd_line;
{
	int	 pos = 0, there_are_args = 0;

	/*
	 * the first word should be the command, all following entries
	 * are assumed to be arguments for the command.
	 */

	myargc = 0;
	if ( pos = wordcpy(cmd_line, pos, &myargv[0]) )
		there_are_args = 1;

	if ( ! determine_command(myargv[0]) )
	{
		exception(BAD_COMMAND, myargv[0]);
		return 0;
	}

	/*
 	 *	The command was valid, so put the arguments into the
	 *	argument structure.
	 */

	if ( there_are_args )
		while ( pos = wordcpy(cmd_line, pos, &myargv[++myargc]) )
			;

	return 1;

}  /* end of Parse_User_Commands() */


/*
 *	Routine :	determine_command()
 *
 *	Description :	The first word from the command line is compared
 *			to the list of available commands.  If the command
 *			given is valid, then true is returned, otherwise
 *			failure is indicated.
 *
 *	Arguments :	command		- (IN/OUT) the command to be tested.
 *
 *	Return Value :	1 for success, 0 for failure.
 *
 *	Side Effects :	The command will be replaced by a unique handle
 *			which is how all further instances of this
 *			command will be accessed..
 */
int determine_command(command)
char	*command;
{
	int	i = -1;

	while ( ++i < NUMOFCOMMANDS )
	{
		if ( !strcmp(command, Commands[i]->full_name) ||
		     !strcmp(command, Commands[i]->first_letter) )
		   {
				(void)strcpy(command, Commands[i]->first_letter);
				return 1;
		   }
	}

	return 0;

}  /* end of determine_command() */


/*
 *	Routine :	wordcpy()
 *
 *	Description :	Similar to the C routine strcpy, wordcpy() extracts
 *			the sequence of characters from the indicated
 *			position to the next space of null terminator.
 *			The function returns the position in the string of
 *			the next non-space character.
 *
 *	Arguments :	line	- (IN) the string to be scanned.
 *			pos	- (IN) position in the string to begin the scan
 *			dest	- (OUT) the buffer to place the word.
 *
 *	Return Value :	If the null terminator is reached, a NULL is
 *			returned.  In any other case, the position of the
 *			next word in the string is given.
 *
 *	Side Effects :	None.
 */
int wordcpy(line, pos, dest)
char	line[];
int	 pos;
char	*dest[];
{
	int	wordlen = 0, temppos;
	int	foundendln = 0;

	while ( !foundendln && line[pos] != ' ' )
	{
		if ( line[pos] == '\0' )
		{
			foundendln = 1;
			break;
		}

		pos++;
		wordlen++;
	}
	temppos = pos++ - 1;

	*dest = (char *)malloc_(wordlen + 1);

	*(*dest + wordlen--)= '\0';
	while ( wordlen >= 0 )
		*(*dest + wordlen--) = line[temppos--]; 

	return ( foundendln ? 0 : pos++ );

}  /* end of wordcpy() */

