/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/InstantiateDataStructures.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	The functions below will allocate space for the
 *			global variables, and set initial values to them.
 *
 *	Functions :	Instantiate_Data_Structures()
 *			initialize_command_list()
 *			set_screen_info()
 */

/**** INCLUDE FILES ****/

#include <stdio.h>
#include <curses.h>
#include "global.h"
#include "list.h"
#include "history.h"
#include "symbol.h"
#include "command.h"
#include "utilities.h"


/**** MACROS ****/

#define new_cmd_node()	    ( (command_list *)malloc_(sizeof(command_list)) )
#define make_command(X, Y, Z)	Commands[X] = new_cmd_node(); \
				Commands[X]->full_name = Y; \
				Commands[X]->first_letter = Z;


/**** DECLARATIONS ****/

command_list	*Commands[NUMOFCOMMANDS];
int		 Current_line = 1;
char		*printbuf;
char		*tempbuf;
IDLVALUE	 Currentitem;
history		*Historylist;
setseqhist	*Liststack;
symbol		*Symboltable;
int		 Instance_has_been_changed = 0;
void 		 initlist();


/**** CODE ****/

/*
 *	Routine :	Instantiate_Data_Structures()
 *
 *	Description :	This is a module of treewalk which will initalize
 *			all of the data structures used in the rest of
 *			the program.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
void Instantiate_Data_Structures()
{
	void	initialize_command_list();
	void	set_screen_info(), list();

	
	/*
 	 *	Initialize the history list
	 */

	Historylist = (history *)malloc_(sizeof(history));
	Currentitem.VnodeDesc = Root;
	initlist((qnode *)Historylist);
	Historylist->lastitem = Currentitem;

	/*
	 *	Initialize the Liststack
 	 */

	Liststack = (setseqhist *)malloc_(sizeof(setseqhist));
	initlist((qnode *)Liststack);

	/*
	 *	Initialize the Symboltable
	 */

	Symboltable = (symbol *)malloc_(sizeof(symbol));
	initlist((qnode *)Symboltable);

	/*
	 *	Recognize the format of the acceptable commands
	 */

	initialize_command_list();

	/*
	 *	Get the termcap info of the terminal for output formatting
	 */

	set_screen_info();

	/*
	 *	Display the root node to the screen
	 */

	list(1, NULL);

}  /* end of Instantiate_Data_Structures() */


/*
 *	Routine :	initialize_command_list()
 *
 *	Description :	The names of all the acceptable commands are stored
 *			in a fixed array, and this routine intiializes the
 *			array to hold all the command names.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
void initialize_command_list()
{

/*
 *	make_command() is a macro which will store the last two arguments
 *	into the array Commands[] at the position of the first arguments.
 *	
 *	Note : all commands must be put into the list in lower case.  Upper
 *	       case commands will not be recognized by the parser.
 */

	make_command(0, "quit", "q");
	make_command(1, "help", "?");
	make_command(2, "up", "u");
	make_command(3, "back", "b");
	make_command(4, "change", "c");
	make_command(5, "down", "d");
	make_command(6, "forward", "f");
	make_command(7, "goto", "g");
	make_command(8, "head", "h");
	make_command(9, "input", "i");
	make_command(10, "list", "l");
	make_command(11, "move", "m");
	make_command(12, "name", "n");
	make_command(13, "output", "o");
	make_command(14, "relabel", "r");
	make_command(15, "search", "s");
	make_command(16, "tail", "t");
	make_command(17, "where", "w");
	make_command(18, "version", "v");
	make_command(19, "exit", "x");

}  /* end of intialize_command_list() */


/*
 *	Routine :	set_screen_info()
 *
 *	Description :	All this routine will do is use the curses functions
 *			and termcap database to determine the configuration
 *			of the terminal.
 */
void set_screen_info()
{

	(void)initscr();
	endwin();
	printbuf = (char *)malloc_(COLS + 1);
	tempbuf = (char *)malloc_(COLS + 1);
}
