/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/Execute.h 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 
/*
 *
 *	Description :	This header file accompanies Execute.c.  The large
 *			number of external functions exists because of the
 *			duty of Execute.c, which is to execute all the
 *			commands in treewalk.
 */


/**** DECLARATIONS ****/


/*
 *	Routine :	change()
 *
 *	Description :	This function is set to change the information of the
 *			given item.  Typechecking is performed upon the new
 *			item before replacing the old one.  The current item
 *			is retained as being current.  Changes are not
 *			allowed for items which are of type SET or SEQ.
 *
 *	Arguments :	attrnum		- (IN) if the current item is a
 *					  node, then this is the attribute
 *				 	  number to be changed.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void change();

/*
 *	Routine :	down()
 *
 *	Description :	This function provides the mechanism to move the
 *			current item through a node or a sequence.  Down()
 *			requires three arguments.  When the arguments are
 *		 	NULL or 0, then the default steps to down are
 *			taken.  All valid arguments are assumed to be 
 *			positive.  Down will check to see if the item
 *			that it is to traverse to exists, and if not
 *			no traversal is made.  Also the record of the
 *			traversal must be saved in order to determine
 *			the history of the commands.
 *
 *	Arguments :	attribute	- (IN) if positive, the number
 *					  of the attribute to visit if
 *					  the current item is a node.  If
 *					  0, then traverse to the first
 *					  attribute displayed.
 *			nth_element	- (IN) if positive, the number of
 *					  the element in the set or seq
 *					  indicated by attribute.  If 0, then
 *					  the default is the first element.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 down();

/*
 *	Routine :	go_to()
 *
 *	Description :	This is the function which will make the current item
 *			whatever is referenced by the name specified.  The
 *			naming of items if assumed to be done by function
 *			name().  If the name does not exist as a label, then
 *			an error message is produced, and no traversal is
 *			made.  When the current item changes, then a record
 *			of the movement must be appended to the history
 *			structure.
 *
 *	Arguments :	place	- (IN) the name of the label of the object
 *				  to travel to.
 *
 *	Return Value :  None.
 *
 *	Side Effects :	None.
 */
extern void      go_to();

/*
 *	Routine :	head()
 *
 *	Description :	If the current item is a member of a set or sequence
 *			then this function will go to the head, or beginning
 *			of the set or seq.  If the current item is not a
 *			member of either of the two structures, then an
 *			error message is printed, and no traversal is per-
 *			formed.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 head();

/*
 *	Routine :	help()
 *
 *	Description :	This function is called when the user is confused.
 *			The help feature will print a brief one-line sum-
 *			mary of each command available to treewalk.  The
 *			output should be printed in pages that fit onto
 *			the screen, and after each page is printed, prompt
 *			the user to continue.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 help();

/*
 *	Routine :	input_new_instance()
 *
 *	Description :	The user wants a new instance in memory, so this
 *			function will give it to him.  If the specified file
 *			does not exist, or there is an error in the IDL
 *			reading, then an error message should be printed
 *			but the old instance remains current.  The old
 *			instance need not be erased from memory upon reading
 *			the new instance.  All the data structures for
 *			past history, list stacks, etc. must be reset to
 *			initial values.
 *
 *	Arguments :	filename	- (IN) the filename to be read in.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 input_new_instance();

/*
 *	Routine :	list()
 *
 *	Description :	Probably the most abused of all the commands, list()
 *			displays the information of the current item.  List()
 *			requires 2 arguments, which must be positive or
 *			NULL.  If any of the arguments are NULL, then default
 *			value for that argument is used.  All the information
 *			printed to stdout should either fit onto the screen
 *			or be terminated before wrapping around the screen.
 *
 *	Arguments :	start	- (IN) the attribute number to begin printing
 *				  the current node.  If start is 0, then
 *				  begin printing from the last line printed.
 *			finish	- (IN) the last line to be printed in the
 *				  current node.  If finish == 0, then default
 *				  to the maximum number of attributes that
 *				  fit on one screen.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 list();

/*
 *	Routine :	move()
 *
 *	Description :	If the current item is a member of a set or sequence
 *			then it will move to a new element of that particular
 *			structure as given by a displacement.  A negative
 *			displacement will indicate traversal toward the
 *			beginning of the set or seq, while a positive
 *			number will direct motion toward the rear.  A 
 *			displacement of 0 indicates no change in position.
 *			A record of the motion must be maintained for
 *			historical purposes.
 *
 *	Arguments :	displacement	- (IN) the number of elements to
 *					traverse.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 move();

/*
 *	Routine :	name()
 *
 *	Description :	This is a feature of treewalk to give an identifier
 *			to the current item, to be used for later reference
 *			by the goto command.  If name is given an argument
 *			then the list of other defined names is searched
 *			for a match.  If one exists, then the current item
 *			will replace the old entry, otherwise a new entry in
 *			the table is created.  If name is given an argument
 *			of NULL, then the list of currently defined names
 *			is printed to the stdout in alphabetical order.  Also
 *			the type of item that the name references is printed
 *			alongside the name.
 *
 *	Arguments :	ident	- (IN) the label to give to the current item.
 *				  if ident == NULL, then print the list
 *		  		  of defined identifiers.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 name();

/*
 *	Routine : 	output_idl_instance()
 *
 *	Description :	The current IDL instance in memory will be saved to the' *			given filename, and control will be given back to the
 *			treewalk interpreter.  If no filename is given, then the *			default is the filename used to input the file.
 *
 *	Arguments :	filename	- (IN) the name of the file to be
 *					  saved.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void output_idl_instance();

/*
 *	Routine :	relabel()
 *
 *	Description :	The current item must be of type nodeDesc for this
 *			command to work.  This will replace the label of the
 *			current node with the new label specified.
 *
 *	Arguments :	newlabel		- (IN) the new label.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void relabel();

/*
 *	Routine :	search()
 *
 *	Description :	This command feature will search the entire IDL
 *			instance starting from the root node for occurrences
 *			of a specific value from a given attribute name.  The
 *			set of matches, if any, should be placed on the list
 *			stack so that they may be reviewed by the user at thier
 *			convienence.
 *
 *	Arguments :	attribute_name	     (IN) -- The name of the attribute
 *					     to search under each node.
 *			value		     (IN) -- The value to look for
 *					     if an attribute name is matched.
 *			interactive_mode     (IN) -- If the search is from
 *					     the input line, then YES.  If
 *					     the search in internal, then NO.
 *
 *	Return Value :	1 if a match is found, 0 otherwise.
 *
 *	Side Effects :	If any matches are found, they will be added to the
 *			list stack for further inspection by the user.
 */
extern int search();

/*
 *	Routine :	tail()
 *
 *	Description :	If the current item is a member of a set or sequence,
 *			then make the current item the last element of that
 *			set or sequence.  A record of the traversal must be
 *			maintained in the history of traversals.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 tail();

/*
 *	Routine :	up()
 *
 *	Description :	Make the current item, the last item that was visited.
 *			If the current item is at the root of the instance, 
 *			then this command should print an error message and
 *			ignore the directive.  Otherwise, remove the last
 *			element from the history of traversals, and make
 *			that item the current element.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 up();

/*
 *	Routine :	where()
 *
 *	Description :	This command will print the history of the traversals
 *			leading up to the current item.  No modification of
 *			the history of traversals is required.
 *
 *	Arguments :	None.
 *
 *	Return Value :	None.
 *
 *	Side Effects :	None.
 */
extern void	 where();

extern char	*myargv[];	/* These are the objects defined in */
extern int	 myargc;	/* ParseUserCommands to pass arguments to */
				/* the command interpreter. */
