/***********************************************************************\ 
*									* 
*   File: scorpion/src/treewalk/Execute.c 
*				 					* 
*   Copyright (C) 1991 Aaron Cavender
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *	Description :	This particular module takes a parsed command
 *			line, and executes it on the instance.
 *
 *	Functions :	Execute()
 *			right_num_of_args()
 *			numargs()
 */

/**** INCLUDE FILES ****/
#include <stdio.h>
#include <ctype.h>
#include "global.h"
#include "Execute.h"
#include "command.h"


/**** CODE ****/

int Execute()
{
	int	right_num_of_args();
	void 	version();
	int	arg1, arg2;

   /*
    *	This section will see if the given command has the right number
    *	of arguments needed to execute the command.
    */

    if ( ! right_num_of_args(*myargv[0]) )
	return 1;

   /*
    *	This test checks to see if the command requires numerical arguments
    *	and if so, then checks to see if they are numerical.
    */

    if ( ! numargs(*myargv[0]) )
	return 1;

   /*
    *	Now that the command is syntatically correct, then execute that
    *	particular directive.
    */

    switch ( *myargv[0] )
    {

	  case 'b':  /** back **/
	    move(1, -1);
	    break;

	    /** end of back command **/

	  case 'c':  /** change **/

	    if ( myargc == 0 )
	    {
		change(NULL, NULL);
		break;
	    }

	    if ( ( arg1 = atoi(myargv[1]) ) <= 0 )
	    {
		exception(OUT_OF_BOUNDS, "attribute", "node");
		break;
	    }

	    if ( myargc == 1 )
	    {
		change(arg1, NULL);
		break;
	    }

	    if ( ( arg2 = atoi(myargv[2]) ) <= 0 )
	    {
		exception(OUT_OF_BOUNDS, "element", "node");
		break;
	    }
	    if ( myargc == 2 )
	    {
		change(arg1, arg2);
		break;
	    }

	    /** end of change command **/

	  case 'd':  /** down **/
	    if ( myargc == 0 )
	    {
		down(NULL, NULL);
		break;
	    }
	    if ( ( arg1 = atoi(myargv[1]) ) <= 0 )
	    {
		exception(OUT_OF_BOUNDS, "attribute", "node");
		break;
	    }
	    if ( myargc == 1 )
	    {
		down(arg1, NULL);
		break;
	    }
	    if ( ( arg2 = atoi(myargv[2]) ) <= 0 )
	    {
		exception(OUT_OF_BOUNDS, "element", "node");
		break;
	    }
	    if ( myargc == 2 )
	    {
		down(arg1, arg2);
		break;
	    }

	    /** end of down command **/

	  case 'f':  /** forward **/
	    move(1, 1);
	    break;

	    /** end of forward command **/

	  case 'g':  /** goto **/
	    if ( myargc == 0 )
		go_to((char *)NULL);
	    else
	    	go_to(myargv[1]);
	    break;

	    /** end of goto command **/

	  case 'h':  /** head **/
	    head();
	    break;

	    /** end of head command **/

	  case 'i':  /** input **/
	    if ( myargc == 0 )
		input_new_instance((char *)NULL);
	    else
	    	input_new_instance(myargv[1]);
	    break;

	    /** end of input command **/

	case 'l':  /** list **/
	  if ( myargc == 0 )
	  {
		list(NULL, NULL);
		break;
	  }
	  if ( ( arg1 = atoi(myargv[1]) ) <= 0 )
	  {
		exception(OUT_OF_BOUNDS, "attribute", "node");
		return 1;
	  }
	  if ( myargc == 1 )
	  {	
		list(arg1, NULL);
		break;
	  }
	  if ( ( arg2 = atoi(myargv[2]) ) <= 0 )
	  {
		exception(OUT_OF_BOUNDS, "attribute", "node");
		return 1;
	  }
	  if ( myargc == 2 )
	  {
		list(arg1, arg2);
		break;
	  }

	  /** end of list command **/

	  case 'm':  /** move **/
	    if ( myargc == 0 )
		move(0, NULL);
	    else
	    	move(1, atoi(myargv[1]));
	    break;

	    /** end of move command **/

	  case 'n':  /** name **/
	    if ( myargc == 0 )
		name((char *)NULL);
	    else
		name(myargv[1]);
	    break;

  	    /** end of name command **/

	case 'o':  /** output **/
	  if ( myargc == 0 )
		output_idl_instance((char *)NULL);
	  else
		output_idl_instance(myargv[1]);
	  break;

	  /** end of output command **/

	case 'q':  /** quit **/
	  if ( Query_upon_change("quit") )
		return 0;
	  else
		break;

	  /** end of quit command **/

	 case 'r':
	   if ( myargc == 0 )
		relabel((char *)NULL);
	   else
	   	relabel(myargv[1]);
	   break;

	 case 's':	/** search **/
	   if ( myargc == 0 )
		(void)search((char *)NULL, (char *)NULL, YES);
	   else if ( myargc == 1 )
		(void)search(myargv[1], (char *)NULL, YES);
	   else
	   	(void)search(myargv[1], myargv[2], YES);
	   break;

	  case 't':  /** tail **/
	    tail();
	    break;

	    /** end of tail command **/

	  case 'u':  /** up **/
	    up();
	    break;

	    /** end of up command **/

	  case 'v':  /** version **/
	    version();
	    break;

	    /** end of version command **/

	  case 'w':  /** where **/
	    where();
	    break;

	    /** end of where command **/

	  case 'x':  /** exit **/
	    if ( Query_upon_change("exit") )
		return 0;
	    else
		break;

	    /** end of exit command **/

	  case '?':  /** help **/
	    help();
	    break;

	    /** end of help command **/

	   default:  /* those commands not defined yet */
		exception(NOT_HERE, myargv[0]);
		break;

    }  /* end switch */

    /*
     *		Clean up any extra storage from the argument list.
     */

/*    while ( myargc >= 0 )
	free(myargv[myargc--]);
*/

    return 1;

}  /* end of Execute() */


/*
 *	Routine :	right_num_of_args()
 *
 *	Description :	This routine is given the command, and from this
 *			information will determine if the command has
 *			the proper number of arguments.
 *
 *	Arguments :	cmd		- (IN) the command.
 *
 *	Return Value :	1 if the number of arguments is valid, 0 if it is
 *			not.
 *
 *	Side Effects :	None.
 */
int right_num_of_args(cmd)
char	cmd;
{

    switch ( cmd )
    {

	case '?': case 'b': case 'f': case 'h': case 'p': case 'q':
	case 't': case 'u': case 'v': case 'w': case 'x':
		if ( myargc != 0 )
		{
			exception(NUM_OF_ARGS, myargv[0]);
			return 0;
		}
		break;

	case 'n': case 'o': case 'r': case 'g': case 'i': case 'm':
		if ( myargc != 0 && myargc != 1 )
		{
			exception(NUM_OF_ARGS, myargv[0]);
			return 0;
		}
		break;

	case 'c': case 'd': case 'l': case 's':
		if ( myargc != 0 && myargc != 1 && myargc != 2 )
		{
			exception(NUM_OF_ARGS, myargv[0]);
			return 0;
		}
		break;

	default:
		exception(CRITICAL_ERROR);

    }

    return 1;

}  /* end of right_num_of_args() */


int numargs(command)
char command;
{

    switch ( command )
    {

	case 'm':
		if ( myargc == 1 && notnum(myargv[1]) )
		{
			exception(NONNUM_ARG, myargv[0]);
			return 0;
		}
		break;

	case 'c': case 'd': case 'l':
		if ( myargc == 0 )
			return 1;
		if ( myargc >= 1 )
			if ( notnum(myargv[1]) )
			{
				exception(NONNUM_ARG, myargv[0]);
				return 0;
			}
	        if ( myargc == 2 )
			if ( notnum(myargv[2]) )
			{
				exception(NONNUM_ARG, myargv[0]);
				return 0;
			}
		break;

	default:
         	return 1; 
  }

	return 1;

}  /* end of numargs() */


int notnum(str)
char	*str;
{
	int	i = 0;

	while ( str[i] )
	  if ( (i==0) && (str[i]=='-') )
	      i++;	/* allow negative numbers */
	  else if ( (i==0) && (str[i]=='+') )
	      i++;	/* allow positive numbers */
	  else if ( ! isdigit(str[i++]) )
			return 1;

	return 0;

}  /* end of notnum() */

