{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/trpr.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

program treepr(input,output);
(*****************************************************************************)
(*                                                                           *)
(*  trpr - driver for the treeprint program                                  *)
(*  switches available                                                       *)
(*     -t Produce text (ASCII) output                                        *)
(*     -d Produce device independent output (plot(3x))                       *)
(*     -P Produce PostScript output                                          *)
(*     -c run in compressed mode					     *)
(*     -w lwidth set the output page width to lwidth                         *)
(*     -h lheight set the output page height to lheight                      *)
(*     -Y Set the maximum value for both Xcoords and Ycoords in dvi output   *)
(*     -p paged output; tree is printed in topdown fashion                   *)
(*     -e expanded output; tree is printed across multiple pages             *)
(*                                                                           *)
(*  Function - This routine drives the treepr program.  It first reads all   *)
(*	switches and sets the appropriate variables.  It then calls the      *)
(*	five program modules to create the hardcopy trees.		     *)
(*                                                                           *)
(*  External Subroutines Called						     *)
(*	treein - reads in the input file and places in tree		     *)
(*	MakeTree- converts the IDLdata tree to the program data structure    *)
(*	GetBoxSizes - calculates the size of each node of the tree	     *)
(*	SetXcoords - calculates the x position of each node		     *)
(*	Printdriver - traverses the tree and calls the output routines	     *)
(*                                                                           *)
(*  PROGRAMMER - Dore Rosenblum                                              *)
(*  DATE       - 3/24/84                                                     *)
(*                                                                           *)
(*****************************************************************************)
const
#include "globalconst.h"
	condensed = true;     	(*condensed mode flag*)
	full = false;		(*full mode flag      *)
	textswitch = 't';       (*Produce text (ASCII) switch*)
	plotswitch = 'd';       (*Produce device independent switch(plot(3x)) *)
	PostScriptswitch = 'P'; (*PostScript switch value *)
	lineprinterswitch = 'l';(*lineprinter switch value *)
	compressswitch = 'c';   (*condensed mode switch value *)
	fullswitch = 'f';       (*full mode switch value *)
	maxXYswitch = 'Y';      (*Maximum X & Y coord switch value *)
	heightswitch = 'h';	(*height switch value *)
	widthswitch = 'w';	(*width switch value *)
	pagedswitch = 'p';      (*paged switch value *)
	expandedswitch = 'e';   (*expanded switch value *)
	defaultheight = 65;     (*default page length*)
	defaultwidth = 79;      (*default page width*)
	minimumheight = 24;
	minimumwidth = 20;
	deviceheight = 90;
	devicewidth = 121;
	maxint = 32767;
	plotformat = 1;
	PSformat = 2;

type
#include "globaltypes.h"
	string = packed array[1..10] of char;

var
	outputmode, widthflag, heightflag: boolean;	(*full or condensed mode *)
        outputstruct : (paged, expanded);
	outputdevice : devices; (*plot or lineprinter or PostScript*)
	switchoption : string;	
	validstruct: boolean;   (*flags valid structure after read *)
	genericdatastruct: nodeDesc;
				(*IDL generic data structure returned from *)
				(*treein function *)
	treestruct: TreeNodeList;
				(*Program tree structure *)
	switchnumber : integer;
	minx,maxx : integer;

#include "globals.h"
#include "treepr.i"
#include "MakeTree.h"
#include "GetBoxSizes.h"
#include "SetXcoords.h"
#include "Printdriver.h"
#include "TopDown.h"

function getswitchvalue(switch:string):integer;
(****************************************************************************)
(* function getswitchvalue                                                  *)
(*                                                                          *)
(* getswitchvalue returns the integer input of the height or width          *)
(*     depending on the switch value                                        *)
(*                                                                          *)
(*                                                                          *)
(*                                                                          *)
(* Programmer - Dore Rosenblum                                              *)
(* Date - 3/24/84                                                           *)
(****************************************************************************)
const
	radix = 10;			(*base 10 number system *)
var
	value,i,digitnumber,index: integer;
	number : string;
begin
	index := 1;
	while ((switch[index + 2] <= '9') and 
			(switch[index + 2] >= '0')) do begin
		number[index] := switch[index + 2];
		index := index + 1;
	end; (*while*)
					(*skip the switch value 'h' or 'w' *)
					(*and read the numberic values     *)
					(*after the switch	           *)
	
	value := ord(number[index - 1]) - ord('0');
					(*get the value of the first digit *)
	digitnumber := 10;
	for i := index - 2 downto 1 do begin
		value := value + (ord(number[i]) - ord('0')) * digitnumber;
		digitnumber := digitnumber * radix;
	end;
	getswitchvalue := value;
end;

begin (*treepr*)
	outputmode   := full;
	outputdevice := lineprinter;
	outputstruct := expanded;
	uwidth       := defaultwidth;
	uheight      := defaultheight;
	widthflag    := true;
	heightflag   := true;
	MaxXY        := 300;
	outputformat := plotformat;
	leftboundary := 0;
      
	switchnumber := 1;
	while switchnumber < argc do begin
		argv(switchnumber,switchoption);
					(* get command line argument 	 *)
		switchnumber := switchnumber + 1;

		if switchoption[2] = plotswitch then  begin
			if widthflag then uwidth := devicewidth;
			if heightflag then uheight := deviceheight;
			outputdevice := plot; {Enum type for Pascal code}
			outputformat := plotformat;{int for C code}
			end
					(* plot output switch		 *)

		else if switchoption[2] = PostScriptswitch then begin 
			if widthflag then uwidth := devicewidth;
			if heightflag then uheight := deviceheight;
			outputdevice := PostScript;{Enum type for Pascal code}
			outputformat := PSformat; {int for C code} 
			end
					(* PostScript output switch	 *)

		else if switchoption[2] = textswitch then 
			outputdevice := lineprinter{Enum type for Pascal code}
					(* text output switch	 *)

		else if switchoption[2] = compressswitch then 
			outputmode := condensed
					(* condensed mode switch	 *)

		else if switchoption[2] = fullswitch then 
			outputmode := full
					(* regular mode switch 		 *)

		else if switchoption[2] = maxXYswitch then
			MaxXY := getswitchvalue(switchoption)

		else if switchoption[2] = heightswitch then begin
			heightflag := false;
			uheight := getswitchvalue(switchoption);
			if (uheight < minimumheight ) then begin
				message('Height must be > ',minimumheight);
				uheight := defaultheight;
				end
			end
					(* page height switch		 *)

		else if switchoption[2] = widthswitch then begin
			widthflag := false;
			uwidth := getswitchvalue(switchoption);
			if (uwidth < minimumwidth ) then begin
				message('Width must be > ',minimumwidth);
				uwidth := defaultwidth;
				end
			end
					(* page width switch 		 *)
		else if switchoption[2] = pagedswitch then
			outputstruct := paged
		else if switchoption[2] = expandedswitch then
			outputstruct := expanded

		else message('Illegal switch');

	end; (*while*)

	rightboundary := MaxXY;

	genericdatastruct := treein(input,validstruct);
	if validstruct then begin
	    MakeTree(genericdatastruct,validstruct,treestruct);
	    if validstruct then begin
                GetBoxSizes (treestruct, outputmode) ;
  		if outputstruct = expanded then
			begin
                	SetXcoords (treestruct, maxint, minx, maxx) ;
	        	Printdriver(treestruct, minx, maxx, uwidth, uheight, 
					outputdevice,outputmode); 
			end
		else
			TopDown(treestruct,uwidth,uheight,outputdevice,
				outputmode);
		end;
	    end;
end. (*treepr*)
