{ treepr.p - IDL routines generated from treepr.IDL
  on September 21, 1984 (by hand) }
const
# include "globalconst.h"

type
# include "treepr.h"

RNodeType=record
	case Kind:NodeKind of
	KNodeDesc:(VnodeDesc:nodeDesc);
	KAttrDesc:(VattrDesc:attrDesc);
	KBooleanDesc:(VbooleanDesc:booleanDesc);
	KIntegerDesc:(VintegerDesc:integerDesc);
	KStringDesc:(VstringDesc:stringDesc);
	KRationalDesc:(VrationalDesc:rationalDesc);
	KSetDesc:(VsetDesc:setDesc);
	KSequenceDesc:(VsequenceDesc:sequenceDesc)
	end;
nodeType=^RNodeType;

# include "treepr.i"
# include "MsgChar.h"

# include "reader1.i"

procedure AttrStore;
	procedure IIDLVALUE(var Dest:IDLVALUE; Val:nodeType);
		begin
		new(Dest);
		case Val^.Kind of
		KNodeDesc:	begin
				Dest^.TypeOf := Val^.Kind;
				Dest^.VnodeDesc := Val^.VnodeDesc;
				end;
		KBooleanDesc:begin
				Dest^.TypeOf := Val^.Kind;
				Dest^.VbooleanDesc := Val^.VbooleanDesc;
				end;
		KIntegerDesc:begin
				Dest^.TypeOf := Val^.Kind;
				Dest^.VintegerDesc := Val^.VintegerDesc;
				end;
		KStringDesc:	begin
				Dest^.TypeOf := Val^.Kind;
				Dest^.VstringDesc := Val^.VstringDesc;
				end;
		KRationalDesc:begin
				Dest^.TypeOf := Val^.Kind;
				Dest^.VrationalDesc := Val^.VrationalDesc;
				end;
		KSetDesc:	begin
				Dest^.TypeOf := Val^.Kind;
				Dest^.VsetDesc := Val^.VsetDesc;
				end;
		KSequenceDesc:begin
				Dest^.TypeOf := Val^.Kind;
				Dest^.VsequenceDesc := Val^.VsequenceDesc;
				end
		end
		end;

	procedure GIDLVALUE(var Dest:IDLVALUE; Val:RepType);
		begin
		if Val=nil
			then IIDLVALUE(Dest,nil)
			else	begin
				IIDLVALUE(Dest,Val^.NodeField);
				DelRep(Val)
				end
		end;

	procedure ILIDLVALUE(var Dest:LIDLVALUE; Val:SeqType);
		begin
		if Val=nil
			then Dest := nil
			else	begin
				new(Dest);
				GIDLVALUE(Dest^.value,Val^.value);
				ILIDLVALUE(Dest^.next,Val^.next);
				end
		end;
	procedure GLIDLVALUE(var Dest:LIDLVALUE; Val:RepType);
		begin
		ILIDLVALUE(Dest,Val^.seqVal);
		DelRep(Val)
		end;

	procedure GAttrDesc(var Dest:attrDesc; Val:RepType);
		begin
		Dest := Val^.NodeField^.VattrDesc;
		DelRep(Val)
		end;
	procedure ILAttrDesc(var Dest:LAttrDesc; Val:SeqType);
		begin
		if Val=nil
			then Dest := nil
			else	begin
				new(Dest);
				GAttrDesc(Dest^.value,Val^.value);
				ILAttrDesc(Dest^.next,Val^.next);
				end
		end;
	procedure GLAttrDesc(var Dest:LAttrDesc; Val:RepType);
		begin
		ILAttrDesc(Dest,Val^.seqVal);
		DelRep(Val)
		end;

	begin
	if (Ref<>nil) and (Desc<>0) then begin
		case Ref^.Kind of
		KNodeDesc:
			case Desc of
			1:	GString(Ref^.VnodeDesc^.name,Val);
			2:	GLAttrDesc(Ref^.VnodeDesc^.attributes,Val);
			3:	GString(Ref^.VnodeDesc^.Flabel,Val)
			end;
		KAttrDesc:
			case Desc of
			1:	GString(Ref^.VattrDesc^.name,Val);
			2:	GIDLVALUE(Ref^.VattrDesc^.value,Val)
			end;
		KBooleanDesc:
			case Desc of
			1:	Ref^.VbooleanDesc^.value := Val^.boolVal
			end;
		KIntegerDesc:
			case Desc of
			1:	GInteger(Ref^.VintegerDesc^.value,Val);
			2:	GString(Ref^.VintegerDesc^.stringRep,Val)
			end;
		KStringDesc:
			case Desc of
			1:	GString(Ref^.VstringDesc^.value,Val)
			end;
		KRationalDesc:
			case Desc of
			1:	GRational(Ref^.VrationalDesc^.value,Val);
			2:	GString(Ref^.VrationalDesc^.stringRep,Val)
			end;
		KSetDesc:
			case Desc of
			1:	GLIDLVALUE(Ref^.VsetDesc^.value,Val)
			end;
		KSequenceDesc:
			case Desc of
			1:	GLIDLVALUE(Ref^.VsequenceDesc^.value,Val)
			end
		end
		end
	end;

function InRootSet(TheRoot:NodeKind):boolean;
begin
	InRootSet := TheRoot=KNodeDesc
end;

procedure FindNodeType;	(* args are OK, NodeName, K *)
	begin
	case NodeName^.value[1] of
	'n':	begin
		OK := true;
		K := KNodeDesc
		end;
	'a':	begin
		OK := true;
		K := KAttrDesc
		end;
	'b':	begin
		OK := true;
		K := KBooleanDesc
		end;
	'i':	begin
		OK := true;
		K := KIntegerDesc
		end;
	'r':	begin
		OK := true;
		K := KRationalDesc
		end;
	's':	case NodeName^.value[3] of
		'r':	begin
			OK := true;
			K := KStringDesc
			end;
		't':	begin
			OK := true;
			K := KSetDesc
			end;
		'q':	begin
			OK := true;
			K := KSequenceDesc
			end
		end
	end
	end;

procedure FindAttribute;	(* args: GoodPair, K, AttrName:Lexeme,
				   Value:RepType, var Attribute:AttrDesc *)
	begin
	case K of
	KNodeDesc:	case AttrName.Token^.value[1] of
			'n':	Attribute := 1;
			'a':	Attribute := 2;
			'l':	Attribute := 3
			end;
	KAttrDesc:	case AttrName.Token^.value[1] of
			'n':	Attribute := 1;
			'v':	Attribute := 2
			end;
	KBooleanDesc:case AttrName.Token^.value[1] of
			'v':	Attribute := 1
			end;
	KIntegerDesc:case AttrName.Token^.value[1] of
			'v':	Attribute := 1;
			's':	Attribute := 2
			end;
	KStringDesc:case AttrName.Token^.value[1] of
			'v':	Attribute := 1
			end;
	KRationalDesc:case AttrName.Token^.value[1] of
			'v':	Attribute := 1;
			's':	Attribute := 2
			end;
	KSetDesc:	case AttrName.Token^.value[1] of
			'v':	Attribute := 1
			end;
	KSequenceDesc:case AttrName.Token^.value[1] of
			'v':	Attribute := 1
			end
	end
	end;

function NodeAlloc(*K: NodeKind):nodeType*);
	var Ret : nodeType;
	begin
	new(Ret);
	Ret^.Kind := K;
	case K of
		KNodeDesc	:
			begin
			new(Ret^.VnodeDesc);
			Ret^.VnodeDesc^.Touched := false;
			Ret^.VnodeDesc^.Shared := false
			end;
		KAttrDesc	:
			begin
			new(Ret^.VattrDesc);
			Ret^.VattrDesc^.Touched := false;
			Ret^.VattrDesc^.Shared := false
			end;
		KBooleanDesc	:
			begin
			new(Ret^.VbooleanDesc);
			Ret^.VbooleanDesc^.Touched := false;
			Ret^.VbooleanDesc^.Shared := false
			end;
		KIntegerDesc	:
			begin
			new(Ret^.VintegerDesc);
			Ret^.VintegerDesc^.Touched := false;
			Ret^.VintegerDesc^.Shared := false
			end;
		KStringDesc	:
			begin
			new(Ret^.VstringDesc);
			Ret^.VstringDesc^.Touched := false;
			Ret^.VstringDesc^.Shared := false
			end;
		KRationalDesc:
			begin
			new(Ret^.VrationalDesc);
			Ret^.VrationalDesc^.Touched := false;
			Ret^.VrationalDesc^.Shared := false
			end;
		KSetDesc	:
			begin
			new(Ret^.VsetDesc);
			Ret^.VsetDesc^.Touched := false;
			Ret^.VsetDesc^.Shared := false
			end;
		KSequenceDesc:
			begin
			new(Ret^.VsequenceDesc);
			Ret^.VsequenceDesc^.Touched := false;
			Ret^.VsequenceDesc^.Shared := false
			end
		end;
	NodeAlloc := Ret
	end;

#include "reader2.i"

function treein(* (var Input:text; var OK:boolean):nodeDesc *);
var Root: nodeType;
begin
	Reader(Input,OK,Root);
	treein := Root^.VnodeDesc
end;
