{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/subtreefns.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const 
#include "globalconst.h"

type
#include "globaltypes.h"

#include "TopDown.h"

function GetNextSubtree;

(**************************************************************************)
(* function GetNextSubtree( var SubTrList: SubTreelist; var currlevel:    *)
(*	integer; lastlevel: integer): TreeNodePtr;        		  *)
(*									  *)
(* Input Parameters							  *)
(*	lastlevel	- last level of SubTrList that has had subtrees   *)
(*			  entered into its list 			  *)
(*									  *)
(* Input-Output Parameters						  *)
(*	SubTrList	- list of subtrees to be processed                *)
(*	currlevel	- level from which last subtree was taken	  *)
(*									  *)
(* Result 								  *)
(*	The next subtree root in a breadth-first traversal of the complete*)
(*   tree structure is returned as the value of GetNextSubtree.	 	  *)
(*   If there are no more subtree roots on SubTrList, nil is returned.    *) 
(*									  *)
(* Programmer:	Nancy Butler						  *)
(* Written:	4/5/85							  *)	
(**************************************************************************)

   begin
   while (SubTrList[currlevel] = nil) and (currlevel <= lastlevel) do
      currlevel:= currlevel +1;
   if currlevel > lastlevel then
      GetNextSubtree := nil
   else
      begin
      GetNextSubtree := SubTrList[currlevel]^.First;
      if SubTrList[currlevel]^.First = SubTrList[currlevel]^.Last then
	 SubTrList[currlevel]:=SubTrList[currlevel]^.Next
      else
	 SubTrList[currlevel]^.First:=SubTrList[currlevel]^.First^.Next;
      end;
   end;


procedure AddtoSublist;
	 
(**************************************************************************)
(* procedure AddtoSublist(firstn, lastn: TreeNodePtr; var SubTrlist:	  *)
(*	SubTreeList; var lastlevel: integer);  				  *)
(*									  *)
(* Input Parameters							  *)
(* 	firstn,lastn	- nodes firstn through lastn (left to right on a  *)
(*			  level) are subtree roots that will be processed *)
(*			  later.  Firstn and lastn are stored on the      *)
(*			  subtree list from which inbetween nodes are     *)
(*			  determined.					  *)
(* Input-Output Parameters						  *)
(*	SubTrlist	- list of subtree roots.  A list element for      *)
(*			  firstn-lastn is added. 			  *)
(*	lastlevel	- last level of SubTrlist to have subtrees entered*)
(*			- on it.  Updated if necessary. 		  *)
(*									  *)
(* Programmer:	Nancy Butler						  *)
(* Written:	4/5/85							  *)	
(**************************************************************************)

   var
      level,
      number: integer;
      cont:   boolean;
      newnode, 
      savenext, 
      temptr,
      oldtemp:  SubListNodePtr;
   begin
   cont:= true;
   level:= firstn^.Level;
   number:= firstn^.Subtrnum;
   temptr:= SubTrlist[level];
   oldtemp:= temptr;
   if SubTrlist[level] <> nil then
      begin
      if temptr^.First^.Subtrnum > number then 
         cont:=false;
      while cont do
         begin
	 if temptr^.Next = nil then
	    cont:= false;
         if temptr^.First^.Subtrnum < number then
            begin
	    oldtemp:=temptr;
	    temptr:= temptr^.Next;
	    end
         else
            cont:= false;
         end;
      end;
   if temptr = SubTrlist[level] then
      begin
      savenext:= SubTrlist[level];
      new(newnode);
      newnode^.First := firstn;
      newnode^.Last  := lastn;
      newnode^.Next  := savenext;
      SubTrlist[level]:= newnode;
      end
   else
      begin
      savenext:= oldtemp^.Next;
      new(newnode);
      newnode^.First := firstn;
      newnode^.Last  := lastn;
      newnode^.Next  := savenext;
      oldtemp^.Next  := newnode;
      end;
   if level > lastlevel then
      lastlevel := level;
   end;


