(************************************************************************)
(* File: reader2.i							*)
(*									*)
(*	This file is included in the reader and writer routines		*)
(*	produced by the IDL processor, and contains the main body of	*)
(*	the reader.							*)
(*									*)
(*									*)
(* Main body of the reader						*)
(*									*)
(************************************************************************)

begin
	ErrInit;
	LexInit(Input);
	NextLex;
	TempLex.Pos := Lex.Pos;
	LabelInit;
	NodeRef(CallOK, TempRoot);
	TempLex.Token := nil;
	OK := false;
	if CallOK then begin { check list of labelled values }
		if TempRoot^.Kind=RepLabelRef
			then TempLex.Token := TempRoot^.LabelField^.Name;
		if Lex.Kind = LexEOF
			then OK := true
			else OK := LValueList
		end; { check list of labelled values }
	if Lex.Kind <> LexEOF then Error(ErrEOFExpected,Lex.Pos);
	if CallOK then begin
		if TempLex.Token <> nil then TempRoot := LabelRef(TempLex);
		if not LabelFinish then OK := false;
		if TempRoot^.Kind = RepNode
			then begin { ensure correct root type }
				Root := TempRoot^.NodeField;
				if not InRootSet(Root^.Kind) then begin
					Error(ErrBadRootType,TempLex.Pos);
					OK := false
					end;
				end { ensure correct root type }
			else begin
				Root := nil; {root is unresolved forward ref}
				Error(ErrNoRoot,TempLex.Pos);
				OK := false;
				end;
		end { if CallOK }
	else
		if not LabelFinish then OK := false;
	RelLex(TempLex);
	ErrFinish;
end; (* Reader *)

