{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/printpage.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const 
#include "globalconst.h"

type
#include "globaltypes.h"

#include "TopDown.h"
#include "Printdriver.h"
#include "iArccross.h"
#include "convertcoords.h"
#include "plot.h"
#include "SubNumber.h"

var

#include "globals.h"
procedure PrintPage;
   
(*************************************************************************)
(* procedure PrintPage(Prlist:Printlist; vpagew, vpageh: integer;	 *)
(*	device: devices; cond: boolean; var pagenum: integer);		 *)
(*									 *)
(* Input parameters							 *)
(*	Prlist 	- list of subtrees to print on this page		 *)
(*	vpagew	- output page width reduced by 3 to leave room for set   *)
(*		  and sequence brackets					 *)
(*	vpageh	- output page height					 *)
(*	device 	- output device 					 *)
(*	cond    - output mode (true if condensed, false if full)	 *)
(*	pagenum	- page number of this page				 *)
(*									 *)
(* Purpose								 *)
(*	The subtrees in Prlist are printed on a page of output.		 *)
(*									 *)
(* Programmer:	Nancy Butler						 *)
(* Written: 	4/10/85							 *)
(*************************************************************************)

   var
	position, 		(* minimum X coordinate of a subtree on page*)
	trcount,		(* number of trees in a section		   *)
	section,		(* current section number		   *)
	totaltreesize,		(* sum of widths of all trees of a section *)
	betweentrees,		(* number of spaces to leave between trees *)
	topsect:    integer;    (* Y coordinate of root nodes of trees in  *)
				(*   current section			   *)
	nexttree: PrintListNodePtr; (* node of Prlist describing a subtree *)

    procedure lprintpn(pageh,pagew,pagenum: integer);

    (* Prints the page number for lineprinter output *)

    var i,j: integer;
    begin
    if (pagenum div 10) <> 0 then
       Parray[1,1]:=chr(pagenum div 10 + 48);
    Parray[1,2]:=chr(pagenum mod 10 + 48);
    for i:=1 to pageh do
	begin
	for j:=1 to pagew do
	   write(output,Parray[i,j]);
	writeln(output)
	end;
    write(chr(12))
    end;

    procedure iprintpn(pagenum:integer);

    (* Prints the page number for either plot or PostScript output *)

    var tempstring: strarray1;   (* strarray1 defined in plot.h *)
    begin
    moveDvi (leftboundary,iconvertY(-4));   (* leftboundary in iArccross.h *)
    if (pagenum div 10) <> 0 then
       tempstring[1]:=chr(pagenum div 10 + 48)
    else
       tempstring[1]:=' ';
    tempstring[2]:=chr(pagenum mod 10 + 48);
    ilabelDvi(tempstring,2);  		(* ilabel defined in plot.h *)
    end;

    procedure FindYcoords(curlevel:TreeNodeList; topsect: integer);

    (* Determines the Ycoordinates (in lineprinter units) of each level *)
    (* of the subtree to be printed. 					*)

    var pageht: integer;
    begin
    pageht:= topsect + 4;
    while curlevel <> nil do
	begin
	curlevel^.Ycoord:=pageht;
	pageht:=pageht + (curlevel^.MaxBoxHt * 2) + 4;
	curlevel:=curlevel^.Next;
	end;
    end;


   procedure PrintTree(Prnode: PrintListNodePtr; position: integer;
	cond: boolean; vpagew, vpageh: integer);

   (*  Draws the subtree referenced by Prnode. 'position' is the X coordinate *)
   (*  of the leftmost node of the subtree. 'cond' signals condensed mode if *)
   (*  true, full mode if false.  'vpagew' is the output page width reduced  *)
   (*  to allow room for set and sequence delimiter printing. 'vpageh' is    *)
   (*  the output page height.  The subtree identification number is         *)
   (*  printed.  Then, lDrawbox or iDrawbox are called on each               *)
   (*  node of the subtree to print the tree.				     *)

        var Boxptr: TreeNodePtr; (* node to draw 			*)
       	   level,		(* HeaderNode of node being drawn 	*)
	   prevlevel: TreeNodeList; (* HeaderNode of level above node   *)
	   posadj: integer;	(* adjustment to add to Xcoord of node to
				   get X coordinate on output page 	*)
	   lastl: boolean;	(* true if node is at leaf level of subtree*)

        procedure PrintRootNumb(root: TreeNodePtr; level: TreeNodeList; posadj:
	    integer);

	(* Prints the subtree number above the subtree.  The level number
	   and Subtrnum are printed.  If the root of the tree is part of
	   a sequence or set, the node's position number in the sequence or set
           is also printed.  The root number is determined and put into 
           character string format by procedure RootNumb.*) 

	    var x,y, i: integer;
		rootlabel: rString;
                istring:  strarray1;
	    begin
	    RootNumb(root,rootlabel);  
	    x:=root^.Xcoord + posadj + (root^.BoxWidth-rootlabel.length) div 2;
	    case device of
		lineprinter:  begin
		    y:=level^.Ycoord -2;
		    for i:=0 to rootlabel.length -1 do
			Parray[y,x+i]:= rootlabel.value[i+1];
		    Parray[y + 1,x + (rootlabel.length div 2)] := '|';
		    end;
		plot: begin
		    for i:= 1 to rootlabel.length do
			istring[i]:=rootlabel.value[i];
		    y:=iconvertY(level^.Ycoord-2);
		    moveDvi(iconvertX(x),y);
		    ilabelDvi(istring,rootlabel.length);
		    moveDvi(iconvertX(x) + rootlabel.length ,y);
		    contDvi(iconvertX(x) + rootlabel.length, 
			iconvertY(level^.Ycoord));
		    end;
		PostScript: begin
		    for i:= 1 to rootlabel.length do
			istring[i]:=rootlabel.value[i];
		    y:=iconvertY(level^.Ycoord-2);
		    moveDvi(iconvertX(x),y);
		    ilabelDvi(istring,rootlabel.length);
		    moveDvi(iconvertX(x) + rootlabel.length ,y);
		    contDvi(iconvertX(x) + rootlabel.length, 
			iconvertY(level^.Ycoord));
		    end;
		end;
	    end;

       (******  Body of PrintTree Procedure *****)

   	begin
	posadj:= position - Prnode^.Minpos;
	level := Prnode^.SubtrRoot;
	prevlevel := nil;
	Boxptr:= level^.First;
	PrintRootNumb(Boxptr,level,posadj);
	lastl:=false;
	while (level <> nil) do
	   begin
	   if level^.Next = nil then
		lastl:=true;
	   Boxptr:=level^.First;
           while Boxptr <> nil do
		begin
		case device of
		   lineprinter: lDrawBox(Boxptr,level,prevlevel,posadj, false,
			Boxptr^.Seqsetpos,cond,lastl,vpagew+3,vpageh);
		   plot: iDrawBox(Boxptr,level,prevlevel,posadj,false,
				Boxptr^.Seqsetpos,cond,lastl);
		   PostScript: iDrawBox(Boxptr,level,prevlevel,posadj,false,
				Boxptr^.Seqsetpos,cond,lastl);
		   end;
		if Boxptr = level^.Last then
		    Boxptr:=nil
		else
		    Boxptr:= Boxptr^.Next;
		end;
	   prevlevel:= level;
	   level := level^.Next;
	   end;
      end;


(*********************** Body of procedure PrintPage  *********************)

	begin
	section:= 1;
	topsect:= 1;
	pagenum:= pagenum + 1;
	if device = lineprinter then 
	   ArrayInitialize(vpageh,vpagew+3)
	else 
	   eraseDvi;
	while Prlist[section].Front <> nil do
	   begin
	   trcount:= 0;
	   nexttree:= Prlist[section].Front;
	   totaltreesize:= 0;
	   while nexttree <> nil do
		begin
		trcount:= trcount +1;
		totaltreesize:=totaltreesize + nexttree^.Maxpos - nexttree^.Minpos;
		nexttree:= nexttree^.Next;
		end;
	   betweentrees := (vpagew - totaltreesize) div (trcount + 1);
	   if betweentrees < 2 then
		position := 2
	   else
	    	position := betweentrees;
	   if (betweentrees < 5) and (trcount > 1) then
		begin
		betweentrees := (vpagew - totaltreesize) div (trcount -1);
		position := 2;
		end;
	   nexttree:= Prlist[section].Front;
	   while nexttree <> nil do
		begin
		FindYcoords(nexttree^.SubtrRoot, topsect);
		PrintTree(nexttree,position, cond, vpagew,vpageh);
		position:= position + nexttree^.Maxpos - nexttree^.Minpos +
				betweentrees;
		nexttree:=nexttree^.Next;
		end;
	   topsect:=topsect + Prlist[section].MaxHt + 2;
	   section:=section+1;
	   end;
	if device = lineprinter then
	    lprintpn(vpageh,vpagew+3,pagenum)
	else
	    begin 
	    iprintpn(pagenum);
	    closeplDvi;
	    end;
	end;


