{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/placeonpage.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const 
#include "globalconst.h"

type
#include "globaltypes.h"

#include "TopDown.h"
#include "SetXcoords.h"

procedure PlaceOnPage;

(***************************************************************************)
(* procedure PlaceOnPage(var Prlist: PrintList;tree:TreeNodeList; 	   *)
(*	vpagew, vpageh: integer;					   *)
(*	var lastlevel: TreeNodelist; var firstn, lastn:TreeNodePtr;        *)
(*	var region, treeh, sectw1,sectw2,secth1,secth2, trcount, section:  *)
(*      integer); external;						   *)
(*									   *)
(* Input Parameters							   *)
(*	tree 		- HeaderNode of subtree created by BuildSubtree    *)
(*	vpagew, vpageh	- output page's width and height		   *)
(*									   *)
(* Input-Output Parameters						   *)
(*	Prlist		- list of subtrees to print on the current page    *)
(*			  'tree' is added to the end of the list for       *)
(* 			  'section' or 'section + 1'.			   *)
(*	lastlevel	- last level of subtree				   *)
(*	firstn, lastn	- first and last sons of bottom level of subtree   *)
(*	region		- region number, 1 or 2.  May be changed from that *)
(*			  chosen by BuildSubtree if necessary.             *)
(*	treeh		- height of tree, if a level must be removed treeh *)
(*			  is reduced accordingly.			   *)
(*	sectw1, sectw2, - widths of region 1 and 2 - will change once      *)
(*                        a definite placement of the tree is made.        *)
(*      secth1, secth2  - height of region 1 and 2 - will change also.     *)
(*      trcount		- number of trees in the current section.          *)
(*	section		- number of the current horizontal page section.   *)
(*									   *)
(* Purpose and Algorithm						   *)
(*	PlaceOnPage calls SetXcoords on 'tree' to determine its true       *)
(*   width.  If the true width is less than the width of the input region  *)
(*   then the tree is placed in that region and the region height and width*)
(*   are updated.  If region1 = region2 and the true width is greater than *)
(*   the region width, levels of the subtree are removed until it will fit *)
(*   in region1.  If region1 is not the same as region2 and 'region' = 1   *)
(*   on input and the tree is too wide for region1, then region2 is tried. *)
(*   If the tree will not fit in region2 either, then levels of the tree   *)
(*   are removed until it will fit in region1 or region2.                  *)
(*      The tree is placed into the list of trees to print on the current  *)
(*   page, Prlist, at the appropriate section level.                       *)
(*									   *)
(* Programmer:	Nancy Butler						   *)
(* Written:	4/5/85							   *)
(***************************************************************************)


var
   maxpos, minpos,		(* returned by SetXcoords: min and max Xcoord*)
   lastlnum,                    (* level number of last level of subtree    *)
   treew 	: integer;      (* true tree width = maxpos - minpos	    *)
   nofit	: boolean;      (* loop control				    *)

procedure Removelevel;

(* Removes the bottom level of the subtree.  Treeh, lastn, firstn, lastlevel,
   lastlnum are updated.						    *)

   begin
   treeh := treeh - (lastlevel^.MaxBoxHt *2) - 4;
   lastn := lastlevel^.Last;
   firstn := lastlevel^.First;
   lastlevel := lastlevel^.Prev;
   lastlnum := lastlevel^.First^.Level;
   lastlevel^.Next := nil;
   end;

procedure AddtoR(reg:integer);

(* Adds the subtree to a region.The region number and region widths	*)
(* and heights are updated.  The tree is entered into Prlist at the     *)
(* end of the proper section's list of trees.				*)

   var pn: PrintListNodePtr;

   begin
   if reg = 1 then
      begin
      region := 1;
      sectw1:= sectw1 - (treew +5);
      if (secth1 - (treeh+2)) < secth2 then
	 secth2 := secth1 - (treeh+2);
      end
   else
      begin
      region:= 2;
      sectw1:= vpagew - (treew +5);
      secth1:= secth2;
      secth2:= secth2 - (treeh+2);
      end;
   new(pn);
   pn^.SubtrRoot :=tree;
   pn^.Maxpos    := maxpos;
   pn^.Minpos    := minpos;
   pn^.Next      := nil;
   if (reg = 1) and (Prlist[section].Front <> nil) then
      begin
      Prlist[section].Back^.Next:= pn;
      Prlist[section].Back:= pn;
      if Prlist[section].MaxHt < treeh then
	 Prlist[section].MaxHt := treeh;
      trcount:= trcount + 1;
      end
   else
      begin
      if reg = 2 then
	 section:= section + 1;
      Prlist[section].Front := pn;
      Prlist[section].Back  := pn;
      Prlist[section].MaxHt := treeh;
      trcount:= 1;
      end;
   end;

(********************  Body of procedure PlaceOnPage   *******************)

   begin
   lastlnum:= lastlevel^.First^.Level;
   SetXcoords(tree,lastlnum,minpos,maxpos);
   treew := maxpos - minpos;
   if (region = 1) and (sectw1 = sectw2) then
      if treew <= sectw1 then
	 AddtoR(1)
      else
	 begin
	 while treew > sectw1 do
	    begin
	    Removelevel;
	    SetXcoords(tree,lastlnum,minpos,maxpos);
	    treew := maxpos - minpos;
	    end;
	 AddtoR(1);
	 end
   else     (* region1 <> region2 or region 2 was chosen by Buildtree *)
      if treew <= sectw1 then (* since sectw2 >= sectw1, treew <= sectw2, too *)
	 AddtoR(region)
      else 
	 if (treew <= sectw2) and (treeh <= secth2) then
	    AddtoR(2)
	 else
	    begin
	    nofit:=true;
	    while nofit do
	       (* remove levels until tree fits in either region1 or 2 *)
	       begin
	       Removelevel;
	       SetXcoords(tree,lastlnum,minpos,maxpos);
	       treew := maxpos - minpos;
	       if treew <= sectw1 then
		  begin
		  AddtoR(1);
		  nofit:=false;
		  end
	       else
		  if (treew <= sectw2) and (treeh <= secth2) then
		     begin
		     AddtoR(2);
		     nofit:= false;
		     end;
	       end;
            end;
	end;


procedure DetermineNextRegion;

(***************************************************************************)
(* procedure DetermineNextRegion(rootnode: TreeNodePtr, vpagew, vpageh:    *)
(*	integer; var sectw1, sectw2, secth1, secth2,			   *)
(*	trcount, section: integer; var prpage: boolean); 		   *)
(*									   *)
(* Input Parameters							   *)
(*	rootnode	- root node of next subtree to be handled          *)
(*      vpagew, vpageh	- page width and height of output page		   *)
(*									   *)
(* Input-Output Parameters						   *)
(*	sectw1, sectw2  - width of regions 1 and 2.                        *)
(*	secth1, secth2  - height of regions 1 and 2.			   *)
(*	trcount		- number of trees in the current section           *)
(*	section		- number of the current section			   *)
(*									   *)
(* Purpose								   *)
(*	Decides whether to go to the next section of a page or to the      *)
(*   next page of output.  If the space left in the current section is     *)
(*   less than the average width of a tree in the section, region 1        *)
(*   becomes the next section on the page (and is = to region2).  If       *)
(*   the height of this new section is less than the average heights of    *)
(*   the other sections of the page, the current page is considered        *)
(*   complete and the next tree will be placed on a new page.		   *)
(*									   *)
(* Programmer:	Nancy Butler						   *)
(* Written:	4/5/85							   *)
(***************************************************************************)

 begin
 if rootnode = nil then
    prpage:=true
 else
   if (sectw1 < (vpagew / (trcount +1))) or 
      ((rootnode^.BoxWidth) > sectw1) or ((rootnode^.BoxHt*2+8) > secth1) then
      (*  Go to next section of this page of output  *)
      begin
      section := section +1;
      trcount := 0;
      sectw1  := vpagew;
      secth1  := secth2;
      if (secth1 < vpageh/section) or (rootnode^.BoxHt *2 + 8 > secth1) then
	 (*  Go to a new page of output  *)
	 begin
	 section := 1;
	 trcount := 0;
	 sectw1 := vpagew;
	 secth1 := vpageh;
	 sectw2 := vpagew;
	 secth2 := vpageh;
	 prpage := true;
	 end;
      end;
   end;
