/***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/lib.c 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* This file is meant to produce .ps file to drive postscript
   laser writers. It basically makes the plotformat calls postscript 
   procedures */
#include <stdio.h>
#define ABORT exit(99)
#define plotformat 1
#define PSformat 2


extern int outputformat,MaxXY,uheight,uwidth;

openplDvi()
{ 
float Max, height, width;
Max = (float) MaxXY;
height = (float) uheight;
width = (float) uwidth;
if(outputformat == PSformat)
  {
printf("%%!\n\
%%%%DocumentFonts:  Helvetica\n\
%%%%Title: pstek prolog file, version 1.0 @(#)pstek.pro	1.10\n\
%%%%Creator: Sundar Varadarajan and Greg Bollella\n\
%%%% Copyright (C) The University of North Carolina 1985\n\
%%%% No part of this may be sold or \
distributed without the prior written\n\
%%%%% permission of the Softlab Software Distribution Coordinator.\n\
%%%%CreationDate: 28 March 1988.\n\
%%%%For: treepr-output.\n\
%%%%BoundingBox: 3 5 131 263 %% In user coordinates.\n\
%%%%EndComments\n\n\
%% Font use courier since it is already in ROM - fastest.\n");

  printf("/Courier findfont %f scalefont setfont\n\n",
	      (Max*1.58)/width);
  printf("/NP	%% - -> - new page\n");
  printf("%% change default scale and orientation.\n");
  printf("{			%% Get the X and Y axes proper.\n");
  printf("\t%f %f scale\n",((Max*width )/19105.26316),
	                   ((Max*height)/11297.07113));
  printf("\t%f %f translate\n", (363000/(width*Max)),
                                (270000/(height*Max)));
  printf("%% clear the area and move to the origin.\n");
  printf("\tclippath 1 setgray fill\n");
  printf("\t0 setgray\n");
  printf("\t0 setlinewidth\n");
  printf("\t0 0 moveto\n");
  printf("\t} def\n");
  }
else if(outputformat == plotformat)
  openpl();
}

/* No need to do anything at the end of the plotformat */
closeplDvi()
{ 
if(outputformat == PSformat)
  printf("showpage\n");
else if(outputformat == plotformat)
  closepl();
}

linemodDvi(s)
char *s;
{
if(outputformat == PSformat)
  ;
else if(outputformat == plotformat)
  linemod(s);
}

spaceDvi(w,x,y,z)
int w,x,y,z;
{ 
if(outputformat == PSformat)
  ;
else if(outputformat == plotformat)
  space(w,x,y,z);
}

eraseDvi()
{ 
if(outputformat == PSformat)
  printf("NP\n");
else if(outputformat == plotformat)
  erase();
}

moveDvi(x,y)
int x,y;
{ 
if(outputformat == PSformat)
  printf("%d %d moveto\n",x,y);
else if(outputformat == plotformat)
  move(x,y);
}


contDvi(x,y)
int x,y;
{ 
if(outputformat == PSformat)
  printf("%d %d lineto stroke\n",x,y);
else if(outputformat == plotformat)
  cont(x,y);
}

ilabelDvi(s,length)
char *s;
int length;
{ 
*(s + length) = '\0';
if(outputformat == PSformat)
  {
  char str[256],*q,*p;
  p=s;q=str;
  while (*p != '\0')
    {
    switch (*p) 
      {
      case '(' : *q++ ='\\';*q++ = '(';break;
      case ')' : *q++ ='\\';*q++ = ')';break;
      case '\\' : *q++ ='\\';*q++ = '\\';break;
      case '\n' : *q++ ='\\';*q++ = 'n';break;
      case '\t' : *q++ ='\\';*q++ = 't';break;
      case '\b' : *q++ ='\\';*q++ = 'b';break;
      default : *q++ = *p;break;
      }
    p++;
    }
  *q++ = '\0';
  printf("(%s) show\n",str);
  }
else if(outputformat == plotformat)
  label(s);
}
