{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/lArccross.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const
#include "globalconst.h"

type
#include "globaltypes.h"

#include "Printdriver.h"
#include "lArccross.h"

procedure lArccross;

(*****************************************************************************)
(*									     *)
(* procedure lArccross							     *)
(*									     *)
(* This procedure is used to draw a connecting arc across a page when        *)
(* neither of the nodes it connects appear on that page.                     *)
(*									     *)
(* Input - a pointer to the father of the nodes, the level it is on, and     *)
(*  whether the arc comes from the right or left (not needed for lineprinter).*)
(*									     *)
(* Output - the arc drawn across the page.                                   *)
(*								  	     *)
(* Programmer - Steven Konstant						     *)
(* Written - 4/16/84						             *)
(*								             *)
(*****************************************************************************)


var i :integer;
begin
  for i:= 1 to pagewidth do
    Parray[prelevel^.Next^.Ycoord -2, i]:= '-';
  if prelevel^.Next^.Ycoord = 4 then
  begin
    i:=Source^.Xcoord + Source^.BoxWidth div 2 +posadj;
    Parray[1,i]:='|'
  end
end; (* of procedure *)
