{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/iDrawBox.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const

#include "globalconst.h"

type
 
#include "globaltypes.h"

#include "PadFind.h"
#include "Printdriver.h"
#include "plot.h"
#include "iArccross.h"
#include "convertcoords.h"
#include "SubNumber.h"

var

#include "globals.h"

procedure iDrawBox;
(**************************************************************************)
(*  									  *)
(* procedure iDrawBox(Boxptr:TreeNodePtr; level,prevlevel:TreeNodeList;   *)
(*			posadj:integer; top:boolean; posinseq: seqset;    *)
(*			condensed,lastlevel:boolean);			  *)
(*  									  *)
(* Input parameters                                                       *)
(*   node	- one node of the tree to print                           *)
(*   xpos	- x coordinate of the upper left corner of the node       *)
(*   ypos	- y coordinate of the upper left corner of the node       *)
(*   posadj	- offset on the page of the box				  *)
(*   top	- true if at top of page				  *)
(*   posinseq	- first is in set if first in a sequence or set		  *)
(*		  last is in set if last in a sequence or set		  *)
(*		  otherwise somewhere in the set or sequence		  *)
(*   condensed  - true if condensed mode				  *)
(*   lastlevel  - true if node is on last level of a subtree              *)
(*                                                                        *)
(* Function - This module prints out the part of a node and its box	  *)
(*		that fit on the page.  It also draws arcs to its parent   *)
(*		if the parent if above the page and draws arcs to the     *)
(*		nodes sons.						  *)
(*                                                                        *)
(* External Procedures called						  *)
(*   iDrawtoParArc - draws arc to parent				  *)
(*   iDrawPointerArcs - draws arc(s) to son and if the son is a member of *)
(*		a set or sequence to the members of the set or sequence   *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)

const
    indentconstant = 2;
type
    pagepos = (center,left,right);
var 
    DBG :integer;
    tmpx :integer;
    padding,paddingleft,paddingright:integer;
    tempstring:rString;
    nextlevely,middle,xintersect,rightxpos,firstx,xpos,ypos : integer;
    lwindow,rwindow:integer;
    i,index,indexcount,fieldindex : integer;
    str: rString;
    string, istr : strarray1;
    height,width : integer;
    tempPattr : PattrList;
    tempNPattr : NPattrList;
    offpage : pagepos;
    delimitchar : char;


procedure blankstring(var string:strarray1);
(**************************************************************************)
(*  									  *)
(* procedure blankstring						  *)
(*  									  *)
(* Input parameters                                                       *)
(*   string	- string to make blanks                                   *)
(*                                                                        *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)

const
	blank = ' ';

var
	i : integer;

begin
	for i:= 1 to 50 do
		string[i] := blank;

end; (*blankstring*)

procedure insertstring(var string:strarray1; var stringindex:integer; 
	var fieldindex:integer;str:rString;leftwindow,rightwindow:integer);
(**************************************************************************)
(*  									  *)
(* procedure insertstring						  *)
(*  									  *)
(* Input parameters                                                       *)
(*   string	- string in which to copy field for a node                *)
(*   stringindex- position in string to begin copying field               *)
(*   fieldindex - position in field are at                                *)
(*   str	- string to copy into the above string                    *)
(*   leftwindow - index of leftmost position in field to print            *)
(*   rightwindow- index of rightmost position in field to print           *)
(*                                                                        *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
var
	i : integer;

begin (*insertstring*)
	i := 1;
	while (fieldindex < leftwindow) and (i <= str.length) do begin
		fieldindex := fieldindex + 1;
		i := i + 1;
		end;
				(*skip to part of string on current page*)

	while (i <= str.length) and (fieldindex <= rightwindow) do begin	
		string[stringindex] := str.value[i];
		stringindex := stringindex + 1;
		i := i + 1;
		fieldindex := fieldindex + 1;
		end; (*while*)
				(*put in the current string until it ends *)
				(*or runs out of the right boundary *)
	while (i <= str.length) do begin
		i := i + 1;
		fieldindex := fieldindex + 1;
		end;

end; (*insertstring*)

procedure putindelimiter(xpos,ypos,height:integer;delimchar:char);
(**************************************************************************)
(*  									  *)
(* procedure putindelimiter			  			  *)
(*  									  *)
(* Input parameters                                                       *)
(*   xpos  	- x position of the place to put the delimiter  	  *)
(*   ypos  	- x position of the top of the box			  *)
(*   height	- number of fields in the box				  *)
(*   delimitchar- character to print to delimit the set or sequence       *)
(*                                                                        *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 4/9/84                                                 *)
(*                                                                        *)
(**************************************************************************)
var
    string:strarray1;
    i:integer;

begin (*putindelimiter*)
    blankstring(string);
    string[1] := delimchar;

    for i:= 1 to height do begin
	moveDvi(xpos,ypos - trunc(MaxXY/uheight+0.7) - iconvertYdist(i-1));
	ilabelDvi(string,1);
    end;
				(*put the set or sequence delimiter in *)
end; (*putindelimiter*)


begin (*iDrawBox *)
    DBG := 0;
    ypos := iconvertY(level^.Ycoord);
    xpos := iconvertX(Boxptr^.Xcoord + posadj);
                			(*calculate left x coordinate *)
    rightxpos := iconvertX(Boxptr^.Xcoord + Boxptr^.BoxWidth + posadj);
    (*message('L,R,X,W,P',xpos,rightxpos,Boxptr^.Xcoord,Boxptr^.BoxWidth,posadj);*)
                			(*calculate right x coordinate *)
    height := iconvertYdist(Boxptr^.BoxHt);
                			(*find height in plot coordinates *)

(*the first step is to put in arcs to pages above the current page *)
    middle := iconvertX(Boxptr^.Xcoord + Boxptr^.BoxWidth div 2 + posadj);
                  			(*find middle of box *)
    if ((xpos >= leftboundary) and (xpos <= rightboundary)) or
       ((middle >= leftboundary) and (middle < rightboundary)) then 
	if Boxptr^.ArcSource <> nil then  
	    iDrawtoParArc(top,middle,ypos,Boxptr,prevlevel,posadj,condensed);
                			(*draw the arc to the page boundary *)
					(*if the any part of the box is on  *)
					(*the current page		    *)

    (*crosses left page boundary*)
    if xpos < leftboundary then begin
	offpage := left;
	lwindow := ifindspace(xpos,leftboundary);
	rwindow := Boxptr^.BoxWidth;
        end	
    (*crosses right page boundary*)
    else if rightxpos >= rightboundary then begin
	offpage := right;
	lwindow := 1;
	rwindow := ifindspace(xpos,rightboundary) - 1;
        end
    (*completely one page *)
    else begin
	offpage := center;
	lwindow := 1;
	rwindow := Boxptr^.BoxWidth;
    end;
    (*put in the left delimiter for a sequence or set*)
    if (first in posinseq ) and (offpage <> left) then 
        if (Boxptr^.tag = SeqNode) or (Boxptr^.tag = SeqValue) then begin
	    delimitchar := '<';
	    putindelimiter(xpos-iconvertX(2),ypos,Boxptr^.BoxHt,delimitchar);
				(*put in the left delimiter of a sequence *)
 	end (*seqnode or seqvalue*)
	else begin
	    delimitchar := '{';
	    putindelimiter(xpos-iconvertX(2),ypos,Boxptr^.BoxHt,delimitchar);
				(*put in the left delimiter of a set *)
	end;

    (*put in the closing delimiter of a sequence or set *)
    if (last in posinseq) and (offpage <> right) then 
        if (Boxptr^.tag = SeqNode) or (Boxptr^.tag = SeqValue) then begin
	    delimitchar := '>';
	    putindelimiter(rightxpos+iconvertX(1),ypos,Boxptr^.BoxHt,delimitchar);
				(*put in the right delimiter of a sequence *)
	    end 
	else begin
	    delimitchar := '}';
	    putindelimiter(rightxpos+iconvertX(1),ypos,Boxptr^.BoxHt,delimitchar);
				(*put in the right delimiter of a set *)
	    end;

    if (offpage = center) or (offpage = right) then 
        firstx := xpos + indentconstant
    else (*offpage = left*)
        firstx := leftboundary;
   
    moveDvi(firstx,ypos - trunc(MaxXY/uheight+0.7));
	       			   (*move to position of first field string*) 
    blankstring(string);
    index := 1;
    fieldindex := 3;
    
    if Boxptr^.Duplicate = false then begin (*not a non-hierarchical arc*)
	if not (((Boxptr^.tag = SeqValue) or (Boxptr^.tag = SetValue)) and
			Boxptr^.Empty) then begin
            if (offpage = left) or (offpage = center) then begin
		moveDvi(rightxpos,ypos);
		contDvi(rightxpos,ypos-height);
				    (*draw side of box *)
		end;
		
	    if (offpage = right) or (offpage = center) then begin
		moveDvi(xpos,ypos);
		contDvi(xpos,ypos-height);
				    (*draw side of box *)
		end;
    
   	    for i := 0 to Boxptr^.BoxHt do 
	        if (offpage = center) then begin
		    moveDvi(xpos,ypos - iconvertYdist(i));
		    contDvi(rightxpos,ypos - iconvertYdist(i));
		    end (*for*)
		else if (offpage = right) then begin
		    moveDvi(xpos,ypos - iconvertYdist(i));
		    contDvi(rightboundary,ypos - iconvertYdist(i));
		    end (*for*)
		else begin
		    moveDvi(leftboundary,ypos - iconvertYdist(i));
		    contDvi(rightxpos,ypos - iconvertYdist(i));
		    end; (*for*)
				    (*draw dividers in the box *)
	    end; (*if not empty*)
	
	    
    	moveDvi(firstx,ypos - trunc(MaxXY/uheight+0.7));
    	if condensed = false then begin (*full mode*)
	    
	    if (Boxptr^.tag = RegularNode) or (Boxptr^.tag = SeqNode) or 
	    	    (Boxptr^.tag = SetNode) then begin
		insertstring(string,index,fieldindex,
				Boxptr^.Ntype,lwindow,rwindow);
					(*put node type field in string*)
		tempstring.value[1] := ':';
		tempstring.value[2] := '(';
		tempstring.length := 2;
		insertstring(string,index,fieldindex,tempstring,
							lwindow,rwindow);
		insertstring(string,index,fieldindex,
				Boxptr^.Nlabel,lwindow,rwindow);
					(*put node label field in string*)
		tempstring.value[1] := ')';
		tempstring.length := 1;
		insertstring(string,index,fieldindex,tempstring,
							lwindow,rwindow);
		ilabelDvi(string,index-1);
				        (*put in node type and label *)

		tempNPattr := Boxptr^.NPattribs;
		i := 1;
		while tempNPattr <> nil do begin
		    moveDvi(firstx,ypos - trunc(MaxXY/uheight+0.7) - iconvertYdist(i));
		    i := i + 1;
		    blankstring(string);
		    fieldindex := 3;
		    index := 1;
		    DBG := 1;
		    insertstring(string,index,fieldindex,
				tempNPattr^.Name,lwindow,rwindow);
					(*put NP attr name field in string*)
		    tempstring.value[1] := ':';
		    tempstring.length := 1;
		    insertstring(string,index,fieldindex,tempstring,
							lwindow,rwindow);
		    insertstring(string,index,fieldindex,
				tempNPattr^.StrRepVal,lwindow,rwindow);
					(*put NPattr value in string*)
		    DBG := 0;
		    ilabelDvi(string,index-1);
		    tempNPattr := tempNPattr^.Next;
		    end; (*while*)
				(*put in non-pointer attributes *)
		
		indexcount := 0;
		index := 1;
		fieldindex := 2;
		tempPattr := Boxptr^.Pattribs;
		if Boxptr^.PadPattrLine then
		     padding := PadFind(Boxptr)
		else
		     padding := 0;
				(*calculate padding per pointer node*)
		paddingright := padding div 2;
		paddingleft  := paddingright + padding mod 2;
				(*calculate padding for each side*)
		blankstring(string);
		for tmpx := 1 to 30 do
		     tempstring.value[tmpx] := ' ';

	        if lastlevel and (tempPattr <> nil) then
                    begin
		    middle:=0;
	 	    Charconvert(tempPattr^.Value^.Level,str,middle);	
		    for tmpx := 1 to str.length do
		       istr[tmpx]:=str.value[tmpx];
                    istr[str.length +1]:=':';
		    if (xpos - iconvertX(str.length -1)) < 1 then
			middle:=1
		    else middle:= xpos - iconvertX(str.length -1);
		    moveDvi(middle, ypos - 
		       iconvertYdist(Boxptr^.BoxHt) - (trunc(MaxXY/uheight+0.7)*2));
		    ilabelDvi(istr,str.length+1);
                    end;

		while tempPattr <> nil do begin
		     tempstring.length := paddingleft + 1;
		     insertstring(string,index,fieldindex,
				tempstring,lwindow,rwindow);
		     
		     insertstring(string,index,fieldindex,
				tempPattr^.Name,lwindow,rwindow);
					(*put P attr name field in string*)
		     
		     tempstring.length := paddingright;
		     insertstring(string,index,fieldindex,
				tempstring,lwindow,rwindow);
			(*string now contains the P attribute name and padding*)
		     
		     middle := xpos + iconvertX(indexcount + 1 +
			          (fieldindex - indexcount) div 2); 
		     if ((middle >= leftboundary) and (middle <= rightboundary))
		       (*or ((xpos >= leftboundary) and (xpos <= rightboundary))*)
			then 
			if not(lastlevel) then
			    iDrawPointerArcs(middle, ypos -
			                iconvertYdist(Boxptr^.BoxHt),tempPattr,
			                Boxptr, level^.Next,posadj)
		    			(*put in arcs to sons	*)
                        else 
			    iDrawSubtrNum(middle, ypos -
			                iconvertYdist(Boxptr^.BoxHt),tempPattr);


		     if (tempPattr^.Next <> nil) then 
			  begin
			  tmpx := xpos + iconvertX(fieldindex - 2);
		          if (tmpx >= leftboundary) and (tmpx < rightboundary) then 
			      begin
			      moveDvi(tmpx,ypos-iconvertYdist(Boxptr^.BoxHt - 1));
			      contDvi(tmpx ,ypos - iconvertYdist(Boxptr^.BoxHt));
			      end; (*put in dividing line*)
			  end;
		   
		     indexcount := fieldindex; 
		     tempstring.length := 1;
		     insertstring(string,index,fieldindex,
				tempstring,lwindow,rwindow);
                      
		     tempPattr := tempPattr^.Next;
		    end; (*while *)

		if firstx > 0 then
		    firstx := firstx - 1;
		moveDvi(firstx,ypos - trunc(MaxXY/uheight+0.7) - 
			      iconvertYdist(Boxptr^.BoxHt - 1));
		ilabelDvi(string,index-1);
				        (*put in pointer field 	*)
		
		end (*if seqnode,regnode or setnode*)

	    else begin (*tag is a seqvalue or setvalue*)
		    insertstring(string,index,fieldindex,Boxptr^.StrRepVal,
					lwindow,rwindow);
		    ilabelDvi(string,index - 1);
		    end (*else seqvalue or setvalue*)

	   	end (*if not condensed node *) 
	    
	    else begin (*condensed node*)
	        if (Boxptr^.tag <> SeqValue) and (Boxptr^.tag <> SetValue) then 
                    insertstring(string,index,fieldindex,Boxptr^.Ntype,
				lwindow,rwindow)
	        else
		    insertstring(string,index,fieldindex,Boxptr^.StrRepVal,
				lwindow,rwindow);
		ilabelDvi(string,index);
		tempPattr := Boxptr^.Pattribs;
		middle := xpos + iconvertX(Boxptr^.BoxWidth div 2);
		if (middle >= leftboundary) and (middle < rightboundary)  
		or ((xpos >= leftboundary) and (xpos <= rightboundary))then
		  if not lastlevel then
		    while (tempPattr <> nil) do begin
		        iDrawPointerArcs(middle,ypos-height,tempPattr,Boxptr,
				level^.Next,posadj);
			tempPattr := tempPattr^.Next;
			end 
					(*draw all of the son's arcs*)
		   else
		     if tempPattr <> nil then
		         iDrawCondNum(middle, ypos-height,tempPattr,Boxptr);
	    	end (*if condensed*)

	    end (*if duplicate*)
	
	else begin (*duplicate node *)
	    moveDvi(firstx,ypos - trunc(MaxXY/uheight+0.7));
	    insertstring(string,index,fieldindex,Boxptr^.Nlabel,lwindow
				,rwindow);
	    tempstring.value[1] := '^';
	    tempstring.length := 1;
	    insertstring(string,index,fieldindex,tempstring,lwindow
				,rwindow);
	    ilabelDvi(string,index - 1);
	end;
end; (*iDrawbox*)


