{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/globaltypes.h 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

#include "treepr.h"   {type defns for the IDL data str -     }
                      {must be included everywhere because }
                      {the tree structure has a ptr of type}
                      {nodeDesc}   

TreeNodeList = ^HeaderNode ; {list of nodes at one level of the tree}
TreeNodePtr  = ^TreeNode   ; {A TreeNode represents one graphic "node"}

NPattrList   = ^NPattr     ; {"non-pointer" attributes of a tree node, i.e.,}
                               {attribs with values of type integer, rational,}
                               {boolean, string, or enumerated types}
PattrList    = ^Pattr      ; {"pointer" attributes of a tree node, i.e.,}
                               {attribs whose values are references to nodes,}
                               {sequences, or sets.}

BoxKind     = (RegularNode, SeqNode, SetNode, SeqValue, SetValue) ;
                  {SeqNode represents a sequence value that is a reference}
                  {to an IDL node;  SeqValue a simple sequence value - same}
                  {for sets}

Seqpos      = (first,last);  {Indicates a node is first or last in seq or set.}

seqset      = set of Seqpos; {A node or value's position in sequence or set.}

HeaderNode =
  record
    First    : TreeNodePtr  ; {first tree node at this level}
    Last     : TreeNodePtr  ; {last   "    "   "   "     "  }
    MaxBoxHt : integer      ; {max number of lines of text that will be}
                                {printed in any node at this level}
    Ycoord   : integer      ; {y-coordinate of tops of nodes at this level}
    Next     : TreeNodeList ; {header for next level}
    Prev     : TreeNodeList ; {header for previous level}
  end ;

TreeNode =
  record
    Duplicate : boolean     ; {true if this is a duplicate copy of a node}
                                {already in the tree, and not a distinct}
                                {node in the IDL structure}
    Next      : TreeNodePtr ; {next tree node at this level}
    ArcSource : TreeNodePtr ; {father}
    Xcoord    : integer     ; {x-coordinate of upper left corner of box}
    BoxHt     : integer     ; {# lines of text to be printed in this box}
    BoxWidth  : integer     ; {in characters, of the box to be printed;}
                                {includes a char for each vertical line}
    Level     : integer     ; {level of tree that node is on}
    Subtrnum  : integer     ; {number of son on its level, from left to right}
    SetSeqnum : integer     ; {number of node in sequence or set}
    Seqsetpos : seqset      ; {position: (first,last) of node in seq or set}

    case tag  : BoxKind of
       RegularNode, SeqNode, SetNode :
          ( idlRef       : nodeDesc   ; {corresponding node in the IDL}
                                          {data structure}
            Nlabel       : rString    ; {node label}
            Ntype        : rString    ; {node type}
            NPattribs    : NPattrList ; {this node's "non-pointer" attributes}
            Pattribs     : PattrList  ; {this node's "pointer" attributes}
            PadPattrLine : boolean )  ; {true if width required to display}
                                         {node's pointer attribs is less than}
                                         {width required to display whole node}
       SeqValue, SetValue :
          ( Empty     : boolean ;   {true => empty seq or set}
            StrRepVal : rString  )  {string repr'n of value, if not empty}
   end ; {of case and record}

NPattr =
  record
    Next      : NPattrList ;  {next non-pointer attribute of this node}
    Name      : rString    ;  {attribute name}
    StrRepVal : rString    ;  {string repr'n of attribute's value}
  end ;

Pattr =
  record
    Next    : PattrList   ;  {next pointer attribute of this node}
    Name    : rString     ;
    Value   : TreeNodePtr ;  {son}
  end ;

devices = (lineprinter,plot,PostScript);
