{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/dlDrawBox.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const

#include "globalconst.h"

type
 
#include "globaltypes.h"

#include "Printdriver.h"

#include "PadFind.h"

procedure lDrawBox;

(*****************************************************************************)
(*									     *)
(* procedure lDrawBox(Node:TreeNodePtr; level,prelevel:TreeNodeList;         *)
(*                   posadj:integer; top:boolean; posinseq:seqset;           *)
(*                   cond:boolean);					     *)
(*									     *)
(* This procedure is used to draw each of the nodes in the tree              *)
(*  along with the arcs between them. It is divided into three principal     *)
(*  sections. One for drawing nodes in condensed mode, one for drawing       *)
(*  nodes in full mode, and one for drawing in the arcs between nodes.       *)
(*  Arcs are drawn in the same fashion for both modes.                       *)
(*  									     *)
(* Input:  Node - A pointer to the node to be drawn.			     *)
(*	   level - A pointer to the level on which the node belongs.         *)
(*         prelevel - A pointer to the level of the node's parent.           *)
(*         posadj - The position adjustment to add to the X coordinate.      *)
(* 	   top - True if this node is on the top level of the page.          *)
(*	   posinseq - set of first, or last - to indicate if a node is the   *)
(*		first or last node in a sequence.			     *)
(*         cond - True if condensed mode has been chosen.                    *)
(*									     *)
(* Output: Changes are made in the Parray as the nodes and arcs are drawn.   *)
(*									     *)
(* Programmer: Steven Konstant						     *)
(* Written: 4/11/84							     *)
(*									     *)
(*****************************************************************************)

var  tempx,       (*used to manipulate the horizontal coordinates*)
     tempy,       (*used to manipulate the vertical coordinates  *)
     tempos,      (*used for arc drawing purposes                *)
     i,j,         (*used for looping purposes                    *)
     pad : integer; (*number of spaces to pad in the pointer fields*)

     NPtemptr : NPattrList; (*used for moving through non pointer fields*)
     Ptemptr  : PattrList;  (*used for moving through pointer fields    *)
     temptr   : TreeNodePtr;(*used for arc drawing purposes             *)
     onlyson  : boolean;    (*true if a node has no brothers            *)




procedure findbro(temptr:TreeNodePtr; var onlyson:boolean);

(*****************************************************************************)
(*     									     *)
(* procedure findbro      						     *)
(*								             *)
(* This procedure determines if a node's father points to any other nodes    *)
(*  either as a son or a member of a sequence or set. It is used to insure   *)
(*  that the arc from the father lines up correctly when there is only one   *)
(*  son which it points to. This is necessary because of roundoff error.     *)
(*									     *)
(* Input - a pointer to the node's father, and a boolean which is initially  *)
(*  false.								     *)
(* Output - the boolean is set to true if this is the only son of the node.  *)
(*									     *)
(* Programmer - Steven Konstant						     *)
(* Written - 4/25/84							     *)
(*									     *)
(*****************************************************************************)

begin
  if temptr^.Pattribs^.Next = nil then
    if temptr^.Pattribs^.Value^.Next = nil then
      onlyson := true
    else if temptr^.Pattribs^.Value^.Next^.ArcSource <> temptr then
      onlyson := true
    else onlyson := false
end;  (* of procedure findbro *)



begin (*main routine of procedure dBoxDraw*)

(* this section composes the box drawing routine for condensed mode *)
  if cond then
  begin

    (* if it's the first node in a set or sequence, put in the indicators *)
    if first in posinseq then
      if (Node^.tag = SeqNode) or (Node^.tag = SeqValue) then
      begin
        tempx:= Node^.Xcoord + posadj -1;
        if (tempx > 0) and (tempx <= pagewidth) then
	  for tempy:= level^.Ycoord to (level^.Ycoord +Node^.BoxHt *2 ) do 
          Parray[tempy, tempx] := '<'
      end
      else if (Node^.tag = SetNode) or (Node^.tag = SetValue) then
      begin
        tempx:= Node^.Xcoord + posadj -1;
        if (tempx > 0) and (tempx <= pagewidth) then
	  for tempy:= level^.Ycoord to (level^.Ycoord +Node^.BoxHt *2 ) do 
          Parray[tempy, tempx] := '{'
      end;
 
    (* if it's the last node in a set or sequence, put in the indicators *)
    if last in posinseq then
      if (Node^.tag = SeqNode) or (Node^.tag = SeqValue) then
      begin
        tempx:= Node^.Xcoord + posadj + Node^.BoxWidth;
        if (tempx > 0) and (tempx <= pagewidth) then
	  for tempy:= level^.Ycoord to (level^.Ycoord +Node^.BoxHt *2 ) do 
          Parray[tempy, tempx] := '>'
      end
      else if (Node^.tag = SetNode) or (Node^.tag = SetValue) then
      begin
        tempx:= Node^.Xcoord + posadj + Node^.BoxWidth;
        if (tempx > 0) and (tempx <= pagewidth) then
	  for tempy:= level^.Ycoord to (level^.Ycoord +Node^.BoxHt *2 ) do 
          Parray[tempy, tempx] := '}'
      end;


(* now check for a set or sequence value since these types of nodes are  *)
(* different than regular nodes.					 *)
    if (Node^.tag = SeqValue) or (Node^.tag = SetValue) then
      begin
        if Node^.Empty = false then
        begin (* SetValue or SeqValue is not empty *)
          tempx:= Node^.Xcoord + posadj;
          if (tempx >0) and (tempx <=pagewidth) then
            Parray[level^.Ycoord +1, tempx]:= '|';
  	  if (tempx + Node^.BoxWidth -1 >0) and
             (tempx + Node^.BoxWidth -1 <= pagewidth) then
             Parray[level^.Ycoord +1, tempx +Node^.BoxWidth -1]:= '|';
  	  for j:=0 to Node^.BoxWidth -1 do
            if (tempx +j >0) and (tempx + j<=pagewidth) then
	    begin
	      Parray[level^.Ycoord, tempx +j]:= '-';
	      Parray[level^.Ycoord +2, tempx +j]:= '-';
	    end;
  	  for j:= 1 to Node^.StrRepVal.length do
            if (tempx+j+1>0) and (tempx+j+1<=pagewidth) then
	      Parray[level^.Ycoord+1, tempx+j+1]:= Node^.StrRepVal.value[j]
        end
      end (* of if SeqValue or SetValue*)


(* if nonhierarchical arc, print the label and carat *)
    else if Node^.Duplicate then
    begin
      tempx:= Node^.Xcoord + posadj;
      for j:= 1 to Node^.Nlabel.length do
        if (tempx + j +1>0) and (tempx + j +1<= pagewidth) then
	  Parray[level^.Ycoord, tempx +j+1]:= Node^.Nlabel.value[j];
      if (tempx +j+2 >0) and (tempx +j+2 <=pagewidth) then
 	Parray[level^.Ycoord, tempx +j+2]:= '^'
    end


(* if not a nonhierarchical arc then draw box and label for regular node *)
    else begin
      tempx:= Node^.Xcoord +posadj;
      for j:=0 to Node^.BoxWidth -1 do
        if (tempx +j>0) and (tempx + j<=pagewidth) then
        begin
          Parray[level^.Ycoord, tempx +j]:= '-';
          Parray[level^.Ycoord + 2, tempx +j]:= '-';
 	end;
      if (tempx >0) and (tempx <=pagewidth) then
   	Parray[level^.Ycoord +1, tempx]:= '|';
      if (tempx +Node^.BoxWidth -1>0) and (tempx +Node^.BoxWidth -1<=pagewidth) 
        then
   	Parray[level^.Ycoord +1, tempx + Node^.BoxWidth -1]:= '|';
	  
      tempx:= Node^.Xcoord + posadj;
      for j:= 1 to Node^.Nlabel.length do
	if (tempx +j+1 >0) and (tempx +j+1 <=pagewidth) then
	  Parray[level^.Ycoord +1, tempx +j+1]:= Node^.Nlabel.value[j]
    end;

    (* now put in the outgoing arc stubs *)
    if (Node^.Pattribs <>nil) and (level^.Ycoord +3 <=pagelength) then
    begin
      tempx:=(Node^.BoxWidth-1)div 2 + Node^.Xcoord + posadj;
      if (tempx >0) and (tempx <=pagewidth) then
 	Parray[level^.Ycoord +3, tempx]:= '|'
    end;

  end (*of if condensed mode*)


  (* this section draws the node if the full print mode has been chosen *)
  else begin

    (* if it's the first node in a set or sequence, put in the indicators *)
    if first in posinseq then
      if (Node^.tag = SeqNode) or (Node^.tag = SeqValue) then
      begin
	tempx:= Node^.Xcoord +posadj -1;
	if (tempx >0) and (tempx <= pagewidth) then
	  for tempy:= level^.Ycoord to (level^.Ycoord +Node^.BoxHt *2 ) do 
	    Parray[tempy, tempx]:= '<'
      end

      else if (Node^.tag = SetNode) or (Node^.tag = SetValue) then
      begin
	tempx:= Node^.Xcoord +posadj -1;
	if (tempx >0) and (tempx <= pagewidth) then
	  for tempy:= level^.Ycoord to (level^.Ycoord +Node^.BoxHt *2 ) do
	    Parray[tempy, tempx]:= '{'
      end;

    (* if it's the last node in a set or sequence, put in the indicators *)
    if last in posinseq then
      if (Node^.tag = SeqNode) or (Node^.tag = SeqValue) then
      begin
	tempx:= Node^.Xcoord +posadj + Node^.BoxWidth;
	if (tempx >0) and (tempx <= pagewidth) then
	  for tempy:= level^.Ycoord to (level^.Ycoord +Node^.BoxHt *2 ) do
	    Parray[tempy, tempx]:= '>'
      end

      else if (Node^.tag = SetNode) or (Node^.tag = SetValue) then
      begin
	tempx:= Node^.Xcoord +posadj + Node^.BoxWidth;
	if (tempx >0) and (tempx <= pagewidth) then
	  for tempy:= level^.Ycoord to (level^.Ycoord +Node^.BoxHt *2 ) do
	    Parray[tempy, tempx]:= '}'
      end;


(* now check for a set or sequence value since they are different than        *)
(* regular nodes and must be handled accordingly.                             *)
    if (Node^.tag = SeqValue) or (Node^.tag = SetValue) then
      begin
        if Node^.Empty = false then
        begin (* SetValue or SeqValue is not empty *)
          tempx:= Node^.Xcoord + posadj;
	  if (tempx >0) and (tempx <=pagewidth) then
	    Parray[level^.Ycoord +1, tempx]:= '|';
	  if (tempx + Node^.BoxWidth -1 >0) and
             (tempx + Node^.BoxWidth -1 <= pagewidth) then
             Parray[level^.Ycoord +1, tempx +Node^.BoxWidth -1]:= '|';
	  for j:=0 to Node^.BoxWidth -1 do
            if (tempx +j >0) and (tempx + j<=pagewidth) then
	    begin
	      Parray[level^.Ycoord, tempx +j]:= '-';
	      Parray[level^.Ycoord +2, tempx +j]:= '-';
	    end;
	    for j:= 1 to Node^.StrRepVal.length do
              if (tempx+j+1>0) and (tempx+j+1<=pagewidth) then
	        Parray[level^.Ycoord+1, tempx+j+1]:= Node^.StrRepVal.value[j]
        end
      end (* of if SeqValue or SetValue*)


(* if nonhierarchical arc, print the label and carat *)
    else if Node^.Duplicate then
    begin
      tempx:= Node^.Xcoord + posadj;
      for j:= 1 to Node^.Nlabel.length do
        if (tempx + j +1>0) and (tempx + j +1<= pagewidth) then
	  Parray[level^.Ycoord, tempx +j+1]:= Node^.Nlabel.value[j];
      if (tempx +j+2 >0) and (tempx +j+2 <=pagewidth) then
 	Parray[level^.Ycoord, tempx +j+2]:= '^'
    end

    else begin (* draw box for full mode, regular box*)

(*Now draw all the horizontal lines of the box*)
      tempx:= Node^.Xcoord + posadj;
      for tempy:= 0 to Node^.BoxHt do
        for j:= 0 to Node^.BoxWidth -1 do
	  if (tempx +j>0) and (tempx +j<=pagewidth) then
            Parray[level^.Ycoord+(2*tempy), tempx +j]:='-';

(*Set the Nptemptr and Ptemptr variables for use *)
      NPtemptr:= Node^.NPattribs;
      Ptemptr := Node^.Pattribs;

(*Print in the first box, the node type and the label*)
      tempy:= level^.Ycoord + 1;
      tempx:= Node^.Xcoord + posadj;
      if (tempx >0) and (tempx <=pagewidth) then
        Parray[tempy, tempx] :='|';
      if (tempx + Node^.BoxWidth -1 >0) and
         (tempx + Node^.BoxWidth -1 <= pagewidth) then
        Parray[tempy, tempx+ Node^.BoxWidth-1] := '|';
      j:= tempx+ 1;
      for i:= 1 to Node^.Ntype.length do
        if (i+j >0) and (i+j <=pagewidth) then
          Parray[tempy, i+j]:= Node^.Ntype.value[i];
      i:=Node^.Ntype.length;
      if (i+j +2 >0) and (i+j+2 <= pagewidth) then
        Parray[tempy,i+j+2]:='(';
      j:=j+i+2; (*advance to current position*)
      for i:= 1 to Node^.Nlabel.length do
        if (i+j >0) and (i+j <= pagewidth) then
          Parray[tempy, i+j]:= Node^.Nlabel.value[i];
      i:=Node^.Nlabel.length;
      if (i+j+1>0) and (i+j+1 <=pagewidth) then
        Parray[tempy, i+j+1]:= ')';


(*Now fill in the nonpointer attributes *)
      while NPtemptr <> nil do
      begin
        tempy:= tempy + 2; (*move up two since lines take up a space*)
        tempx:= Node^.Xcoord + posadj;
 	if (tempx >0) and (tempx<= pagewidth) then
          Parray[tempy, tempx]:= '|'; (*put in ends of boxes*)
	if (tempx + Node^.BoxWidth -1 >0) and
	   (tempx + Node^.BoxWidth -1 <= pagewidth) then
          Parray[tempy, tempx+ Node^.BoxWidth -1]:= '|';
        j:= tempx+ 1;
        for i:= 1 to NPtemptr^.Name.length do
	  if (j+i>0) and (j+i<=pagewidth) then
            Parray[tempy,j+i]:= NPtemptr^.Name.value[i];
        i:=NPtemptr^.Name.length;
	if (j+i+1>0) and (j+i+1<=pagewidth) then
          Parray[tempy, j+i+1]:= ':';
        j:= j+i+2;
        for i:= 1 to NPtemptr^.StrRepVal.length do
	  if (i+j>0) and (i+j<=pagewidth) then
            Parray[tempy, i+j]:= NPtemptr^.StrRepVal.value[i];
        NPtemptr:= NPtemptr^.Next
      end; (*while NPtemptr <> nil*)


(*Now put in the pointer attributes*)
      if Ptemptr <> nil then begin
        if Node^.PadPattrLine = true then
 	  pad:= PadFind(Node)
	else pad:=0;
        tempx:=Node^.Xcoord +posadj;
        tempy:= tempy + 2;
        while Ptemptr <> nil do
        begin
	  if (tempx>0) and (tempx<=pagewidth) then
            Parray[tempy,tempx]:= '|';
	  tempx:=tempx +1;
          for i:= 1 to Ptemptr^.Name.length do
	    if (tempx +i >0) and (tempx +i <=pagewidth) then
              Parray[tempy, tempx+i]:=Ptemptr^.Name.value[i];
          i:=Ptemptr^.Name.length;
          tempx:= tempx+i+2+pad;
          Ptemptr:= Ptemptr^.Next
        end; (* while Ptemptr <> nil*)
	tempx := Node^.Xcoord + posadj + Node^.BoxWidth -1;
        if (tempx>0) and (tempx <=pagewidth) then
          Parray[tempy, tempx]:= '|';

        (*now draw outgoing arc *)
        tempx := Node^.Xcoord + posadj + (Node^.BoxWidth -1)div 2;
        if (tempx>0) and (tempx<=pagewidth) then
        begin
          if level^.Next^.Ycoord = 0 then
            for tempy := tempy + 2 to pagelength do
              Parray[tempy, tempx]:= '|'
          else for tempy:=tempy+2 to level^.Ycoord + level^.MaxBoxHt *2 +1 do
	    if tempy <= pagelength then
	      Parray[tempy, tempx]:= '|';
        end;


      end; (*if Ptemptr <>nil*)

    end; (*of draw box for full mode*)
  end; (* if full mode *)


(* Now for either mode, put in the incoming arc stubs and draw arcs *)

    (* put in the incoming arc stubs *)
    if Node^.ArcSource <> nil then
    begin
      temptr:= Node^.ArcSource;
      tempos:= temptr^.Xcoord + posadj +(temptr^.BoxWidth -1)div 2;
      if top = true then
      begin
        if (tempos >0) and (tempos <= pagewidth) then
          Parray[1,tempos]:= '|'
      end;

      onlyson:=false;
      findbro(temptr,onlyson);
      if onlyson = true then (* only son *)
      begin
        if (tempos>0) and (tempos <=pagewidth) then
        begin
          Parray[level^.Ycoord -2,tempos]:='|';
          Parray[level^.Ycoord -1,tempos]:='|';
        end
      end

      else begin
        tempx:=(Node^.BoxWidth-1)div 2 + Node^.Xcoord + posadj;
        if (tempx >0) and (tempx <=pagewidth) then
       	  Parray[level^.Ycoord -1, tempx]:= '|';

     (* Put in arcs to brothers on the right*)
        temptr:= Node^.Next;
        tempos:= temptr^.Xcoord + posadj + (temptr^.BoxWidth -1)div 2;
        if Node^.ArcSource = temptr^.ArcSource then
          if tempos>pagewidth then
          for j:= tempx to pagewidth do 
          begin
            if (j>0) and (j<=pagewidth) then
              Parray[level^.Ycoord -2,j]:= '-'
          end
        else for j:= tempx to tempos do
        begin
          if (j>0) and (j<=pagewidth) then
            Parray[level^.Ycoord -2,j]:= '-'
        end;


     (* Put in arcs to brothers on the left *)
        temptr:= Node^.ArcSource^.Pattribs^.Value;
        tempos:= temptr^.Xcoord + posadj + (temptr^.BoxWidth -1)div 2;
        if (tempos = tempx) and (Node^.ArcSource <> Node^.Next^.ArcSource) then
        begin
          if (tempx >0) and (tempx<=pagewidth) then
            Parray[level^.Ycoord-2, tempx]:= '|'
        end
        else for j:= tempos to tempx do
        begin
          if (j>0) and (j<=pagewidth) then
            Parray[level^.Ycoord -2,j]:= '-'
        end
        end
      end;

  (*draw arcs across page if sons are off the page *)
    if Node^.Pattribs <> nil then
    begin
      Ptemptr:= Node^.Pattribs;
      temptr:= Ptemptr^.Value;
      tempx:= temptr^.Xcoord +(temptr^.BoxWidth -1)div 2 + posadj;
      if tempx < 1 then
      begin
        while Ptemptr^.Next <> nil do
          Ptemptr:= Ptemptr^.Next;
        temptr:= Ptemptr^.Value;
        tempx:= temptr^.Xcoord +(temptr^.BoxWidth -1)div 2 + posadj;
        if tempx > pagewidth then
          for j:= 1 to pagewidth do
            Parray[level^.Next^.Ycoord -2, j]:= '-'
      end
    end
end; (*of procedure lDrawBox*)


procedure ArrayInitialize;

(*****************************************************************************)
(*									     *)
(* procedure ArrayInitialize                                                 *)
(*									     *)
(* This procedure initializes the array used for storing a page to           *)
(*   be all blanks.        						     *)
(*									     *)
(* Programmer : Steven Konstant						     *)
(* Written : 3/14/84							     *)
(*									     *)
(*****************************************************************************)

var i,j :integer;

begin
   for i:= 1 to pagelength do
     for j:= 1 to pagewidth do
       Parray[i,j] := ' '
end; (*of procedure ArrayInitialize*)



procedure Printout;

(*****************************************************************************)
(*									     *)
(* procedure Printout(pagelength,pagewidth,row,column:integer)               *)
(*									     *)
(* This procedure prints out the array holding a page of storage.	     *)
(* First a scan of the array is done until a nonblank character is found.    *)
(* If no nonblanks are found, then the page is not printed.                  *)
(* Printout also inserts the row and column numbers for cutting 	     *)
(* and pasting purposes.					             *)
(* Additionally, a dot is put in each corner where there isn't     	     *)
(* already a character. This is to facilitate the cutting of pages.          *)
(*									     *)
(* Input - the length of the page, the width of the page, and the row and    *)
(* column indicating where the page goes in the overall printout.            *)
(*								             *)
(* Output - if the page is nonblank, it is sent to standard out.             *)
(*									     *)
(* Programmer : Steven Konstant						     *)
(* Written : 3/14/84							     *)
(*									     *)
(*****************************************************************************)

var i,j : integer;

begin
  (* first scan the page to see if there are any nonblank characters.        *)
  (* this loop stops as soon as a nonblank is found.			     *)
  i:=1;
  j:=1;
  while (Parray[i,j] = ' ') and (i<pagelength) do
  begin
    i:=i+1;
    j:= 1;
    while (Parray[i,j]=' ') and (j<pagewidth) do
    j:= j+1;
  end;


  if (i<pagelength) or (j<pagewidth) then
  (* if the page is not blank, then put in the row and column numbers        *)
  (* along with the page boundary indicators, and print the page.            *)
  begin
    Parray[1,1]:= chr(row div 10 + 48);
    Parray[1,2]:= chr(row mod 10 + 48);
    Parray[1,3]:= ':';
    Parray[1,4]:= chr(column div 10 + 48);
    Parray[1,5]:= chr(column mod 10 + 48);
    if Parray[1,pagewidth] =' ' then Parray[1,pagewidth]:='.'; 
    if Parray[pagelength,1] =' ' then Parray[pagelength,1]:='.'; 
    if Parray[pagelength,pagewidth] =' ' then Parray[pagelength,pagewidth]:='.'; 
    for i:= 1 to pagelength do
    begin
      for j:= 1 to pagewidth do
        write(output, Parray[i,j]);
      writeln(output)
    end;
    write(chr(12))
  end
end; (*of procedure Printout*)

