{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/diArccross.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

(**************************************************************************)
(*  									  *)
(* This file of routines draws the arcs on the imagen.  The procedures    *)
(* that are called from external routines are the following:		  *)
(*                                                                        *)
(*   iArccross - puts in arcs which may cross corners			  *)
(*   iDrawPointerArcs - puts in arcs from a node to its sons  		  *)
(*   iDrawtoParArc - puts in a arc from a node to its parent 		  *)
(*   iPrintHeader - prints the row and column number and cutting edges    *)
(*                                                                        *)
(**************************************************************************)
const

#include "globalconst.h"

type
 
#include "globaltypes.h"

#include "PadFind.h"
#include "iArccross.h"
#include "convertcoords.h"
#include "plot.h"


function findparentpos(Boxptr:TreeNodePtr):integer;
(**************************************************************************)
(* function findparentpos;						  *)
(*  									  *)
(* Input parameters                                                       *)
(*    Boxptr - calculate the position of the pointer to this node	  *)
(*                                                                        *)
(* Function	- This function finds the position of the parent in its   *)
(*		  box.  It is necessary for drawing arcs to a parent      *)
(*									  *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
var
    pattr : PattrList;
    nexttmp,tmp : TreeNodePtr;
    found : boolean;
    padding :integer;
    cnt :integer;
begin
    pattr := Boxptr^.ArcSource^.Pattribs;
    padding := PadFind(Boxptr^.ArcSource);
			(*get padding per pointer *)
    cnt := 0;
    if Boxptr^.tag = RegularNode then 
	while pattr^.Value <> Boxptr do begin
		cnt := cnt + pattr^.Name.length + padding + 3;
		pattr:= pattr^.Next
		end
			(*if a regular node then scan for node ignoring *)
			(*sequences and sets between 			*)
    else begin
    	found := false; 
	while not found do begin
		tmp := pattr^.Value;
		nexttmp := pattr^.Next^.Value;
		while (tmp <> Boxptr) and (tmp <> nexttmp) do 
			tmp := tmp^.Next;
		
		if (tmp = Boxptr) then 
			found := true;
		if (tmp = nexttmp) then begin
			cnt := cnt + pattr^.Name.length + padding + 3;
			pattr:= pattr^.Next;
			end
		end;
	end;
			(*search for the parent through all sets and   	*)
			(*sequences					*)

    findparentpos := cnt + 1 + (pattr^.Name.length + padding + 3) div 2;
end;


procedure clip(var x1,y1,x2,y2:integer;var onpage:boolean);  
(**************************************************************************)
(*  									  *)
(* x1,x2	- coordinates of first point				  *)
(* y1,y2	- coordinates of second point				  *)
(* onpage	- returns true if onpage false otherwise		  *)
(*									  *)
(* Function 	- clip clips the line between the two enpoints to the     *)
(*		  current page.  It has been modified slightly from       *)
(*		  from Newell/Sproull, Principles of Interactive          *)
(*		  Graphics, page 66-67     				  *)
(*		  The algorithm in the book to return a boolean when      *)
(*		  some part of the line is on the current page		  *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)

type
    edge = (left,right,bottom,top);
    outcode = set of edge;

var 
    c,c1,c2 : outcode;
    x,y:real;




procedure code(x,y:integer;var c:outcode);
(**************************************************************************)
(*									  *)
(* x,y 	- coordinate							  *)
(* c   	- code to tell where the coordinate lies			  *)
(*									  *)
(* Function 	- code returns the code of where the coordinate lies with *)
(*		  respect to the current page(see reference in clip)	  *)
(*									  *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*									  *)
(**************************************************************************)
begin
    c := [];
    if x < leftboundary then
	c := [left]
    else if x > rightboundary then c:= [right];

    if y < 0 then 
	c := c + [bottom]
    else if y > MAXY then
	c := c + [top];

end;

begin
    code(x1,y1,c1);
    code(x2,y2,c2);

    onpage := true;
    while ((c1 <> []) or (c2 <> [])) and (onpage) do begin
	if (c1*c2) <> [] then
	    onpage := false
	else begin
	    c := c1;
	    if c = [] then
		c := c2;
	
	    if left in c then begin
		y := y1 + (y2 - y1) * (leftboundary - x1) / (x2-x1);
		x := leftboundary;
		end
	    else if right in c then begin			
		y := y1 + (y2-y1) * (rightboundary - x1) / (x2-x1);
		x := rightboundary;
		end
	    else if bottom in c then begin
		x := x1 + (x2-x1) *  (0 -y1) / (y2-y1);
		y := 0;
		end
	    else if top in c then begin
		x := x1 + (x2-x1) * (MAXY-y1) / (y2-y1);
		y := MAXY;
		end;
	    if (c = c1) then begin
		x1 := trunc(x+0.5);
		y1 := trunc(y+0.5);
		code(trunc(x+0.5),trunc(y+0.5),c1);
		end				(*update the changed coords *)
						(*and get a new code        *)
	    else begin
		x2 := trunc(x+0.5);
		y2 := trunc(y+0.5);
		code(trunc(x+0.5),trunc(y+0.5),c2);
	        end;				(*update the changed coords *)
						(*and get a new code        *)
						(*This algorithm was taken  *)
						(*from Newman/Sproull,      *)
						(*Principles of Interactive *)
						(*Graphics, page 66-67      *)
	    end;
	end;
end;



procedure iArccross;
(**************************************************************************)
(* procedure iArccross(Boxptr:TreeNodePtr; level:TreeNodeList; 		  *) 
(* 			posadj: integer;above:boolean,condensed:boolean); *)
(*  									  *)
(*  									  *)
(* Input parameters                                                       *)
(*   Boxptr	- Parent node (search its children)                       *)
(*   xpos	- x coordinate of the upper left corner of the parent node*)
(*   ypos	- y coordinate of the upper left corner of the parent node*)
(*   posadj     - offset of the x coordinate				  *)
(*   above	- true if parent can be on the page above                 *)
(*   condensed  - true if condensed mode				  *)
(*                                                                        *)
(* Function	- iArccross draws arcs from Boxptr to all of Boxptr's     *)
(*		  sons.  It only draws the part of the arc that falls     *)
(*		  on the current page.  It is used to print arcs where    *)
(*		  only a piece of the arc lies on the page		  *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
var 
    tmpptr :PattrList;
    x,y,srcx,srcy: integer;
    onpage : boolean;

begin
    tmpptr := Boxptr^.Pattribs;
    srcy := iconvertY(level^.Ycoord) - 
				iconvertYdist(Boxptr^.BoxHt);
				(*get the y position of the parent box 	*)

    if (level^.Ycoord > level^.Next^.Ycoord) and above then 
	   srcy := srcy + MAXY;
				(*if the parent box if above the current*)
				(*page then convert to above page coords*)

    while tmpptr <> nil do begin
	if not condensed then
	    srcx := iconvertX(Boxptr^.Xcoord + findparentpos(tmpptr^.Value) + 
							posadj) 
				(*find the position of the pointer in   *)
				(*the parent node 			*)
	else (*condensed mode*)
	    srcx := iconvertX(Boxptr^.Xcoord + Boxptr^.BoxWidth + posadj);
				(*find the middle of the box if condensed *)
				(*mode					  *)

	iDrawPointerArcs(srcx,srcy,tmpptr,Boxptr,level^.Next,posadj);	
				(*draw arcs on this page to sons	*)

	tmpptr := tmpptr^.Next;
	end;
end; (*iArcCross*)


procedure iDrawPointerArcs;
(**************************************************************************)
(*  									  *)
(* procedure iDrawPointerArcs(srcx,srcy:integer; tempPattr: PattrList;    *)
(*		Boxptr:TreeNodePtr; level:TreeNodeList; posadj:integer);  *)
(*		external; 						  *)
(*  									  *)
(* Input parameters                                                       *)
(*   srcx	- x value of parent node 				  *)
(*   srcx	- y value of parent node                                  *)
(*   tempPattr  - first pointer field of the parent                       *)
(*   Boxptr	- pointer to the parent node  				  *)
(*   level	- pointer to the header node for the level after the      *)
(*                parent node level					  *)
(*                                                                        *)
(*  Function    - iDrawPointerarc draws all pointer arcs from the source   *)
(*		  node to its children.					  *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
var
    tmppattr :TreeNodePtr; 
    arcx,arcy,ycoord,x,y: integer;
    onpage :boolean;

begin
    x := srcx;
    y := srcy;
    arcx := iconvertX(tempPattr^.Value^.Xcoord + tempPattr^.Value^.BoxWidth 
			div 2 + posadj);
				(*find x position of first pointer arc   *)
    if level^.Ycoord = 0 then
	ycoord := iconvertY(4) - MAXY 
    else
        ycoord := iconvertY(level^.Ycoord);
				(*if the top node of next page then give *)
				(*fixed value, else give actual position *)
    
    if ycoord > srcy then
	ycoord := ycoord - MAXY;
				(*if y coordinate > parent y coordinate  *)
				(*then decrement to fix			 *)
    
    arcy := ycoord;
    clip(x,y,arcx,arcy,onpage);
				(*clip the arc to the page		 *)
    if onpage then begin
        move(x,y);
	cont(arcx,arcy);
	end;
				(*draw arc if on the page		 *)

    (*if the node is a sequence or set then draw arcs to all members of  *)
    (*the sequence or set						 *)
    if (tempPattr^.Value^.tag = SeqNode) or (tempPattr^.Value^.tag = SetNode)
               or (tempPattr^.Value^.tag = SeqValue) or 
	               (tempPattr^.Value^.tag = SetValue) then begin
	tmppattr := tempPattr^.Value;
	while not (last in tmppattr^.Seqsetpos) do 
           	begin
		x := srcx;
    		y := srcy;
		arcx := iconvertX(tmppattr^.Next^.Xcoord + 
                           tmppattr^.Next^.BoxWidth div 2 + posadj);
    		arcy := ycoord;
		clip(x,y,arcx,arcy,onpage);
		if onpage then begin
    		    move(x,y);
		    cont(arcx,arcy);
		    end;
		tmppattr := tmppattr^.Next;
		end; 
	end; (*if *)
end; (*drawpointerarc*)


procedure iDrawtoParArc;
(**************************************************************************)
(* procedure iDrawtoParArc(top:boolean;srcx,srcy:integer;		  *)
(*		Boxptr:TreeNodePtr;prevlevel:TreeNodeList;		  *)
(*		posadj:integer,condensed:boolean);			  *)
(*  									  *)
(* Input parameters                                                       *)
(*   top	- true if at top of page				  *)
(*   srcx	- x coordinate of the upper left corner of the node       *)
(*   srcy       - y coordinate of the upper left corner of the node       *)
(*   Boxptr	- node of the tree to print  parent arc                   *)
(*   prevlevel	- pointer to the level of the parent node		  *)
(*   posadj	- add to x coordinate to get current x position 	  *)
(*   condensed  - true if condensed mode				  *)
(*                                                                        *)
(* Function	- iDrawtoParArc - draws an arc on the current page towards*)
(*		  the parent node					  *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
var
	arcx,arcy,pos:integer;
	onpage:boolean;

begin
    if (prevlevel^.Ycoord < prevlevel^.Next^.Ycoord) then
        arcy := iconvertY(prevlevel^.Ycoord) - 
		iconvertYdist(Boxptr^.ArcSource^.BoxHt) 
    else
	arcy := MAXY + iconvertY(prevlevel^.Ycoord) - 
		iconvertYdist(Boxptr^.ArcSource^.BoxHt); 
			(*calculate y position of bottom of parent box	*)
    if not condensed then
        arcx:=iconvertX(Boxptr^.ArcSource^.Xcoord 
				+ findparentpos(Boxptr) + posadj)
			(*calculate x position of pointer in parent box *)
    else (*condensed mode*)
        arcx:=iconvertX(Boxptr^.ArcSource^.Xcoord + 
			Boxptr^.ArcSource^.BoxWidth  + posadj);
			(*if condensed mode find middle of parent *)


    if (arcx < leftboundary) or (arcx > rightboundary) or top then begin
        clip(srcx,srcy,arcx,arcy,onpage);
        if onpage then begin
    	   move(srcx,srcy);
	   cont(arcx,arcy);
	   end;
	end;
			(*if the parent is off the page *)
end;


procedure iPrintHeader;
(**************************************************************************)
(*  									  *)
(* procedure iPrintHeader(row,column:integer);external;			  *)
(*  									  *)
(* Input parameters                                                       *)
(*	-row - current row in multipaged grid				  *)
(*	-column  - current column in multipaged grid			  *)
(*                                                                        *)
(* Function - This procedure prints the row and column number of the      *)
(* 		current page and prints the cutting dots		  *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
var
    tempstring : strarray1;

begin
    move(leftboundary + 2, iconvertY(0));
    cont(leftboundary,iconvertY(0));
    cont(leftboundary,iconvertY(1));
    move(leftboundary + 2, 0);
    cont(leftboundary,0);
    cont(leftboundary,1);
    move(rightboundary - 2, iconvertY(0));
    cont(rightboundary,iconvertY(0));
    cont(rightboundary,iconvertY(1));
    move(rightboundary - 2, 0);
    cont(rightboundary,0);
    cont(rightboundary,1);
				(*put in cutting edges *)

    move(leftboundary,iconvertY(-4));
    tempstring[1]:= chr(row div 10 + 48);
    tempstring[2]:= chr(row mod 10 + 48);
    tempstring[3]:= ':';
    tempstring[4]:= chr(column div 10 + 48);
    tempstring[5]:= chr(column mod 10 + 48);
    ilabel(tempstring,5);
				(*put in row column header *)
end;
