{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/convertcoords.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 


(**************************************************************************)
(*									  *)
(*  This file contains the functions to convert the text coordinates      *)
(*  into plot or PostScript coordinates.  The routines are the following: *)
(*	iconvertX - convert x coordinates				  *)
(* 	iconvertY - convert y coordinates				  *)
(*	iconvertYdist - convert y distances				  *)
(*	ifindspace - find number of characters in a range of plot or      *) 
(*                   PostScript coords                                    *)
(*									  *)
(**************************************************************************)
const

#include "globalconst.h"

type
 
#include "globaltypes.h"

#include "iArccross.h" 
#include "convertcoords.h"

var

#include "globals.h"


function iconvertX;
(**************************************************************************)
(*  									  *)
(* function iconvertX(x:integer):integer;				  *)
(*									  *)
(*  									  *)
(* Input parameters                                                       *)
(*    x - x coordinate in text space				  *)
(*                                                                        *)
(* Function - This rountine converts an x coordinate in text space to     *)
(*		an x coordinate in plot or PostScript			  *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
begin
	iconvertX := trunc((x * (MaxXY / uwidth)) + 0.5);  
end;

function iconvertY;
(**************************************************************************)
(*  									  *)
(* function iconvertY(y:integer):integer;				  *)
(*									  *)
(*  									  *)
(* Input parameters                                                       *)
(*    y - y coordinate in lineprinter space				  *)
(*                                                                        *)
(* Function - This rountine converts an y coordinate in text    space to  *)
(*		an y coordinate in plot or PostScript                     *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
begin
	iconvertY := MaxXY - trunc(y * (MaxXY / uheight)+0.5);
end;

function iconvertYdist;
(**************************************************************************)
(*  									  *)
(* function iconvertYdist(y:integer):integer;				  *)
(*									  *)
(*  									  *)
(* Input parameters                                                       *)
(*    y - y coordinate in lineprinter space				  *)
(*                                                                        *)
(* Function - This function returns the distance between the given (y)    *)
(*		number of lines in y					  *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
begin
	iconvertYdist := y * (MaxXY div trunc(uheight / 2+0.5)) 
end;

function ifindspace;
(**************************************************************************)
(*  									  *)
(* function ifindspace(xpos,boundary:integer):integer;			  *)
(*									  *)
(*  									  *)
(* Input parameters                                                       *)
(*    xpos - xposition of the right edge of the node			  *)
(*    boundary - x position of the boundary of the page			  *)
(*                                                                        *)
(* Function - This function returns the number of characters between the  *)
(*		xpos given and the boundary.  This is used for multiple   *)
(*		paging.							  *)
(*                                                                        *)
(* Programmer	: Dore Rosenblum                                          *)
(* Written	: 3/23/84                                                 *)
(*                                                                        *)
(**************************************************************************)
var 
	space :integer;
begin
	space := (boundary - xpos) div widthconstant;
	if (space < 15) then
		space := space + 1;
				(*if the space is less than 15 then      *)
				(*add one because a character is not     *)
				(*exactly equal to 2 plot spaces         *)
	ifindspace := space;
end;
