{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/buildtree.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const 
#include "globalconst.h"

type
#include "globaltypes.h"

#include "TopDown.h"

procedure BuildSubtree;

(***************************************************************************)
(*  procedure BuildSubtree(rootnode:TreeNodePtr; var Subtree: TreeNodeList *)
(* 	var lastlevel: TreeNodeList; var firstn, lastn: TreeNodePtr; var   *)
(*	region, treeh, sectw1, sectw2, secth1, secth2: integer); external; *)
(*									   *)
(*  Input parameters							   *)
(*	rootnode 	- root node of subtree				   *)
(*									   *)
(*  Output parameters							   *)
(*	Subtree		- HeaderNode of the subtree created     	   *)
(*	lastlevel	- last level of the subtree		 	   *)
(*	firstn, lastn	- leftmost and rightmost nodes at level below      *)
(*			  lastlevel that are sons of nodes in the subtree. *)
(* 			  Firstn, lastn, and nodes between them are roots  *)
(*			  of subtrees to be printed later.                 *)
(*	region		- region into which subtree is tentatively placed  *)
(*	treeh		- height of subtree				   *)
(*	sectw1, sectw2, secth1, secth2 - widths and heights of regions 1   *)
(*			  and 2.					   *)
(*									   *)
(*  Purpose  								   *)
(*	Buildtree creates a subtree to be placed on the  page.  The        *)
(*    largest subtree that may fit into region1 (beside other subtrees    *)
(*    of a section) or region2 (a new section of the page) is created.     *)
(*    To determine how much of the subtree can fit into the region the     *)
(*    height and width of the subtree are compared to the region's height  *)
(*    and width.  The subtree's height is known exactly, but the width is  *)
(*    only an estimate equal to the sum of the node BoxWidths + space      *)
(*    between the nodes.  This estimate is correct in many cases and is    *)
(*    never larger than the actual tree width.                             *)
(*    	If region1 = region2, BuildSubtree returns the largest subtree of  *)
(*    the root node that it estimates will fit into the region.  If region *)
(*    1 is not equal to region2, BuildSubtree chooses to put the subtree   *)
(*    in region2 if more of the subtree can fit in region2 than region1.   *)
(*    Otherwise, region1 is tentatively chosen for the subtree.            *)
(*									   *)
(* Programmer:	Nancy Butler						   *)
(* Written:	4/4/85							   *)
(***************************************************************************)


var
   oldtreeh,             	(* treeh before current level is added	   *)
   treew 	: integer;	(* width of current level - sum of node widths*)
   currhead 	: TreeNodeList; (* HeaderNode of current level of subtree  *)
   currnode,			(* node under consideration		   *)
   lastwithson,			(* last node of current level with a son   *)
   firstwithson : TreeNodePtr;  (* first node of current level with a son  *)
   putinr2,			(* true if decide to put subtree in region 2*)
   sonfound,			(* true if any examined node of current level
				   has a son				   *)
   cont1,			(* loop continuation indicators            *)
   cont2	: boolean;

procedure CreateSubheader;

(*  The HeaderNode for the root of the subtree is created and initializations*)
(*	for building a subtree are done.				     *)

   var nextp : PattrList;
   begin
   new (currhead);
   currhead^.First	:= rootnode;
   currhead^.Last	:= rootnode;
   currhead^.MaxBoxHt	:= rootnode^.BoxHt;
   currhead^.Next	:= nil;
   treeh	:= (rootnode^.BoxHt* 2) + 8 ; (* 4 spaces above and 4 below a 
			subtree for subtree numbering 			*)
   oldtreeh 	:= treeh;
   treew	:= rootnode^.BoxWidth;
   if treew > sectw1 then  
      begin
      sectw1 := sectw2;
      secth1 := secth2;
      region := 2;
      end;
   rootnode^.ArcSource := nil;	(* signals printing subroutines not to draw 
				   arcs from parent to this node *)
   firstn	:= nil;
   lastn 	:= nil;
   lastwithson	:= nil;
   firstwithson	:= nil;
   sonfound 	:= false;
   cont1	:= false;
   cont2	:= false;
   if not (rootnode^.Duplicate) then
      if not((rootnode^.tag = SeqValue) or (rootnode^.tag = SetValue)) then
	 if rootnode^.Pattribs <> nil then
	    begin
	    sonfound := true;
	    cont1    := true;
	    cont2    := true;
	    firstn   := rootnode^.Pattribs^.Value;
	    nextp    := rootnode^.Pattribs;
	    while nextp^.Next <> nil do
	       nextp := nextp^.Next;
	    lastn    := nextp^.Value;
	    if lastn^.tag <> RegularNode then
	       while not(last in lastn^.Seqsetpos) do
		   lastn := lastn^.Next;
	    end;
   lastlevel := currhead;
   Subtree   := currhead;
   end;


procedure MakeHeadNode;

(*  Creates a HeaderNode for a level of the subtree       *)

   begin
   new(currhead);
   currhead^.First	:= firstn;
   currhead^.Last	:= lastn;
   currhead^.MaxBoxHt	:= firstn^.BoxHt;
   treeh		:= treeh + (currhead^.MaxBoxHt *2) +4;
			(* on the lineprinter a node requires twice the
			   number of lines of text + 1 to draw.  3 lines
			   are placed between levels for arc drawing. *)
   currhead^.Next	:= nil;
   treew	:= -6;   
   sonfound	:= false;
   lastwithson  := nil;
   firstwithson := nil;
   currnode	:= firstn;
   end;

procedure AddNextNode;

(*  Updates ongoing calculation of treeh, treew, lastwithson,    *)
(*     firstwithson, sonfound, and  currhead^.MaxBoxHt.  	 *)
   
   begin
   if currnode^.tag = RegularNode then
      treew := treew + currnode^.BoxWidth + 6
   else
      if not ( last in currnode^.Seqsetpos) then
	 treew := treew  + currnode^.BoxWidth + 4
      else
	 treew := treew + currnode^.BoxWidth + 6;
   if currnode^.BoxHt > currhead^.MaxBoxHt then
      begin
      treeh := oldtreeh + (currnode^.BoxHt *2) + 4;
      currhead^.MaxBoxHt := currnode^.BoxHt;
      end;
   if (currnode^.tag = RegularNode) or (currnode^.tag = SeqNode) or 
      (currnode^.tag = SetNode) then
      if currnode^.Pattribs <> nil then
	 begin
	 lastwithson := currnode;
	 if not( sonfound) then
	    begin
	    sonfound := true;
	    firstwithson := currnode;
	    end;
	 end;
   if currnode = lastn then
      currnode:= nil 
   else
      currnode:=currnode^.Next;
   end;

procedure AddCurrentlevel;

(*  Adds the current level to the subtree.  Currhead is added to the      *)
(*	list of subtree HeaderNodes.  Lastlevel, oldtreeh, firstn, and    *)
(*      lastn are updated.					 	  *)

   var nextp : PattrList;
   begin
   currhead^.Prev := lastlevel;
   lastlevel^.Next := currhead;
   currhead^.Next  := nil;
   lastlevel 	:= currhead;
   oldtreeh     := treeh;
   if sonfound then
      begin
      firstn 	:= firstwithson^.Pattribs^.Value;
      nextp	:= lastwithson^.Pattribs;
      while nextp^.Next <> nil do
         nextp := nextp^.Next;
      lastn    := nextp^.Value;
      if lastn^.tag <> RegularNode then
      while not(last in lastn^.Seqsetpos) do
         lastn := lastn^.Next;
      end
   else
      begin
      firstn := nil;
      lastn  := nil;
      end;
   end;

procedure AddtoRegion(reg,loopnum: integer);

(*  The subtree is added to a region - region is set to 1 or 2. Treeh is set *)
(*	to the tree height before consideration of the current level which *)
(*	was not added.							   *)

   begin
   treeh:= oldtreeh;
   if reg = 1 then
      region := 1
   else 
      region := 2;
   if loopnum = 1 then
      cont1:= false
   else
      cont2:= false;
   end;

(*******************  Body of procedure BuildSubtree  ******************)

   begin 	
   region:= 1;
   CreateSubheader;
   if sectw1 = sectw2 then             (* region1 = region2 *)
      while cont1 do
	 begin
	 MakeHeadNode;
	 while (treew <= sectw1) and  (currnode <> nil) and
	       (treeh <= secth1) do
	    AddNextNode;
	 if (treew <= sectw1) and (treeh <= secth1) then  
	    begin
	    AddCurrentlevel;
	    if firstn = nil then      	(* entire subtree has been handled *)
	       AddtoRegion(region,1);
	    end
	 else
            AddtoRegion(region,1);      (* add to region1 without currlevel *)
	 end
      else    			(* sectw1 <> sectw2, region1 <> region2 *)
	 while cont1 do
	    begin
	    putinr2 := false;
	    MakeHeadNode;
	    while (currnode <> nil) and (treew <= sectw1) and 
	           (treeh <= secth1) do
	        AddNextNode;
	    if (treew <= sectw1) and (treeh <= secth1) then  
	        begin
	        AddCurrentlevel;
	        if firstn = nil then
		   AddtoRegion(1,1);
	        end
	     else
		(*  This code decides whether to put the tree in region1 or 
		    region2. The tree will be put in region 2 if more of it 
 	 	    will fit in region 2 than in region 1.    *)

		if (treeh > secth2) or (treew > sectw2) then
		   AddtoRegion(1,1)    (* current subtree won't fit in reg2 *)
		else
                   begin
                   cont1:= false;
		   while cont2 do
		      begin
		      while (treew <= sectw2) and (currnode <> nil) and
			    (treeh <= secth2) do
			 AddNextNode;
	              if (treeh <= secth2) and (treew <= sectw2) then
			 begin
			 AddCurrentlevel;
			 if firstn <> nil then
			    MakeHeadNode;
			 putinr2 := true;   (* another level can be added to
					       the subtree if put in reg2 so
					       place it there.            *)
			 if firstn = nil then
			    AddtoRegion(2,2);
			 end
		      else
			 if putinr2 then 
			    AddtoRegion(2,2)
			 else
			    AddtoRegion(1,2);
	              end;
                   end;
	     end;  
   end;
