{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/TopDown.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const 
#include "globalconst.h"

type
#include "globaltypes.h"

#include "TopDown.h"
#include "plot.h"

var
#include "globals.h"

procedure TopDown;

(***************************************************************************)
(* procedure TopDown (start: TreeNodeList, pagewidth, pageheight: integer  *)
(*	device: devices; cond: boolean );				   *)
(*									   *)
(* Input parameters							   *)
(*	start		- first Header node of the tree created by Maketree*)
(*	pagewidth 	- width of the output page			   *)
(* 	pageheight	- height of the output page			   *)
(*	device		- output device,lineprinter,plot,PostScript        *)
(*	cond		- if true, condensed mode; otherwise full mode	   *)
(*									   *)
(* Purpose								   *)
(*	The tree is printed in paged output format.  The tree is broken    *)
(*   up into subtrees that will fit together on a page.  The subtrees are  *)
(*   placed on the page in breadth-first order.  Procedure BuildSubtree    *)
(*   builds a subtree to a depth that could fit in the currently available *)
(*   space on the page based on the subtree's known height and estimated   *)
(*   width.  Procedure PlaceOnPage calls procedure SetXcoords on the       *)
(*   subtree to determine its true width. [Since SetXcoords does a depth-  *)
(*   first traversal of a tree it is positioning, the buildsubtree step    *)
(*   is required in order to determine the leaf level of the subtree       *)
(*   before calling SetXcoords.]   If the true width will not fit  	   *)
(*   in the current space on the page, either the next section of the page *)
(*   is used or levels of the subtree are removed.  Eventually the subtree *)
(*   will be fit onto a page.  All subtrees below the bottom nodes of the  *)
(*   current subtree are added to the list of subtrees awaiting placement. *)
(*   The next region of the page in which to put a subtree is then         *)
(*   determined.  If the page has been completed, procedure PrintPage is   *)
(*   called to print out the current page.  The building, placement, and   *)
(*   printing of subtrees continues until the list of subtrees is empty.   *)
(*									   *)
(* Programmer:	Nancy Butler						   *)
(* Written:	4/3/85							   *)
(***************************************************************************)

var sectw1,	(* there are two possible regions of the page in which the *)
    secth1,     (*    subtree may be placed, beside the last subtree or    *)
    sectw2,     (*    below it - thus beginning a new section.  sectw1,    *)
    secth2,     (*    secth1 are the width and height of region 1; sectw2  *)
                (*    and secth2 are the width and height of region 2.     *)
    region,     (* either 1 or 2 depending on the region chosen for the tree*)
    trcount,    (* count of the number of subtrees in a horizontal section *)
	 	(*    of the page.					   *)
    section,    (* count of the number of horizontal sections              *)
    pagenum,    (* number of the output page                               *)
    treeh,      (* height of a subtree					   *)
    currlsub,   (* level in SubTrlist from which last subtree root was taken*)
    lastlsub  : integer;  (* last level in SubTrlist containing subtrees   *)
    rootnode,   (* root node of a subtree				   *)
    lastn,	(* rightmost son to be added to SubTrlist                  *)
    firstn   : TreeNodePtr;   	(* leftmost son to be added to SubTrlist   *)
    SubTrlist: SubTreeList;	(* list of subtree roots awaiting processing*)
    sublnode : SubListNodePtr;  (* the first node of the subtree list      *)
    Prlist   : PrintList;       (* list of subtrees to be printed on page  *)
    lastlevel,		(* leaf level of a subtree created by BuildSubtree *)
    tree     : TreeNodeList;	(* first HeaderNode of the subtree created *) 
    prpage   : boolean; (* if true a page is printed                       *)
    i	     : integer; (* counter  *)

    begin
	(*  Initializations  *)
    pagewidth:=pagewidth-3;  (* leave room for seq and set indicators *)
    sectw1:= pagewidth;	 sectw2:= pagewidth;
    secth1:=pageheight;  secth2:= pageheight;
    trcount:= 0;   section:= 1;   treeh:= 0;
    pagenum:=0;
    prpage := false;
    currlsub := 1;
    lastlsub := 1;
    new(sublnode);
    SubTrlist[1]:= sublnode;
    SubTrlist[1]^.First:= start^.First;
    SubTrlist[1]^.Last:= start^.First;
    SubTrlist[1]^.Next:= nil;
    for i:= 2 to maxsublistindex do
       SubTrlist[i]:= nil;
    for i:=1 to maxprlistindex do
       begin
       Prlist[i].Front:= nil;
       Prlist[i].Back:= nil;
       Prlist[i].MaxHt:= 0;
       end;
    rootnode:= GetNextSubtree(SubTrlist,currlsub,lastlsub);

	(* initializations for PostScript or plot output  *)
    if (device = PostScript) or (device = plot) then 
       begin
       openplDvi;
       spaceDvi(0,0,MaxXY,MaxXY);
       end;

    while rootnode <> nil do
       begin
             
       BuildSubtree(rootnode,tree,lastlevel,firstn,lastn,region,treeh,sectw1,
		sectw2, secth1,secth2);
       PlaceOnPage(Prlist,tree,pagewidth,pageheight,lastlevel,firstn,lastn,
		region, treeh,sectw1,sectw2,secth1,secth2, trcount, section);
       if firstn <> nil then
          AddtoSublist(firstn,lastn,SubTrlist,lastlsub);
       rootnode := GetNextSubtree(SubTrlist,currlsub,lastlsub);
       DetermineNextRegion(rootnode, pagewidth, pageheight, sectw1,sectw2,
		secth1,secth2, trcount,section,prpage);
       if prpage then
  	  begin
	  PrintPage(Prlist,pagewidth, pageheight, device, cond, pagenum);
	  prpage:=false;
          for i:=1 to maxprlistindex do
             begin
             Prlist[i].Front:= nil;
             Prlist[i].Back:= nil;
             Prlist[i].MaxHt:= 0;
             end;
          end;
       end;
    if Prlist[1].Front <> nil then
       PrintPage(Prlist,pagewidth, pageheight, device, cond, pagenum);
    end;

