{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/TopDown.h 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const 
      maxsublistindex = 100;
      maxprlistindex = 30;

type 
            
    SubListNodePtr = ^ SubListNode;
    SubListNode  = record
	First: TreeNodePtr;
	Last : TreeNodePtr;
	Next : SubListNodePtr;
	end;
    SubTreeList = array [1..maxsublistindex] of SubListNodePtr;

    PrintListNodePtr = ^PrintListNode;
    PrintListNode = record
	SubtrRoot: TreeNodeList;
	Maxpos   : integer;
	Minpos   : integer;
	Next     : PrintListNodePtr;
	end;
    PrintList = array [1..maxprlistindex] of record
	Front    : PrintListNodePtr;
	Back     : PrintListNodePtr;
	MaxHt    : integer;
	end;

procedure TopDown (start:TreeNodeList;  pagewidth,         
                  pageheight:integer; device:devices; cond:boolean);  
		  external;

procedure BuildSubtree(var rootnode: TreeNodePtr; var Subtree: TreeNodeList; 
		var lastlevel: TreeNodeList;
		var firstn, lastn: TreeNodePtr;
		var region, treeh, sectw1, sectw2, secth1, secth2: integer);
		external;

procedure PlaceOnPage (var Prlist: PrintList; tree: TreeNodeList; 
		vpagew,vpageh: integer;
		var lastlevel: TreeNodeList; var firstn, lastn: TreeNodePtr;
		var region, treeh, sectw1, sectw2, secth1, secth2,
		trcount, section : integer); external;

procedure DetermineNextRegion(rootnode: TreeNodePtr; vpagew, vpageh: integer; 
		var sectw1, sectw2, 
		secth1, secth2, trcount, section: integer; 
		var prpage: boolean); external;

procedure PrintPage(Prlist: PrintList; vpagew, vpageh: integer; device:
		devices; cond:boolean; var pagenum: integer); external;

procedure AddtoSublist(firstn, lastn: TreeNodePtr; var SubTrlist: SubTreeList;
		var lastlevel: integer); external;

function GetNextSubtree(var SubTrList: SubTreeList; var currlevel:integer;
		lastlevel: integer): TreeNodePtr; external;


