{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/SubNumber.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const
#include "globalconst.h"
type
#include "globaltypes.h"
#include "SubNumber.h"

procedure Charconvert; 

(******************************************************************************)
(*  procedure Charconvert (numb:integer;  var str: rString; var j:integer);   *)
(*									      *)
(* Input Parameters							      *)
(*	numb - number to be converted to character string representation      *)
(*		numb must be < 10,000 and > 0.				      *)
(*									      *)
(* Input-Output Parameters						      *)
(*	str	- string into which to put character representation of numb   *)
(*	j	- j + 1 is position in str to begin the character repr of numb*)
(*		  On return, j is index of last position in str used.         *)
(*									      *)
(* Purpose								      *)
(*	Numb is converted to character representation and placed into         *)
(* string, str, beginning at position j+1 of str. 			      *)
(*									      *)
(* Programmer:	Nancy Butler						      *)
(* Written:	4/17/85							      *)
(******************************************************************************)


   var i,x: integer;
   begin
   i:=1;
   x:=1000;
   while x>0 do
      begin
      if ((numb div x) <> 0) or (i <> 1) then
	begin
	str.value[i + j]:= chr((numb div x) + 48);
	numb:=numb mod x;
	i:= i+1;
	end;
     x:=x div 10;
     end;
   str.length := i + j -1;
   j:=i + j - 1;
   end;


procedure RootNumb;
(******************************************************************************)
(* procedure RootNumb(node:TreeNodePtr, var rootstr:rString);		      *)
(*									      *)
(* Input Parameters							      *)
(*	node -  node for which identification number is desired in character  *)
(*		string format.                				      *)
(*									      *)
(* Output Parameters							      *)
(*	rootstr - string into which to put character representation of root   *)
(*		  idenfication number.					      *)
(*									      *)
(* Purpose								      *)
(*	The Level and Subtrnum of 'node' are converted to character string    *)
(* representation and placed in rootstr.  If node is a member of a sequence   *)
(* or set, node's position number in the sequence or set is added to rootstr. *)
(*									      *)
(* Programmer:	Nancy Butler						      *)
(* Written:	4/17/85							      *)
(******************************************************************************)

    var j: integer;
    begin
    j:=0;
    Charconvert(node^.Level,rootstr,j);
    j:=rootstr.length+1;
    rootstr.value[j]:=':';
    Charconvert(node^.Subtrnum,rootstr,j);
    if node^.tag <> RegularNode then
	begin
	j:=rootstr.length + 1;
	rootstr.value[j]:= '.';
	Charconvert(node^.SetSeqnum,rootstr,j);
	end;
    end;
