{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/Printdriver.h 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const maxpagelen = 100;  (* Maximum number of lines on a page for the 
                              lineprinter                               *)
      maxpagewidth = 132;  (* Maximum number of characters on a line    *)

type 
      PageArray = array[1..maxpagelen, 1.. maxpagewidth] of char;
         (* a page of lineprinter output is stored in this array and later 
            printed out  *)
var
      Parray: PageArray;   (* page of lineprinter output                *)

procedure Printdriver (start:TreeNodeList; minpos, maxpos, pagewidth,         
                  pagelength:integer; device:devices; cond:boolean);  
		  external;

procedure iDrawBox(var Boxptr:TreeNodePtr; level,prevlevel:TreeNodeList;   
		posadj:integer; top:boolean; posinseq: seqset;    
		condensed,lastlevel:boolean);external;			 

procedure lDrawBox(Node:TreeNodePtr; level,prelevel:TreeNodeList;         
                  posadj:integer; top:boolean; posinseq:seqset; 
                  cond,lastlevel:boolean;pagewidth,pagelength:integer);external;					     
procedure Printout(pagelength,pagewidth,row,column:integer);external;
procedure ArrayInitialize(pagelength,pagewidth:integer);external;
