{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/PadFind.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const
#include "globalconst.h"
type
#include "globaltypes.h"

#include "PadFind.h"

function PadFind;
(*****************************************************************************)
(* 									     *)
(* function PadFind(Node: TreeNodePtr):integer;	     			     *)
(*									     *)
(* This procedure determines the size of the 'pad' to add to each pointer    *)
(*  field in order to make them evenly spaced across the bottom of a node.   *)
(*									     *)
(* Input - a pointer to the pointer fields for that node.                    *)
(* Output - the number of spaces to pad each field with.                     *)
(*									     *)
(* Programmer - Steven Konstant						     *)
(* Written - 4/10/84							     *)
(*									     *)
(*****************************************************************************)

var num,   (*the number of pointer fields to divide the space among*)
    len:integer; (*the amount of extra space                       *)
    Ptemptr:PattrList;

begin
  Ptemptr := Node^.Pattribs;	(*get the first pointer*)
  num:=0;
  len:=0;
  while Ptemptr<>nil do 
  begin
    num:= num + 1;
    len:= len + Ptemptr^.Name.length + 3;
    Ptemptr:= Ptemptr^.Next;
  end;
  len:= len + 1;
  PadFind:= (Node^.BoxWidth - len) div num
end; (*of function PadFind*)

